package kawigi.f;
import robocode.*;
import java.awt.geom.*;
import java.io.*;
import java.util.zip.*;
import java.awt.Color;
import java.util.*;

/**
 * FhqwhgadsMicro - short for Fhqwhgadshgnsdhjsdbkhsdabkfabkveybvf, small for Fhqwhgads.
 * Seeing how much Fhqwhgads fits into a Micro here...
 * * Version 1.0 - First version, looks pretty competitive against other Micros.  The only one I know of that
 *		gives it real headaches at this point is Spark (0.6).
 */
public class FhqwhgadsMicro extends AdvancedRobot
{
	static int currentDirection, direction = 1;
	static double latvel;
	static int nextTime;
	//I segment my statistics by acceleration, lateral velocity and distance into 31 buckets.  I took out the
	//wall segmentation because it accounts for too little of the total playing time against most bots (Although
	//it's hard to let go, because it was originally what got me to start beating Cigaret at the time I first did it)
	static int[][][][] stats = new int[3][3][13][31];
	static double x, y;
	static String name;
	
	public boolean out(double angle, double c)
	{
		return !(new Rectangle2D.Double(18D, 18D, getBattleFieldWidth()-36D,  getBattleFieldHeight()-36D)).contains(Math.sin(angle)*c+getX(), Math.cos(angle)*c+getY());
	}

	public void run()
	{
		setAdjustGunForRobotTurn(true);
		//Strong Bad colors!
		setColors(Color.red, Color.black, Color.green);
		turnRadarRight(Double.POSITIVE_INFINITY);
	}
	
	public void onScannedRobot(ScannedRobotEvent e)
	{
		double myx, myy;
		double distance;
		double absbearing;
		x = (myx = getX())+Math.sin(absbearing = getHeadingRadians() + e.getBearingRadians())*(distance = e.getDistance());
		y = (myy = getY())+Math.cos(absbearing)*distance;
		setAhead(currentDirection);
		setTurnRadarLeft(getRadarTurnRemaining());
		
		int rel = 90;
		if (distance < 300)
			rel = 90+currentDirection;
		if (out(Math.PI+absbearing, 50) || closeToCorner() || distance > 600)
			rel = 90-currentDirection;
		setTurnRight(e.getBearing()-rel);
		
		int bestindex = 15;
		//accl is basically ends up being 0 for not strongly accelerating/decelerating, 1 for accelerating, 2 for decelerating.
		//Fairly arbitrarily, this implementation checks for lateral acceleration/deceleration, not absolute like my other robots.
		int accl;
		if ((accl = (int)Math.round(Math.abs(latvel)-Math.abs(latvel = Math.sin(e.getHeadingRadians()-absbearing)*e.getVelocity()))) != 0)
			accl = (accl < 0)? 1 : 2;
		if (latvel != 0)
			direction = (latvel < 0)?-1:1;
		int[] current = stats[accl][(int)Math.abs(latvel/3)][(int)distance/100];
		int i=0;
		do
		{
			if (current[i] > current[bestindex])
				bestindex = i;
			i++;
		}
		while (i <= 30);

		//Now I'm using denergy as the power:
		double power;
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absbearing-getGunHeadingRadians()+Math.asin(9.256/(20-(power = Math.min(Math.min(e.getEnergy(), getEnergy())/4, 3))*3))*(bestindex/15.0-1)*direction));
		setFire(power);
		MicroBulletEvent mb;
		addCustomEvent(mb = new MicroBulletEvent());
		//eliminating the parameters (and even the whole constructor) turned out to be smaller.
		//Kind of weird doing so much dereferencing, but I guess it comes out just slightly smaller
		//than pushing everything onto the stack.  Also note that the array "current" is one I already had.
		mb.current = current;
		mb.direction = direction;
		mb.firetime = getTime();
		mb.startgunheading = absbearing;
		mb.startx = myx;
		mb.starty = myy;
		
		//the original Fhqwhgads movement, roughly:
		if (nextTime-- < 0)
		{
			currentDirection = (Math.random() < .5) ? 30 : -30;
			//I'll be like NekoNinja and assume my opponent is firing roughly the same power as I would.
			nextTime = (int)(distance/(30-4.5*power)*Math.random());
		}
		if (out(getHeadingRadians(), currentDirection))
			currentDirection = -currentDirection;
	}
	
	//returns true if I'm within 200 of any corner:
	private boolean closeToCorner()
	{
		int i=0;
		do
		{
			//feel free to use this if you can figure out what the heck it is.
			if (Point2D.distance(getX(), getY(), (i&1)*getBattleFieldWidth(), (i>>1)*getBattleFieldHeight()) < 200)
				return true;
			i++;
		}
		while (i < 4);
		return false;
	}
	
	//Thanks to PEZ for the idea to do the bullet like this.  I'll probably never do it in a larger bot
	//(because I think my method of interpolating the enemy's postion is the way to go), but I had already
	//taken that out of this bot for the sake of size.
	class MicroBulletEvent extends Condition
	{
		double startx, starty, startgunheading;
		long firetime;
		int direction;
		//why store a bunch of eventual indexes just to use them to index later?  This is pure geneous for
		//small codesize in highly segmented statistics:
		int[] current;
	
		public boolean test()
		{
			//One fundamental difference between this implementation and MiniBullet is that this one assumes our scanning is perfect and it doesn't interpolate position.
			if (Point2D.distance(x, y, startx, starty) <= 11*(getTime()-firetime))  	//could have hit now.
			{
				//now returns the index into my stat buffer instead of the normalized angle (which is figured out on a different max constant, btw).
				current[(int)Math.round((1+robocode.util.Utils.normalRelativeAngle(Math.atan2(x-startx, y-starty)-startgunheading)*direction)*15)]++;
				removeCustomEvent(this);
			}
			return false;
		}
	}
}