/*
 * Decompiled with CFR 0.152.
 */
package fala.robocode;

import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.HitRobotEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class FalaRobot
extends AdvancedRobot {
    private static final double HALF_PI = 1.5707963267948966;
    private static final double QUARTER_PI = 0.7853981633974483;
    double direction = 1.0;
    boolean enableCustomEvent = false;
    private double firePower = 1.0;
    private double distanceToEnemy;
    private double lastHeading;
    private long lastHighVelocity;
    private long lastLowVelocity;
    private double lastEnergy = 100.0;
    private int waitTurns = 0;
    private boolean ram = false;
    private double radar = 1.5707963267948966;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setMaxTurnRate(10.0);
        int turn = 0;
        while (true) {
            this.setTurnRadarRightRadians(this.radar);
            if (this.distanceToEnemy < 200.0) {
                if (this.waitTurns > 0) {
                    --this.waitTurns;
                } else {
                    this.setMaxVelocity(8.0);
                }
                if (this.ram) {
                    this.setAhead(100.0);
                } else {
                    this.setAhead(100.0 * Math.sin((double)turn * 0.1 * Math.PI));
                }
            } else {
                if (this.waitTurns > 0) {
                    --this.waitTurns;
                } else {
                    this.setMaxVelocity(7.0 + Math.sin((double)turn * 0.1 * Math.PI));
                }
                this.setAhead(100.0);
            }
            ++turn;
            this.fire(this.firePower);
        }
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        double bearingToEnemy = event.getBearingRadians();
        this.distanceToEnemy = event.getDistance();
        double enemyHeading = event.getHeadingRadians();
        double velocity = event.getVelocity();
        double absoluteBearing = bearingToEnemy + this.getHeadingRadians();
        double energy = event.getEnergy();
        double energyDifference = this.lastEnergy - energy;
        this.lastEnergy = energy;
        if (velocity > 0.0) {
            this.lastHighVelocity = event.getTime();
        }
        if (velocity < 0.0) {
            this.lastLowVelocity = event.getTime();
        }
        if (energyDifference >= 1.0 && energyDifference <= 4.0) {
            this.dodgeBulet(energyDifference, this.distanceToEnemy, bearingToEnemy);
        } else {
            this.setRobotTurn(this.distanceToEnemy, bearingToEnemy, energy);
        }
        this.setFirePower(this.distanceToEnemy);
        double headingDifference = enemyHeading - this.lastHeading;
        this.lastHeading = enemyHeading;
        double buletDist = Rules.getBulletSpeed((double)this.firePower);
        double vectorX = Math.sin(absoluteBearing) * this.distanceToEnemy;
        double vectorY = Math.cos(absoluteBearing) * this.distanceToEnemy;
        this.radar = Math.asin(Math.sin(Math.atan2(vectorX, vectorY) - this.getRadarHeadingRadians()));
        if (Math.abs(this.lastHighVelocity - this.lastLowVelocity) < 30L) {
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absoluteBearing - this.getGunHeadingRadians())));
            return;
        }
        int i = 0;
        while ((double)i < Point2D.distance(0.0, 0.0, vectorX, vectorY)) {
            vectorX += velocity * Math.sin(enemyHeading);
            vectorY += velocity * Math.cos(enemyHeading);
            enemyHeading += headingDifference;
            i = (int)((double)i + buletDist);
        }
        this.setTurnGunRightRadians(Math.asin(Math.sin(Math.atan2(vectorX, vectorY) - this.getGunHeadingRadians())));
    }

    private void setFirePower(double distanceToEnemy) {
        if (this.getEnergy() < 10.0) {
            this.firePower = 1.0;
        } else {
            this.firePower = 600.0 / distanceToEnemy;
            if (this.firePower > 3.0) {
                this.firePower = 3.0;
            }
        }
    }

    private void dodgeBulet(double buletPower, double distanceToEnemy, double bearingToEnemy) {
        if (this.ram) {
            return;
        }
        double normalbearingToEnemy = Math.abs(bearingToEnemy);
        if (normalbearingToEnemy < 0.7853981633974483 || normalbearingToEnemy > 2.356194490192345) {
            this.setTurnRightRadians(1.5707963267948966 * (bearingToEnemy / normalbearingToEnemy));
            this.setMaxVelocity(4.0);
            this.waitTurns = 5;
        } else {
            if (distanceToEnemy < 200.0) {
                this.setAhead(-100.0);
            } else {
                double velocity = this.getVelocity();
                velocity = velocity < 8.0 ? 8.0 : velocity / 2.0;
                this.setMaxVelocity(velocity);
            }
            this.waitTurns = 2;
        }
    }

    private void setRobotTurn(double distanceToEnemy, double bearingToEnemy, double enemyEnergy) {
        if (enemyEnergy + 30.0 < this.getEnergy()) {
            this.setTurnRightRadians(bearingToEnemy);
            this.ram = true;
            return;
        }
        this.ram = false;
        if (this.waitTurns == 0) {
            if (distanceToEnemy < 200.0) {
                this.setTurnRightRadians(1.5707963267948966 + bearingToEnemy);
            } else {
                this.setTurnRightRadians(bearingToEnemy);
            }
        }
    }

    private double velocityCorrection(double velocity, double velocityDifference) {
        if (!(velocity > 4.0) && (velocity += velocityDifference) > 4.0) {
            velocity = 4.0;
        }
        return velocity;
    }

    public void onHitRobot(HitRobotEvent event) {
    }
}

