/*
 * Decompiled with CFR 0.152.
 */
package xander.core.drive;

import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import xander.core.Resources;
import xander.core.RobotProxy;
import xander.core.drive.Direction;
import xander.core.drive.DistancingEquation;
import xander.core.drive.DriveBoundsFactory;
import xander.core.drive.DrivePrediction;
import xander.core.drive.DriveState;
import xander.core.log.Log;
import xander.core.log.Logger;
import xander.core.math.RCMath;
import xander.core.math.RCPhysics;
import xander.core.math.VelocityVector;
import xander.core.track.Snapshot;
import xander.core.track.Wave;

public class OrbitalDrivePredictor {
    private static final Log log = Logger.getLog(OrbitalDrivePredictor.class);
    private RobotProxy robotProxy = Resources.getRobotProxy();
    private double wallStick = 180.0;
    private Path2D.Double driveBounds;

    public OrbitalDrivePredictor() {
        this.driveBounds = DriveBoundsFactory.getRectangularBounds(this.robotProxy.getBattleFieldSize());
    }

    public OrbitalDrivePredictor(Path2D.Double driveBounds) {
        this.driveBounds = driveBounds;
    }

    public void setWallStick(double wallStick) {
        this.wallStick = wallStick;
    }

    public VelocityVector getSmoothedOrbitAngle(double targetSpeed) {
        double heading = this.robotProxy.getHeadingDegrees();
        if (this.robotProxy.getVelocity() < 0.0) {
            heading = RCMath.normalizeDegrees(heading + 180.0);
        }
        return this.getSmoothedOrbitAngle(heading, targetSpeed);
    }

    public VelocityVector getSmoothedOrbitAngle(double targetAngle, double targetSpeed) {
        double angleToCenter = RCMath.getRobocodeAngleToCenter(this.robotProxy.getX(), this.robotProxy.getY(), this.robotProxy.getBattleFieldSize());
        double offsetFromCenter = RCMath.getTurnAngle(angleToCenter, targetAngle);
        Direction direction = offsetFromCenter >= 0.0 ? Direction.COUNTER_CLOCKWISE : Direction.CLOCKWISE;
        double innerAngle = RCMath.normalizeDegrees(targetAngle + (double)(direction.getDirectionUnit() * 90));
        Point2D.Double innerCenter = RCMath.getLocation(this.robotProxy.getX(), this.robotProxy.getY(), 1000.0, innerAngle);
        return this.getSmoothedOrbitAngle(innerCenter, 100.0, direction, DistancingEquation.NO_ADJUST, targetSpeed);
    }

    public Direction getOribitalDirection(double x, double y) {
        double offsetFromCenter;
        double angleToCenter = RCMath.getRobocodeAngle(this.robotProxy.getX(), this.robotProxy.getY(), x, y);
        double heading = this.robotProxy.getHeadingDegrees();
        if (this.robotProxy.getVelocity() < 0.0) {
            heading = RCMath.normalizeDegrees(heading + 180.0);
        }
        return (offsetFromCenter = RCMath.getTurnAngle(angleToCenter, heading)) >= 0.0 ? Direction.COUNTER_CLOCKWISE : Direction.CLOCKWISE;
    }

    public static Direction getOribitalDirection(double x, double y, double rx, double ry, double velocity, double heading) {
        double offsetFromCenter;
        double angleToCenter = RCMath.getRobocodeAngle(rx, ry, x, y);
        if (velocity < 0.0) {
            heading = RCMath.normalizeDegrees(heading + 180.0);
        }
        return (offsetFromCenter = RCMath.getTurnAngle(angleToCenter, heading)) >= 0.0 ? Direction.COUNTER_CLOCKWISE : Direction.CLOCKWISE;
    }

    public VelocityVector getSmoothedOrbitAngle(Point2D.Double center, double distance, Direction direction, DistancingEquation distancingEquation, double targetSpeed) {
        Point2D.Double position = new Point2D.Double(this.robotProxy.getX(), this.robotProxy.getY());
        return this.getSmoothedOrbitAngle(center, distance, position, direction, distancingEquation, targetSpeed);
    }

    public VelocityVector getSmoothedOrbitAngle(Point2D.Double center, double distance, Point2D.Double position, Direction direction, DistancingEquation distancingEquation, double targetSpeed) {
        double retreatAngle;
        double facingAngle = RCMath.getRobocodeAngle(position.x, position.y, center.x, center.y);
        double tangentAngle = RCMath.normalizeDegrees(facingAngle - (double)(90 * direction.getDirectionUnit()));
        if (Math.abs(RCMath.getTurnAngle(tangentAngle, retreatAngle = RCMath.normalizeDegrees(tangentAngle - distancingEquation.getAdjustAngle(distance, null) * (double)direction.getDirectionUnit()))) > 90.0) {
            log.warn("Distancing equation causing drive angle out of proper range.  Unmodified tangent heading is " + Logger.format(tangentAngle) + "; Distancing heading is " + Logger.format(retreatAngle) + "; Distancing angle should not be more than 90 degrees offset from Tangent.");
        }
        return this.getWallStickSmoothedOrbitVector(position, direction, retreatAngle, targetSpeed);
    }

    public VelocityVector getWallStickSmoothedOrbitVector(Point2D.Double position, Direction direction, double desiredHeading, double desiredSpeed) {
        double smoothedAngle = desiredHeading;
        Point2D.Double advancedPosition = RCMath.getLocation(position.x, position.y, this.wallStick, desiredHeading);
        boolean inBounds = this.driveBounds.contains(advancedPosition);
        while (!inBounds) {
            smoothedAngle = RCMath.normalizeDegrees(smoothedAngle + (double)(direction.getDirectionUnit() * 2));
            advancedPosition = RCMath.getLocation(position.x, position.y, this.wallStick, smoothedAngle);
            inBounds = this.driveBounds.contains(advancedPosition);
        }
        return new VelocityVector(smoothedAngle, (float)desiredSpeed);
    }

    public boolean isOvershoot(Point2D.Double center, double distance, Direction direction, double targetHeadingFromCenterDegrees, Wave wave, DistancingEquation distancingEquation) {
        DriveState driveState = new DriveState(this.robotProxy);
        long time = this.robotProxy.getTime();
        long tup = wave.getTimeUntilHit(driveState.position.x, driveState.position.y, time);
        while (tup > 0L && driveState.velocity != 0.0) {
            this.advanceOrbitalDriveState(driveState, center, distance, direction, 1, 0.0, distancingEquation);
            tup = wave.getTimeUntilHit(driveState.position.x, driveState.position.y, ++time);
        }
        double headingFromCenter = RCMath.getRobocodeAngle(center.x, center.y, driveState.position.x, driveState.position.y);
        double offset = RCMath.getTurnAngle(targetHeadingFromCenterDegrees, headingFromCenter);
        if (direction == Direction.CLOCKWISE) {
            return offset > 0.0;
        }
        return offset < 0.0;
    }

    public void advanceOrbitalDriveState(DriveState driveState, Point2D.Double center, double distance, Direction direction, int ticks, double targetSpeed, DistancingEquation distancingEquation) {
        int i = 0;
        while (i < ticks) {
            VelocityVector smoothedVector = this.getSmoothedOrbitAngle(center, distance, driveState.position, direction, distancingEquation, targetSpeed);
            double targetHeading = smoothedVector.getRoboAngle();
            double targetVelocity = smoothedVector.getMagnitude();
            double targetTurnAngle = RCMath.getTurnAngle(driveState.heading, targetHeading);
            if (Math.abs(targetTurnAngle) > 90.0) {
                targetHeading = RCMath.normalizeDegrees(targetHeading + 180.0);
                targetVelocity = -targetSpeed;
                targetTurnAngle = RCMath.getTurnAngle(driveState.heading, targetHeading);
            }
            double turnThisTick = targetTurnAngle;
            double maxTurnRate = RCPhysics.getMaxTurnRate(driveState.getVelocity());
            if (targetTurnAngle > maxTurnRate) {
                turnThisTick = maxTurnRate;
            } else if (targetTurnAngle < -maxTurnRate) {
                turnThisTick = -maxTurnRate;
            }
            double velocityChangeThisTick = targetVelocity - driveState.velocity;
            double maxChangeRate = 1.0;
            if (driveState.velocity > 0.0 && targetVelocity < driveState.velocity || driveState.velocity < 0.0 && targetVelocity > driveState.velocity) {
                maxChangeRate = 2.0;
            }
            if (Math.abs(velocityChangeThisTick) > maxChangeRate) {
                velocityChangeThisTick = velocityChangeThisTick > 0.0 ? maxChangeRate : -maxChangeRate;
            }
            driveState.heading += turnThisTick;
            driveState.velocity += velocityChangeThisTick;
            driveState.position = RCMath.getLocation(driveState.position.x, driveState.position.y, driveState.velocity, driveState.heading);
            ++i;
        }
    }

    public DrivePrediction predictMaxPathBeforeBulletHit(Snapshot robotSnapshot, Direction direction, double bulletOriginX, double bulletOriginY, long currentBulletFlightTime, double bulletVelocity, double distance, DistancingEquation distancingEquation) {
        ArrayList<Point2D.Double> drivePath = new ArrayList<Point2D.Double>();
        DriveState driveState = new DriveState(robotSnapshot);
        drivePath.add(new Point2D.Double(driveState.getPosition().x, driveState.getPosition().y));
        Point2D.Double origin = new Point2D.Double(bulletOriginX, bulletOriginY);
        double bulletTravelDistance = bulletVelocity * (double)currentBulletFlightTime;
        double distanceToRobot = RCMath.getDistanceBetweenPoints(origin.getX(), origin.getY(), driveState.getPosition().x, driveState.getPosition().y) - 20.0;
        while (distanceToRobot > bulletTravelDistance) {
            bulletTravelDistance += bulletVelocity;
            this.advanceOrbitalDriveState(driveState, origin, distance, direction, 1, 8.0, distancingEquation);
            drivePath.add(new Point2D.Double(driveState.getPosition().x, driveState.getPosition().y));
            distanceToRobot = RCMath.getDistanceBetweenPoints(origin.getX(), origin.getY(), driveState.getPosition().x, driveState.getPosition().y) - 20.0;
        }
        return new DrivePrediction(driveState, drivePath);
    }
}

