/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.gun;

import apv.MovSim;
import apv.MovSimStat;
import florent.XSeries.Configuration;
import florent.XSeries.gun.GunStrategy;
import florent.XSeries.gun.patternrecognition.Scan;
import florent.XSeries.gun.patternrecognition.ScanStore;
import florent.XSeries.gun.virtual.GunWave;
import florent.XSeries.radar.Enemy;
import florent.XSeries.radar.Tracker;
import florent.XSeries.team.Xmen;
import florent.XSeries.utils.RobocodeTools;
import florent.stats.StatKeeper;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternMatchingGun
extends GunStrategy {
    private static final boolean DEBUG = false;
    private Xmen me;
    private Line2D.Double lineOfFire = new Line2D.Double();
    private Line2D.Double lineOfMovement = new Line2D.Double();
    private HashMap<String, ScanStore> stores;
    private Rectangle2D.Double BF;
    private StatKeeper stat;
    private Tracker tracker;
    private int fired;
    private int hit;
    private int firedHeadon;
    private int firedRound;
    private int hitRound;
    private int firedRoundHeadon;
    private boolean noMatch;
    private Enemy target;
    private int lastNeighboors;
    private int withGH;
    private int withoutGH;
    private GunWave wave;
    public ArrayList<GunWave> waves;
    private boolean VG = true;
    private Point2D.Double nextPosition;
    private boolean aimed;
    private Point2D.Double aimedLocation;

    public PatternMatchingGun(Xmen me) {
        this.me = me;
        this.stores = new HashMap();
        this.BF = new Rectangle2D.Double(18.0, 18.0, me.getBattleFieldWidth() - 36.0, me.getBattleFieldHeight() - 36.0);
        this.stat = StatKeeper.getInstance();
        this.tracker = Tracker.getInstance();
        Scan.initClass();
        this.waves = new ArrayList();
        GunWave.pmGun = this;
    }

    @Override
    public void initRound() {
        this.firedRound = 0;
        this.firedRoundHeadon = 0;
        this.hitRound = 0;
        this.aimed = false;
        Iterator<ScanStore> it = this.stores.values().iterator();
        while (it.hasNext()) {
            it.next().initRound();
            this.waves.clear();
        }
    }

    @Override
    public void endRound() {
        RobocodeTools.log("withGH:" + 1.0 * (double)this.withGH / (1.0 * (double)this.withGH + 1.0 * (double)this.withoutGH) * 100.0);
        RobocodeTools.log("withoutGH:" + 1.0 * (double)this.withoutGH / (1.0 * (double)this.withGH + 1.0 * (double)this.withoutGH) * 100.0);
        RobocodeTools.log("Headon:" + 1.0 * (double)this.firedHeadon / (1.0 * (double)this.fired) * 100.0);
        RobocodeTools.log("HeadonRound:" + 1.0 * (double)this.firedRoundHeadon / (1.0 * (double)this.firedRound) * 100.0);
        RobocodeTools.log("HR:" + 1.0 * (double)this.hit / (1.0 * (double)this.fired) * 100.0);
        RobocodeTools.log("HR round:" + 1.0 * (double)this.hitRound / (1.0 * (double)this.firedRound) * 100.0);
        Iterator<ScanStore> it = this.stores.values().iterator();
        while (it.hasNext()) {
            it.next().endRound();
        }
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        Enemy enemy = this.tracker.getEnemy(e.getName());
        if (!this.me.isTeammate(e.getName())) {
            ScanStore store = this.me.getOthers() > 1 ? this.getScanStore("melee " + e.getName()) : this.getScanStore("duel " + e.getName());
            store.record(enemy, (AdvancedRobot)this.me);
        }
    }

    @Override
    public void onMainLoop() {
        Bullet bullet;
        double firePower;
        boolean dontFire = this.holdFire;
        if (this.target != null && this.tracker.isDead(this.target) || this.me.getOthers() == 0) {
            dontFire = true;
        }
        this.target = this.selector.getTarget();
        if (this.target == null) {
            return;
        }
        if (this.me.getOthers() == 1 && this.target.energy == 0.0) {
            dontFire = true;
        }
        if ((firePower = this.power.getPower(this.target)) + 1.0 > this.me.getEnergy() || this.me.getEnergy() == 0.0) {
            return;
        }
        if (this.aimed && Math.abs(this.me.getGunTurnRemainingRadians()) < 1.0E-8 && !dontFire && (bullet = this.me.setFireBullet(firePower)) != null) {
            this.notifyFire(bullet);
            ++this.target.data.myBulletsFired;
            ++this.fired;
            ++this.firedRound;
            if (this.noMatch) {
                ++this.firedHeadon;
                ++this.firedRoundHeadon;
            }
            if (this.VG && Configuration.others == 1 && this.wave != null) {
                this.wave.init(new Point2D.Double(bullet.getX(), bullet.getY()), this.target.previousLocation, this.target.bearingDirection, bullet.getPower(), this.me.getTime() + 1L);
                this.waves.add(this.wave);
            }
        }
        Point2D.Double targetLocation = new Point2D.Double(this.target.location.x, this.target.location.y);
        double angle = RobocodeTools.absoluteBearing(new Point2D.Double(this.me.getX(), this.me.getY()), targetLocation);
        if (this.me.getGunHeat() / this.me.getGunCoolingRate() < 1.0 && (this.target.energy != 0.0 || this.target.velocity != 0.0) && this.me.getEnergy() > 0.0) {
            this.aimed = true;
            if (this.VG && this.me.getOthers() == 1) {
                ScanStore store = this.me.getOthers() > 1 ? this.getScanStore("melee " + this.target.name) : this.getScanStore("duel " + this.target.name);
                Scan[][] scans = store.speedyMostSimilarScansVG(this.target, firePower);
                angle = this.speedyChooseAngleVG(this.target, scans, store, firePower);
            } else {
                ScanStore store = this.me.getOthers() > 1 ? this.getScanStore("melee " + this.target.name) : this.getScanStore("duel " + this.target.name);
                angle = this.speedyChooseAngle(this.target, store.speedyMostSimilarScans(this.target, false, firePower), store, firePower);
            }
        } else {
            this.aimed = false;
        }
        this.me.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(angle - this.me.getGunHeadingRadians())));
    }

    @Override
    public void onPaint(Graphics2D e) {
        e.setColor(Color.GRAY);
        e.draw(this.lineOfFire);
        e.setColor(Color.GREEN);
        if (this.me.getGunHeat() / this.me.getGunCoolingRate() < 3.0) {
            e.draw(this.lineOfMovement);
        }
        for (GunWave wave : this.waves) {
            wave.onPaint(e);
        }
        this.selector.onPaint(e);
    }

    private ScanStore getScanStore(String key) {
        if (this.stores.containsKey(key)) {
            return this.stores.get(key);
        }
        ScanStore store = new ScanStore(key);
        this.stores.put(key, store);
        return store;
    }

    private double speedyChooseAngle(Enemy enemy, Scan[] scans, ScanStore store, double firePower) {
        this.noMatch = false;
        MovSim sim = new MovSim();
        MovSimStat[] future = sim.futurePos(1, (AdvancedRobot)this.me, this.me.getMaxVelocity(), 10.0);
        Point2D.Double myLocation = this.nextPosition = new Point2D.Double(future[future.length - 1].x, future[future.length - 1].y);
        if (scans == null) {
            return RobocodeTools.absoluteBearing(myLocation, enemy.location);
        }
        int max = scans.length;
        Point2D.Double[] locations = new Point2D.Double[max];
        Scan[] scanResults = new Scan[max];
        double[] tolerance = new double[max];
        int delay = (int)((double)this.me.getTime() - enemy.lastScan);
        double bVel = RobocodeTools.bulletVelocity(firePower);
        int cpt = 0;
        int i = 0;
        while (i < scans.length && cpt < locations.length) {
            Point2D.Double location;
            Scan scan = scans[i];
            if (scan != null && (location = store.speedyProjectMovement2(scan, bVel, delay, myLocation)) != null && this.BF.contains(location)) {
                locations[cpt] = location;
                tolerance[cpt] = Math.atan(18.0 / location.distance(myLocation));
                scanResults[cpt] = scan;
                ++cpt;
            }
            ++i;
        }
        int bestIndex = 0;
        int[] neighboors = new int[cpt];
        int i2 = 0;
        while (i2 < cpt) {
            double width = tolerance[i2];
            double angle = RobocodeTools.absoluteBearing(myLocation, locations[i2]);
            int j = 0;
            while (j < cpt) {
                if (Math.abs(RobocodeTools.absoluteBearing(myLocation, locations[j]) - angle) < width) {
                    int n = i2;
                    neighboors[n] = neighboors[n] + 1;
                }
                ++j;
            }
            if (neighboors[bestIndex] < neighboors[i2]) {
                bestIndex = i2;
            }
            ++i2;
        }
        if (cpt > 0) {
            this.lineOfFire = new Line2D.Double(new Point2D.Double(locations[bestIndex].x, this.me.getBattleFieldHeight() - locations[bestIndex].y), new Point2D.Double(this.me.getX(), this.me.getBattleFieldHeight() - this.me.getY()));
            this.lineOfMovement = new Line2D.Double(new Point2D.Double(locations[bestIndex].x, this.me.getBattleFieldHeight() - locations[bestIndex].y), new Point2D.Double(enemy.location.x, this.me.getBattleFieldHeight() - enemy.location.y));
            this.stat.getStatData("diff " + enemy.name).record(scanResults[bestIndex].diffValue);
            this.lastNeighboors = neighboors[bestIndex];
            return RobocodeTools.absoluteBearing(myLocation, locations[bestIndex]);
        }
        this.noMatch = true;
        this.lastNeighboors = 0;
        return RobocodeTools.absoluteBearing(myLocation, enemy.location);
    }

    private double speedyChooseAngleVG(Enemy enemy, Scan[][] scans, ScanStore store, double firePower) {
        this.noMatch = false;
        MovSim sim = new MovSim();
        MovSimStat[] future = sim.futurePos(1, (AdvancedRobot)this.me, this.me.getMaxVelocity(), 10.0);
        this.nextPosition = new Point2D.Double(future[future.length - 1].x, future[future.length - 1].y);
        Point2D.Double myLocation = Configuration.others == 1 ? this.nextPosition : new Point2D.Double(this.me.getX(), this.me.getY());
        if (scans == null) {
            return RobocodeTools.absoluteBearing(myLocation, enemy.location);
        }
        int max = scans[0].length;
        Point2D.Double[][] locations = new Point2D.Double[2][max];
        Scan[][] scanResults = new Scan[2][max];
        double[][] tolerance = new double[2][max];
        int delay = (int)((double)this.me.getTime() - enemy.lastScan);
        double bVel = RobocodeTools.bulletVelocity(firePower);
        int cpt = 0;
        int cpt2 = 0;
        int i = 0;
        while (i < scans[0].length) {
            Scan scan = scans[0][i];
            if (scan != null) {
                scan.projection = store.speedyProjectMovement2(scan, bVel, delay, myLocation);
                if (scan.projection != null && this.BF.contains(scan.projection)) {
                    locations[0][cpt] = scan.projection;
                    tolerance[0][cpt] = Math.atan(18.0 / scan.projection.distance(myLocation));
                    scanResults[0][cpt] = scan;
                    ++cpt;
                }
            }
            if ((scan = scans[1][i]) != null) {
                if (scan.projection == null) {
                    scan.projection = store.speedyProjectMovement2(scan, bVel, delay, myLocation);
                }
                if (scan.projection != null && this.BF.contains(scan.projection)) {
                    locations[1][cpt2] = scan.projection;
                    tolerance[1][cpt2] = Math.atan(18.0 / scan.projection.distance(myLocation));
                    scanResults[1][cpt2] = scan;
                    ++cpt2;
                }
            }
            ++i;
        }
        int bestIndex = 0;
        int[] neighboors = new int[cpt];
        int i2 = 0;
        while (i2 < cpt) {
            double width = tolerance[0][i2];
            double angle = RobocodeTools.absoluteBearing(myLocation, locations[0][i2]);
            int j = 0;
            while (j < cpt) {
                if (Math.abs(RobocodeTools.absoluteBearing(myLocation, locations[0][j]) - angle) < width) {
                    int n = i2;
                    neighboors[n] = neighboors[n] + 1;
                }
                ++j;
            }
            if (neighboors[bestIndex] < neighboors[i2]) {
                bestIndex = i2;
            }
            ++i2;
        }
        int bestIndex2 = 0;
        int[] neighboors2 = new int[cpt2];
        int i3 = 0;
        while (i3 < cpt2) {
            double width = tolerance[1][i3];
            double angle = RobocodeTools.absoluteBearing(myLocation, locations[1][i3]);
            int j = 0;
            while (j < cpt2) {
                if (Math.abs(RobocodeTools.absoluteBearing(myLocation, locations[1][j]) - angle) < width) {
                    int n = i3;
                    neighboors2[n] = neighboors2[n] + 1;
                }
                ++j;
            }
            if (neighboors2[bestIndex2] < neighboors2[i3]) {
                bestIndex2 = i3;
            }
            ++i3;
        }
        if (cpt > 0 && cpt2 > 0) {
            double[] angle = new double[]{RobocodeTools.absoluteBearing(myLocation, locations[0][bestIndex]), RobocodeTools.absoluteBearing(myLocation, locations[1][bestIndex2])};
            this.wave = new GunWave(this.target, angle[0] - this.target.absoluteBearing, angle[1] - this.target.absoluteBearing, scanResults[0][bestIndex].diffValue, scanResults[1][bestIndex2].diffValueGH, store.stats, store.lastScan);
            this.stat.getStatData("diff " + enemy.name).record(scanResults[0][bestIndex].diffValue);
            this.stat.getStatData("diffGH " + enemy.name).record(scanResults[1][bestIndex2].diffValueGH);
            if (this.target.data.VGrating[1] > this.target.data.VGrating[0]) {
                this.lastNeighboors = neighboors2[bestIndex2];
                ++this.withGH;
                this.aimedLocation = new Point2D.Double(locations[1][bestIndex2].x, locations[1][bestIndex2].y);
                return angle[1];
            }
            this.lastNeighboors = neighboors[bestIndex];
            ++this.withoutGH;
            this.aimedLocation = new Point2D.Double(locations[0][bestIndex].x, locations[0][bestIndex].y);
            return angle[0];
        }
        if (cpt > 0) {
            double[] angle = new double[2];
            angle[0] = RobocodeTools.absoluteBearing(myLocation, locations[0][bestIndex]);
            this.wave = new GunWave(this.target, angle[0] - this.target.absoluteBearing, 0.0, scanResults[0][bestIndex].diffValue, Double.POSITIVE_INFINITY, store.stats, store.lastScan);
            this.stat.getStatData("diff " + enemy.name).record(scanResults[0][bestIndex].diffValue);
            this.lastNeighboors = neighboors[bestIndex];
            ++this.withoutGH;
            this.aimedLocation = new Point2D.Double(locations[0][bestIndex].x, locations[0][bestIndex].y);
            return angle[0];
        }
        if (cpt2 > 0) {
            // empty if block
        }
        this.wave = new GunWave(this.target, 0.0, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, store.stats, store.lastScan);
        this.noMatch = true;
        this.lastNeighboors = 0;
        this.aimedLocation = new Point2D.Double(this.target.location.x, this.target.location.y);
        return RobocodeTools.absoluteBearing(myLocation, enemy.location);
    }

    @Override
    public void onBulletHit(BulletHitEvent e) {
        ++this.hit;
        ++this.hitRound;
    }

    @Override
    public void onRobotDeath(RobotDeathEvent e) {
    }

    public HashMap<String, ScanStore> getStores() {
        return this.stores;
    }

    public void setStores(HashMap<String, ScanStore> stores) {
        this.stores = stores;
    }
}

