/*
 * Decompiled with CFR 0.152.
 */
package agd.intel;

import agd.util.AdvancedRobotAdapter;
import agd.util.Coord;
import agd.util.CoordInt;
import agd.util.Enemy;
import agd.util.PredictedBullet;
import agd.util.RobotInformation;
import agd.util.World;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import robocode.HitByBulletEvent;
import robocode.RobocodeFileWriter;

public class ChessBoard {
    private int squareSize;
    private int unitwidth;
    private int unitheight;
    private ChessSquare[][] grid;
    private RobotInformation ri;
    private EventListener listener;
    private int maxTargets = 0;
    private static ChessBoard singleton = null;
    private int bulletsDetected = 0;

    public static ChessBoard constructInstance(int squareSize) {
        if (singleton != null) {
            singleton.discard();
        }
        singleton = new ChessBoard(squareSize);
        return singleton;
    }

    public static ChessBoard getInstance() {
        if (singleton == null) {
            System.out.println("ChessBoard.getInstance called with no instance. Creating default.");
            ChessBoard.constructInstance(100);
        }
        return singleton;
    }

    public ChessBoard(int squareSize) {
        Coord size = World.getBattleFieldSize();
        this.squareSize = squareSize;
        this.unitwidth = (int)(size.getX() / (double)squareSize);
        this.unitheight = (int)(size.getY() / (double)squareSize);
        this.grid = new ChessSquare[this.unitwidth][this.unitheight];
        int x = 0;
        while (x < this.unitwidth) {
            int y = 0;
            while (y < this.unitheight) {
                this.grid[x][y] = new ChessSquare(x, y);
                ++y;
            }
            ++x;
        }
        this.ri = (RobotInformation)World.getAdvancedRobot();
        this.listener = new EventListener();
    }

    public void registerEventSource(RobotInformation eventSource) {
        this.ri = eventSource;
        this.ri.addListener(this.listener);
    }

    public void discard() {
        this.ri.removeListener(this.listener);
    }

    public void setMaxTargets(int max) {
        this.maxTargets = max;
    }

    public int getSquareSize() {
        return this.squareSize;
    }

    public CoordInt toCoordInt(Coord point) {
        return new CoordInt((int)point.getX() / this.squareSize, (int)point.getY() / this.squareSize);
    }

    public Coord toCoord(CoordInt box) {
        return new Coord((double)(box.getX() * this.squareSize) + (double)this.squareSize / 2.0, (double)(box.getY() * this.squareSize) + (double)this.squareSize / 2.0);
    }

    public ChessSquare getSquare(CoordInt square) {
        if (this.containsSquare(square)) {
            return this.grid[square.getX()][square.getY()];
        }
        return null;
    }

    public boolean containsSquare(CoordInt square) {
        boolean contained = false;
        if (square.getX() >= 0 && square.getX() < this.unitwidth && square.getY() >= 0 && square.getY() < this.unitheight) {
            contained = true;
        }
        return contained;
    }

    void addEnemyProximity(Enemy enemy) {
        CoordInt enemyPos = this.toCoordInt(enemy.getPosition());
        Vector neighbourSquares1 = this.getNeighbours(enemyPos, 1);
        Vector neighbourSquares2 = this.getNeighbours(enemyPos, 2);
        Vector neighbourSquares3 = this.getNeighbours(enemyPos, 3);
        neighbourSquares1.addAll(neighbourSquares2);
        neighbourSquares1.addAll(neighbourSquares3);
        ListIterator lit = neighbourSquares1.listIterator();
        while (lit.hasNext()) {
            ChessSquare square = (ChessSquare)lit.next();
            double distance = this.toCoord(square.getIntPosition()).distanceTo(enemy.getPosition());
            square.addEnemyProximity(enemy, distance);
        }
    }

    void addEnemyProximities() {
        Collection enemies = this.ri.getEnemies().values();
        Iterator i = enemies.iterator();
        while (i.hasNext()) {
            this.addEnemyProximity((Enemy)i.next());
        }
    }

    private void updateRecentOccupation(CoordInt ourPos) {
        int ox = ourPos.getX();
        int oy = ourPos.getY();
        int x = 0;
        while (x < this.unitwidth) {
            int y = 0;
            while (y < this.unitheight) {
                if (ox == x && oy == y) {
                    this.grid[x][y].increaseOccupation();
                } else {
                    this.grid[x][y].decreaseOccupation();
                }
                ++y;
            }
            ++x;
        }
    }

    void addPrediction(CoordInt pos, long time, PredictedBullet e) {
        block3: {
            try {
                this.grid[pos.getX()][pos.getY()].addPrediction(time, e);
            }
            catch (ArrayIndexOutOfBoundsException except) {
                System.out.println("Caught " + except + ", pos=" + pos + ", pbull = " + e);
                if (this.grid == null) {
                    System.out.println("Grid was null");
                }
                if (pos == null) break block3;
                System.out.println("Grid content=" + this.grid[pos.getX()][pos.getY()]);
            }
        }
    }

    public Vector getNeighbours(CoordInt centre) {
        return this.getNeighbours(centre, 1);
    }

    public Vector getNeighbours(CoordInt centre, int step) {
        Vector<ChessSquare> neighbours = new Vector<ChessSquare>(8);
        CoordInt tempSq = null;
        int lowy = centre.getY() - step;
        int highy = centre.getY() + step;
        int x = centre.getX() - step;
        while (x <= centre.getX() + step) {
            tempSq = new CoordInt(x, lowy);
            if (this.containsSquare(tempSq)) {
                neighbours.add(this.grid[tempSq.getX()][tempSq.getY()]);
            }
            if (this.containsSquare(tempSq = new CoordInt(x, highy))) {
                neighbours.add(this.grid[tempSq.getX()][tempSq.getY()]);
            }
            ++x;
        }
        int lowx = centre.getX() - step;
        int highx = centre.getX() + step;
        int y = centre.getY() - (step - 1);
        while (y <= centre.getY() + (step - 1)) {
            tempSq = new CoordInt(lowx, y);
            if (this.containsSquare(tempSq)) {
                neighbours.add(this.grid[tempSq.getX()][tempSq.getY()]);
            }
            if (this.containsSquare(tempSq = new CoordInt(highx, y))) {
                neighbours.add(this.grid[tempSq.getX()][tempSq.getY()]);
            }
            ++y;
        }
        return neighbours;
    }

    private void turnStartSetup() {
        long oldestAllowed = World.getTime();
        int ix = 0;
        while (ix < this.unitwidth) {
            int iy = 0;
            while (iy < this.unitheight) {
                this.grid[ix][iy].clearPredictions(oldestAllowed);
                this.grid[ix][iy].clearEnemyProximity();
                ++iy;
            }
            ++ix;
        }
    }

    void writeBoardContent(CoordInt ourPos, CoordInt desiredPos) {
        try {
            File displayFile = World.getDataFile("ChessContent");
            RobocodeFileWriter contentDisplay = new RobocodeFileWriter(displayFile);
            File htmlFile = World.getDataFile("ChessContent.html");
            RobocodeFileWriter contentHtml = new RobocodeFileWriter(htmlFile);
            contentHtml.write("<html><head><title>Chess board content</title>");
            contentHtml.write("<link rel=stylesheet type=\"text/css\" href=\"mooserwirt.css\" title=\"Mooserwirt\">");
            contentHtml.write("</head>\n<body>\n");
            contentHtml.write("<p>Our pos = " + ourPos + ", want to get to =" + desiredPos + "<br><small><table><br>\n");
            contentHtml.write("<tr><td/>");
            int x = 0;
            while (x < this.unitwidth) {
                contentHtml.write("<th>" + x + "</th>");
                ++x;
            }
            contentHtml.write("</tr>");
            int y = this.unitheight - 1;
            while (y >= 0) {
                contentHtml.write("<tr><th>" + y + "</th>");
                int x2 = 0;
                while (x2 < this.unitwidth) {
                    ChessSquare sq = this.grid[x2][y];
                    contentDisplay.write(World.twodp.format(sq.getThreatFactor()) + "\t");
                    if (x2 == ourPos.getX() && y == ourPos.getY()) {
                        contentHtml.write("<td class=ourpos>");
                    } else {
                        contentHtml.write("<td>");
                    }
                    contentHtml.write(sq.toHtmlReport());
                    contentHtml.write("</td>\n");
                    ++x2;
                }
                contentDisplay.write("\n");
                contentHtml.write("</tr>\n");
                --y;
            }
            contentHtml.write("</table></small></body></html>\n");
            contentDisplay.close();
            contentHtml.close();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    public void writeSurroundingCells(CoordInt centre, int margin, String trailer) {
        block4: {
            File f = World.getDataFile("surroundingcells.txt");
            RobocodeFileWriter writer = null;
            try {
                writer = new RobocodeFileWriter(f);
                this.writeSurroundingCells((Writer)writer, centre, margin);
                writer.write("\n" + trailer + "\n");
                writer.close();
            }
            catch (IOException ioe) {
                System.out.println("Unable to write surrounding cells:" + ioe);
                if (writer == null) break block4;
                try {
                    writer.close();
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
            }
        }
    }

    void writeSurroundingCells(Writer outstream, CoordInt centre, int margin) throws IOException {
        int xmin = Math.max(centre.getX() - margin, 0);
        int ymin = Math.max(centre.getY() - margin, 0);
        int xmax = Math.min(centre.getX() + margin, this.unitwidth - 1);
        int ymax = Math.min(centre.getY() + margin, this.unitheight - 1);
        outstream.write("\t");
        int x = xmin;
        while (x <= xmax) {
            outstream.write("(" + x + ")\t");
            ++x;
        }
        outstream.write("\n");
        int y = ymax;
        while (y >= ymin) {
            outstream.write("(" + y + ")\t");
            int x2 = xmin;
            while (x2 <= xmax) {
                ChessSquare sq = this.grid[x2][y];
                outstream.write(World.twodp.format(sq.getThreatFactor()) + "," + World.twodp.format(sq.getEnemyProximity()) + "\t");
                ++x2;
            }
            outstream.write("\n");
            --y;
        }
    }

    private void extrapolateBullet(PredictedBullet bullet) {
        ++this.bulletsDetected;
        long turn = World.getTime();
        boolean bulletStillInPlay = true;
        while (bulletStillInPlay) {
            CoordInt bpos = this.toCoordInt(bullet.getPosition(turn));
            if (this.containsSquare(bpos)) {
                this.addPrediction(bpos, turn, bullet);
            } else {
                bulletStillInPlay = false;
            }
            ++turn;
        }
    }

    public static class ChessSquare {
        private SortedMap predictedBullets;
        private Map expectedBullets;
        private double enemyProximity;
        private long recentOccupation;
        private CoordInt position;
        private double bulletThreatFactorCache = 0.0;
        private long bulletThreatFactorCacheTime = 0L;

        public ChessSquare(int x, int y) {
            this.position = new CoordInt(x, y);
            this.predictedBullets = new TreeMap();
            this.expectedBullets = new HashMap();
            this.recentOccupation = 0L;
        }

        public String toString() {
            int bulletCount = this.expectedBullets.keySet().size();
            return "Square " + this.position + ", enemyProximity = " + this.enemyProximity + ", " + bulletCount + " bullets expected.";
        }

        public String toHtmlReport() {
            int expected = this.expectedBullets.size();
            StringBuffer b = new StringBuffer(80);
            b.append("b=" + expected + "<br>");
            b.append("bt=" + World.twodp.format(this.getBulletThreatFactor()) + "<br>");
            b.append("pt=" + World.twodp.format(this.getProximityThreatFactor()) + "<br>");
            b.append("t=" + World.twodp.format(this.getThreatFactor()) + "<br>");
            b.append("\n");
            return b.toString();
        }

        public void increaseOccupation() {
            this.recentOccupation += 2L;
        }

        public void decreaseOccupation() {
            if (this.recentOccupation > 0L) {
                --this.recentOccupation;
            }
        }

        public long getRecentOccupation() {
            return this.recentOccupation;
        }

        double getBulletThreatFactor() {
            if (World.getTime() != this.bulletThreatFactorCacheTime) {
                this.bulletThreatFactorCacheTime = World.getTime();
                this.bulletThreatFactorCache = this.calcBulletThreatFactor();
            }
            return this.bulletThreatFactorCache;
        }

        private double calcBulletThreatFactor() {
            Iterator iBullet = this.expectedBullets.keySet().iterator();
            double bulletThreat = 0.0;
            while (iBullet.hasNext()) {
                Long timeDue;
                long dueInTicks;
                PredictedBullet pb = (PredictedBullet)iBullet.next();
                SortedSet set = (SortedSet)this.expectedBullets.get(pb);
                if (set == null || set.size() <= 0 || (dueInTicks = (timeDue = (Long)set.first()) - World.getTime()) >= 1000L) continue;
                bulletThreat += (double)(1000L - dueInTicks) * pb.getPower() * pb.getProbability() * 3.0;
            }
            return bulletThreat;
        }

        double getProximityThreatFactor() {
            return 6000.0 * this.enemyProximity;
        }

        public double getThreatFactor() {
            return this.getProximityThreatFactor() + this.getBulletThreatFactor();
        }

        public CoordInt getIntPosition() {
            return this.position;
        }

        int getX() {
            return this.position.getX();
        }

        int getY() {
            return this.position.getY();
        }

        double getEnemyProximity() {
            return this.enemyProximity;
        }

        void addPrediction(long time, PredictedBullet pb) {
            this.predictedBullets.put(new Long(time), pb);
            if (this.expectedBullets.containsKey(pb)) {
                SortedSet set = (SortedSet)this.expectedBullets.get(pb);
                set.add(new Long(time));
            } else {
                TreeSet<Long> set = new TreeSet<Long>();
                set.add(new Long(time));
                this.expectedBullets.put(pb, set);
            }
        }

        void addEnemyProximity(Enemy enemy, double distance) {
            this.enemyProximity += 100.0 / distance;
        }

        void clearEnemyProximity() {
            this.enemyProximity = 0.0;
        }

        void clearPredictions(long oldestAllowed) {
            Iterator it = this.predictedBullets.keySet().iterator();
            while (it.hasNext()) {
                Long time = (Long)it.next();
                if (time >= oldestAllowed) break;
                it.remove();
            }
            Iterator bulletIt = this.expectedBullets.keySet().iterator();
            while (bulletIt.hasNext()) {
                PredictedBullet pb = (PredictedBullet)bulletIt.next();
                SortedSet whenList = (SortedSet)this.expectedBullets.get(pb);
                Iterator whenIt = whenList.iterator();
                while (whenIt.hasNext()) {
                    Long time = (Long)whenIt.next();
                    if (time >= oldestAllowed) break;
                    whenIt.remove();
                }
                if (whenList.size() != 0) continue;
                bulletIt.remove();
            }
        }
    }

    class EnemyData {
        public Enemy enemy;
        public long timeLastCollectedBullets = 0L;

        EnemyData(Enemy e) {
            this.enemy = e;
        }
    }

    class EventListener
    extends AdvancedRobotAdapter {
        Map enemydata = new HashMap();

        public void onEnemySighted(Enemy e) {
            List enemies = ChessBoard.this.ri.getClosestEnemies(ChessBoard.this.maxTargets);
            if (enemies.contains(e)) {
                EnemyData edata = null;
                if (!this.enemydata.containsKey(e.getName())) {
                    edata = new EnemyData(e);
                    this.enemydata.put(e.getName(), edata);
                } else {
                    edata = (EnemyData)this.enemydata.get(e.getName());
                }
                List predictedBullets = e.getBulletPredictions();
                ListIterator lit = predictedBullets.listIterator(predictedBullets.size());
                boolean farBackEnough = false;
                while (lit.hasPrevious() && !farBackEnough) {
                    PredictedBullet b = (PredictedBullet)lit.previous();
                    if (b.getTimeFired() > edata.timeLastCollectedBullets) {
                        ChessBoard.this.extrapolateBullet(b);
                        continue;
                    }
                    farBackEnough = true;
                }
                edata.timeLastCollectedBullets = World.getTime();
            }
        }

        public void onTickStart() {
            ChessBoard.this.turnStartSetup();
            CoordInt currentPos = ChessBoard.this.toCoordInt(World.getPosition());
            ChessBoard.this.updateRecentOccupation(currentPos);
            ChessBoard.this.addEnemyProximities();
        }

        public void onHitByBullet(HitByBulletEvent hbbe) {
        }
    }
}

