/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.util.Compass;

public class Coord {
    public static final Coord ORIGIN = new Coord(0.0, 0.0);
    private double x;
    private double y;

    public Coord(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public String toString() {
        return "(" + (int)this.x + "," + (int)this.y + ")";
    }

    public double distanceTo(Coord target) {
        double dx = Math.abs(target.x - this.x);
        double dy = Math.abs(target.y - this.y);
        return Math.sqrt(dx * dx + dy * dy);
    }

    public Compass headingTo(Coord target) {
        double dx = target.x - this.x;
        double dy = target.y - this.y;
        double angle = Math.toDegrees(Math.atan(dx / Math.abs(dy)));
        if (dy < 0.0) {
            angle = 180.0 - angle;
        }
        return new Compass(angle);
    }

    public Coord applyVector(Compass heading, double distance) {
        double radians = heading.getRadians();
        double dx = distance * Math.sin(radians);
        double dy = distance * Math.cos(radians);
        return new Coord(this.x + dx, this.y + dy);
    }

    public boolean inRectangle(Coord p1, Coord p2) {
        double x1 = Math.min(p1.x, p2.x);
        double x2 = Math.max(p1.x, p2.x);
        double y1 = Math.min(p1.y, p2.y);
        double y2 = Math.max(p1.y, p2.y);
        return this.x > x1 && this.x < x2 && this.y > y1 && this.y < y2;
    }

    public Coord clipToRectangle(Coord p1, Coord p2) {
        double minx = Math.min(p1.getX(), p2.getX());
        double miny = Math.min(p1.getY(), p2.getY());
        double maxx = Math.max(p1.getX(), p2.getX());
        double maxy = Math.max(p1.getY(), p2.getY());
        double newx = Math.max(minx, this.x);
        newx = Math.min(maxx, newx);
        double newy = Math.max(miny, this.y);
        newy = Math.min(maxy, newy);
        return new Coord(newx, newy);
    }
}

