/*
 * Decompiled with CFR 0.152.
 */
package acid;

import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Syzygy
extends AdvancedRobot {
    double prevAimX = 0.0;
    double prevAimY = 0.0;
    double prevVecX = 0.0;
    double prevVecY = 0.0;
    double prevEnergy = 100.0;
    double prevHeading = 0.0;
    double prevVel;
    double crossX = 0.0;
    double crossY = 0.0;
    double speed = 100.0;
    boolean lockedRev = false;
    boolean overRide = true;
    double bulletPower = 3.0;
    double curX;
    double curY;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        Color yellow = new Color(255, 215, 0);
        this.setBodyColor(yellow);
        this.setGunColor(yellow);
        this.setBodyColor(yellow);
        this.setRadarColor(yellow);
        this.setScanColor(Color.RED);
        this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        while (true) {
            this.scan();
        }
    }

    void reverse2() {
        if (!(this.curX < 100.0 || this.curY < 100.0 || this.curY > this.getBattleFieldHeight() - 100.0 || this.curX > this.getBattleFieldWidth() - 100.0 || (int)Math.ceil(Math.random() * 2.0) != 1)) {
            this.speed = -this.speed;
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double carTurn;
        double radarTurn = this.getHeadingRadians() + e.getBearingRadians() - this.getRadarHeadingRadians();
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)radarTurn));
        double curHeading = e.getHeadingRadians();
        this.curX = this.getX();
        this.curY = this.getY();
        if (e.getDistance() < 420.0 && !this.overRide) {
            carTurn = this.getHeadingRadians() + e.getBearingRadians() - this.getHeadingRadians() + 1.5707963267948966;
            this.setTurnRightRadians(Utils.normalRelativeAngle((double)carTurn));
            if ((this.curX < 80.0 || this.curY < 80.0 || this.curY > this.getBattleFieldHeight() - 80.0 || this.curX > this.getBattleFieldWidth() - 80.0) && !this.lockedRev) {
                this.speed = -this.speed;
                this.lockedRev = true;
            }
            if (this.curX > 80.0 && this.curY > 80.0 && this.curY < this.getBattleFieldHeight() - 80.0 && this.curX < this.getBattleFieldWidth() - 80.0 && this.lockedRev) {
                this.lockedRev = false;
            }
            this.setAhead(this.speed);
        } else if (e.getDistance() < 500.0) {
            this.overRide = true;
            carTurn = this.getHeadingRadians() + e.getBearingRadians() + this.getHeadingRadians() / 4.0;
            this.setTurnRightRadians(Utils.normalRelativeAngle((double)carTurn));
            this.setAhead(10.0);
            if (e.getDistance() < 300.0) {
                this.overRide = false;
            }
        } else {
            this.overRide = true;
            carTurn = this.getHeadingRadians() + e.getBearingRadians() - this.getHeadingRadians();
            this.setTurnRightRadians(Utils.normalRelativeAngle((double)carTurn));
            this.setAhead(10.0);
            if (e.getDistance() < 300.0) {
                this.overRide = false;
            }
        }
        if (e.getDistance() < 50.0) {
            this.speed = -this.speed;
        }
        double aimX = Math.sin(this.getRadarHeadingRadians()) * e.getDistance() + this.curX;
        double aimY = Math.cos(this.getRadarHeadingRadians()) * e.getDistance() + this.curY;
        double headingDif = this.prevHeading - e.getHeadingRadians();
        double vecX = Math.sin(curHeading + 1.5707963267948966);
        double vecY = Math.cos(curHeading + 1.5707963267948966);
        if (headingDif > 0.08 || headingDif < -0.08) {
            this.prevVecX = Math.sin(this.prevHeading + 1.5707963267948966);
            this.prevVecY = Math.cos(this.prevHeading + 1.5707963267948966);
            if (this.prevHeading - curHeading > 0.0) {
                vecX = Math.sin(curHeading - 1.5707963267948966);
                vecY = Math.cos(curHeading - 1.5707963267948966);
                this.prevVecX = Math.sin(this.prevHeading - 1.5707963267948966);
                this.prevVecY = Math.cos(this.prevHeading - 1.5707963267948966);
            }
            this.crossX = (this.prevAimY - aimY) / (vecY - this.prevVecY);
            this.crossY = vecY * this.crossX + aimY;
            this.crossX = aimX + vecX * this.crossX;
        } else if (headingDif == 0.0) {
            if (this.bulletPower > 3.0) {
                this.bulletPower = 3.0;
            }
            double bullSpeed = 20.0 - 3.0 * this.bulletPower;
            double time = e.getDistance() / bullSpeed;
            this.crossX = aimX + Math.sin(curHeading) * (Math.abs(aimX - this.prevAimX) * time);
            this.crossY = aimY + Math.cos(curHeading) * (Math.abs(aimY - this.prevAimY) * time);
            int i = 0;
            while (i < 10) {
                ++i;
                double dist = Math.sqrt(Math.pow(this.crossX - this.curX, 2.0) + Math.pow(this.crossY - this.curY, 2.0));
                time = dist / bullSpeed;
                this.crossX = aimX + Math.sin(curHeading) * (Math.abs(aimX - this.prevAimX) * time);
                this.crossY = aimY + Math.cos(curHeading) * (Math.abs(aimY - this.prevAimY) * time);
            }
        } else {
            this.crossX = aimX;
            this.crossY = aimY;
        }
        if (this.crossX < 0.0) {
            this.crossX = 0.0;
        }
        if (this.crossY < 0.0) {
            this.crossY = 0.0;
        }
        if (this.crossX > this.getBattleFieldWidth()) {
            this.crossX = this.getBattleFieldWidth();
        }
        if (this.crossY > this.getBattleFieldHeight()) {
            this.crossY = this.getBattleFieldHeight();
        }
        double angle = Utils.normalAbsoluteAngle((double)Math.atan2(this.crossX - this.curX, this.crossY - this.curY));
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(angle - this.getGunHeadingRadians())));
        this.bulletPower = 3.0 * (100.0 / (e.getDistance() / 1.2));
        if (this.getEnergy() > 10.0) {
            this.fire(this.bulletPower);
        }
        this.prevAimX = aimX;
        this.prevAimY = aimY;
        this.prevVecX = vecX;
        this.prevVecY = vecY;
        this.prevHeading = e.getHeadingRadians();
        this.prevVel = Math.sqrt(Math.pow(aimX - this.prevAimX, 2.0) + Math.pow(aimY - this.prevAimY, 2.0));
        if (this.getEnergy() != this.prevEnergy && Math.random() * 3.0 < 1.0) {
            this.speed = -this.speed;
        }
        System.out.println(String.valueOf(this.getEnergy()) + ": " + this.prevEnergy);
        this.prevEnergy = this.getEnergy();
    }
}

