/*
 * Decompiled with CFR 0.152.
 */
package jdw.hurricane.radar;

import jdw.hurricane.Enemy;
import jdw.hurricane.GlobalData;
import robocode.util.Utils;

public class Radar
extends GlobalData {
    private Enemy scan_robot = null;
    private int scanned_time = -10;

    public void init_round() {
    }

    public void tick() {
        if (ticks == 0) {
            this.turn_towards(center_x, center_y);
        } else if (!(ticks <= 10 || this.scan_robot != null && this.scan_robot.scan_ticks == this.scanned_time && this.scan_robot.active)) {
            this.set_scanning_for();
            if (this.scan_robot != null) {
                this.turn_towards(this.scan_robot.x, this.scan_robot.y);
            }
        }
    }

    private void set_scanning_for() {
        this.scan_robot = null;
        this.scanned_time = Integer.MAX_VALUE;
        int i = 0;
        while (i < num_enemies_found) {
            Enemy rob = enemies[i];
            if (rob.active && rob.scan_ticks < this.scanned_time) {
                this.scan_robot = rob;
                this.scanned_time = rob.scan_ticks;
            }
            ++i;
        }
    }

    private void turn_towards(double x, double y) {
        double angle = Utils.normalRelativeAngle((double)(radar_heading - Math.atan2(x - pos_x, y - pos_y)));
        rot_radar = angle < 0.0 ? Double.valueOf(Double.POSITIVE_INFINITY) : Double.valueOf(Double.NEGATIVE_INFINITY);
    }
}

