/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mega.rMove.movetree.nodes.learn;

import dsekercioglu.mega.core.DistancedGuessFactor;
import dsekercioglu.mega.core.GuessFactor;
import dsekercioglu.mega.core.KNNView;
import dsekercioglu.mega.rMove.info.WaveData;
import dsekercioglu.mega.rMove.movetree.formula.knnformula.ContinuousFormula;
import dsekercioglu.mega.rMove.movetree.nodes.ContinuousRawDataNode;
import java.util.ArrayList;
import java.util.List;

public class ETP
extends ContinuousRawDataNode {
    private final ContinuousFormula FORMULA;
    private final KNNView KNN_VIEW;
    private final double DIST_COEFF;

    public ETP(ContinuousFormula formula, int k, int divisor, double distCoeff) {
        this.FORMULA = formula;
        this.KNN_VIEW = new KNNView(k, divisor, this.FORMULA.getWeights());
        this.DIST_COEFF = distCoeff;
        double[] zeroPoint = new double[this.FORMULA.getWeights().length];
        this.KNN_VIEW.addDataPoint(zeroPoint, new GuessFactor(0.0, 1.0E-4, 0));
    }

    @Override
    public List<GuessFactor> getGuessFactors(WaveData battleInfo) {
        return this.getGuessFactorsRaw(this.FORMULA.getDataPoint(battleInfo));
    }

    @Override
    public void addData(WaveData battleInfo, GuessFactor guessFactor, boolean real) {
        if (real) {
            this.KNN_VIEW.addDataPoint(this.FORMULA.getDataPoint(battleInfo), guessFactor);
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public List<GuessFactor> getGuessFactorsRaw(double[] dataPoint) {
        ArrayList<GuessFactor> weightedGuessFactors = new ArrayList<GuessFactor>();
        ArrayList<DistancedGuessFactor> guessFactors = this.KNN_VIEW.nearestNeighbours(dataPoint);
        for (DistancedGuessFactor distancedGuessFactor : guessFactors) {
            GuessFactor guessFactor = distancedGuessFactor.getGuessFactor();
            GuessFactor weightedGuessFactor = new GuessFactor(guessFactor.GUESS_FACTOR, guessFactor.getWeight() / (1.0 + distancedGuessFactor.getDistance() * this.DIST_COEFF / this.FORMULA.getMaxDistance()), guessFactor.SCAN);
            weightedGuessFactors.add(weightedGuessFactor);
        }
        return weightedGuessFactors;
    }

    @Override
    public void addDataRaw(double[] dataPoint, GuessFactor guessFactor) {
        this.KNN_VIEW.addDataPoint(dataPoint, guessFactor);
    }
}

