/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mega.rMove.ws.path.aacalc;

import dsekercioglu.mega.core.wiki.FastMath;
import dsekercioglu.mega.rMove.MoveUtils;
import dsekercioglu.mega.rMove.sim.Wave;
import dsekercioglu.mega.rMove.ws.path.aacalc.AttackAngleCalculator;
import java.awt.geom.Point2D;

public class FancyDistancer
extends AttackAngleCalculator {
    private static final double WALL_MARGIN = 20.0;
    private static final double AGGRESSION = 1.2;
    private static final double PREFERRED_DISTANCE = 450.0;
    private static final double WALL_STICK_RADIUS = 120.0;
    private static final double HALF_PI = 1.5707963267948966;
    private final double BATTLE_FIELD_WIDTH;
    private final double BATTLE_FIELD_HEIGHT;

    public FancyDistancer(double battleFieldWidth, double battleFieldHeight) {
        this.BATTLE_FIELD_WIDTH = battleFieldWidth;
        this.BATTLE_FIELD_HEIGHT = battleFieldHeight;
    }

    @Override
    public double getAttackAngle(Wave wave, Point2D.Double location, Point2D.Double enemyLocation, double currentAngle, double targetVelocity) {
        Point2D.Double midPoint = new Point2D.Double((wave.getSource().x + enemyLocation.x) / 2.0, (wave.getSource().y + enemyLocation.y) / 2.0);
        double targetAngle = MoveUtils.absoluteBearing(midPoint, location) + 1.5707963267948966;
        double dir = Math.signum(targetVelocity);
        if (dir != 0.0) {
            double targetFix = (dir - 1.0) * 1.5707963267948966;
            double distance = location.distance(enemyLocation);
            double extraAngle = (distance - 450.0) / 450.0 * 1.2;
            double distancingAngle = (targetAngle += targetFix) + dir * extraAngle;
            if (MoveUtils.distanceToWall(location.x, location.y, this.BATTLE_FIELD_WIDTH, this.BATTLE_FIELD_HEIGHT) <= 140.0) {
                Point2D.Double nextLocation = MoveUtils.project(location, distancingAngle, 8.0);
                double position = this.BATTLE_FIELD_HEIGHT - nextLocation.y - 20.0;
                if (dir == 1.0) {
                    if (this.smoothNorth(position, distancingAngle, dir)) {
                        double eastPosition = this.BATTLE_FIELD_WIDTH - nextLocation.x - 20.0;
                        if (this.smoothEast(eastPosition, distancingAngle, dir)) {
                            return targetFix + this.exactSmoothEast(eastPosition, dir);
                        }
                        return targetFix + this.exactSmoothNorth(position, dir);
                    }
                    position = this.BATTLE_FIELD_WIDTH - nextLocation.x - 20.0;
                    if (this.smoothEast(position, distancingAngle, dir)) {
                        double southPosition = nextLocation.y - 20.0;
                        if (this.smoothSouth(southPosition, distancingAngle, dir)) {
                            return targetFix + this.exactSmoothSouth(southPosition, dir);
                        }
                        return targetFix + this.exactSmoothEast(position, dir);
                    }
                    position = nextLocation.y - 20.0;
                    if (this.smoothSouth(position, distancingAngle, dir)) {
                        double westPosition = nextLocation.x - 20.0;
                        if (this.smoothWest(westPosition, distancingAngle, dir)) {
                            return targetFix + this.exactSmoothWest(westPosition, dir);
                        }
                        return targetFix + this.exactSmoothSouth(position, dir);
                    }
                    position = nextLocation.x - 20.0;
                    if (this.smoothWest(position, distancingAngle, dir)) {
                        double northPosition = this.BATTLE_FIELD_HEIGHT - nextLocation.y - 20.0;
                        if (this.smoothNorth(northPosition, distancingAngle, dir)) {
                            return targetFix + this.exactSmoothNorth(northPosition, dir);
                        }
                        return targetFix + this.exactSmoothWest(position, dir);
                    }
                } else {
                    if (this.smoothNorth(position, distancingAngle, dir)) {
                        double westPosition = nextLocation.x - 20.0;
                        if (this.smoothWest(westPosition, distancingAngle, dir)) {
                            return targetFix + this.exactSmoothWest(westPosition, dir);
                        }
                        return targetFix + this.exactSmoothNorth(position, dir);
                    }
                    position = nextLocation.x - 20.0;
                    if (this.smoothWest(position, distancingAngle, dir)) {
                        double southPosition = nextLocation.y - 20.0;
                        if (this.smoothSouth(southPosition, distancingAngle, dir)) {
                            return targetFix + this.exactSmoothSouth(southPosition, dir);
                        }
                        return targetFix + this.exactSmoothWest(position, dir);
                    }
                    position = nextLocation.y - 20.0;
                    if (this.smoothSouth(position, distancingAngle, dir)) {
                        double eastPosition = this.BATTLE_FIELD_WIDTH - nextLocation.x - 20.0;
                        if (this.smoothEast(eastPosition, distancingAngle, dir)) {
                            return targetFix + this.exactSmoothEast(eastPosition, dir);
                        }
                        return targetFix + this.exactSmoothSouth(position, dir);
                    }
                    position = this.BATTLE_FIELD_WIDTH - nextLocation.x - 20.0;
                    if (this.smoothEast(position, distancingAngle, dir)) {
                        double northPosition = this.BATTLE_FIELD_HEIGHT - nextLocation.y - 20.0;
                        if (this.smoothNorth(northPosition, distancingAngle, dir)) {
                            return targetFix + this.exactSmoothNorth(northPosition, dir);
                        }
                        return targetFix + this.exactSmoothEast(position, dir);
                    }
                }
            }
            return distancingAngle;
        }
        return targetAngle;
    }

    private double exactSmoothNorth(double y, double dir) {
        return dir * this.doSmoothSouth(y, dir) + Math.PI;
    }

    private double exactSmoothWest(double y, double dir) {
        return dir * this.doSmoothSouth(y, dir) + 1.5707963267948966;
    }

    private double exactSmoothSouth(double y, double dir) {
        return dir * this.doSmoothSouth(y, dir);
    }

    private double exactSmoothEast(double y, double dir) {
        return dir * this.doSmoothSouth(y, dir) - 1.5707963267948966;
    }

    private boolean smoothNorth(double position, double angle, double dir) {
        return this.smooth(position, angle - Math.PI, dir);
    }

    private boolean smoothWest(double position, double angle, double dir) {
        return this.smooth(position, angle - 1.5707963267948966, dir);
    }

    private boolean smoothSouth(double position, double angle, double dir) {
        return this.smooth(position, angle, dir);
    }

    private boolean smoothEast(double position, double angle, double dir) {
        return this.smooth(position, angle + 1.5707963267948966, dir);
    }

    private boolean smooth(double position, double angle, double dir) {
        double moveY = position + FastMath.cos(angle) * 120.0;
        if (moveY <= 0.0) {
            double rotateY = position + FastMath.cos(angle += 1.5707963267948966 * dir) * 120.0;
            return rotateY <= 120.0;
        }
        return false;
    }

    private double doSmoothSouth(double position, double dir) {
        position = MoveUtils.limit(0.0, position, 120.0);
        return -dir * 1.5707963267948966 - FastMath.acos(1.0 - position / 120.0);
    }
}

