/*
 * Decompiled with CFR 0.152.
 */
package pedersen.core;

import pedersen.core.Snapshot;
import pedersen.core.SnapshotHistory;
import pedersen.debug.Debug;
import pedersen.physics.StaticHeading;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticVector;
import pedersen.physics.StaticVectorImpl;
import pedersen.physics.StaticVelocity;

public abstract class SnapshotHistoryBase
implements SnapshotHistory {
    private Snapshot snapshot = null;

    public void appendSnapshot(Snapshot newSnapshot) {
        if (this.snapshot == null) {
            newSnapshot.setVectorDelta(new StaticVectorImpl(0.0, 0.0));
        } else {
            newSnapshot.setVectorDelta(this.snapshot.compareVector(newSnapshot));
        }
        this.snapshot = newSnapshot;
    }

    static double rollingAverage(double value, double newEntry) {
        return (value * 30.0 + newEntry * 1.0) / 31.0;
    }

    public void debug() {
        Debug.debug("Snapshot History:");
        Debug.debug("no debug information defined");
    }

    public long getRound() {
        return this.snapshot.getRound();
    }

    public long getTime() {
        return this.snapshot.getTime();
    }

    public void setVectorDelta(StaticVector newDelta) {
        this.snapshot.setVectorDelta(newDelta);
    }

    public StaticVector getVectorDelta() {
        return this.snapshot.getVectorDelta();
    }

    public double getHeadingDelta() {
        return this.snapshot.getHeadingDelta();
    }

    public double getVelocityDelta() {
        return this.snapshot.getVelocityDelta();
    }

    public double getEnergy() {
        return this.snapshot.getEnergy();
    }

    public double getX() {
        return this.snapshot.getX();
    }

    public double getY() {
        return this.snapshot.getY();
    }

    public boolean equalsPosition(StaticPosition other) {
        return this.snapshot.equalsPosition(other);
    }

    public StaticPosition getRelativePosition(StaticPosition other) {
        return this.snapshot.getRelativePosition(other);
    }

    public StaticVector getRelativeVector(StaticPosition other) {
        return this.snapshot.getRelativeVector(other);
    }

    public double getBearing(StaticPosition other) {
        return this.snapshot.getBearing(other);
    }

    public double getDistance(StaticPosition other) {
        return this.snapshot.getDistance(other);
    }

    public double getHeading() {
        return this.snapshot.getHeading();
    }

    public boolean equalsAngle(double other) {
        return this.snapshot.equalsAngle(other);
    }

    public boolean equalsAngle(StaticHeading other) {
        return this.snapshot.equalsAngle(other);
    }

    public double getRelativeAngle(double other) {
        return this.snapshot.getRelativeAngle(other);
    }

    public double getRelativeAngle(StaticHeading other) {
        return this.snapshot.getRelativeAngle(other);
    }

    public double getCompoundAngle(double other) {
        return this.snapshot.getCompoundAngle(other);
    }

    public double getCompoundAngle(StaticHeading other) {
        return this.snapshot.getCompoundAngle(other);
    }

    public double getVelocity() {
        return this.snapshot.getVelocity();
    }

    public boolean equalsVelocity(double other) {
        return this.snapshot.equalsVelocity(other);
    }

    public boolean equalsVelocity(StaticVelocity other) {
        return this.snapshot.equalsVelocity(other);
    }

    public double getRelativeVelocity(double other) {
        return this.snapshot.getRelativeVelocity(other);
    }

    public double getRelativeVelocity(StaticVelocity other) {
        return this.snapshot.getRelativeVelocity(other);
    }

    public double getCompoundVelocity(double other) {
        return this.snapshot.getCompoundVelocity(other);
    }

    public double getCompoundVelocity(StaticVelocity other) {
        return this.snapshot.getCompoundVelocity(other);
    }

    public boolean equalsVector(StaticVector other) {
        return this.snapshot.equalsVector(other);
    }

    public StaticVector compareVector(StaticVector other) {
        return this.snapshot.compareVector(other);
    }
}

