/*
 * Decompiled with CFR 0.152.
 */
package cuoq.targeting;

import cuoq.Utils;
import cuoq.targeting.DCGFFrame;
import cuoq.targeting.DCGFGun;
import java.awt.geom.Point2D;
import robocode.Condition;
import robocode.Rules;

public class DCGFWave
extends Condition {
    private Point2D.Double bulletOrigin;
    private double bulletHeading;
    private double bulletPower;
    private double enemyDirection;
    private double distance = 0.0;
    private DCGFGun gun;
    private DCGFFrame frame;
    private final double MAXIMUM_ESCAPE_ANGLE;

    public DCGFWave(DCGFGun gun, DCGFFrame frame, Point2D.Double originLocation, double heading, double bulletPower, double lateralDirection) {
        this.gun = gun;
        this.frame = frame;
        this.bulletOrigin = originLocation;
        this.bulletHeading = heading;
        this.bulletPower = bulletPower;
        this.enemyDirection = lateralDirection;
        this.MAXIMUM_ESCAPE_ANGLE = Math.asin(8.0 / Rules.getBulletSpeed((double)bulletPower));
    }

    public boolean test() {
        Point2D.Double enemyLocation = this.gun.getEnemyLocation();
        this.distance += Rules.getBulletSpeed((double)this.bulletPower);
        if (this.distance > this.bulletOrigin.distance(enemyLocation)) {
            double angleToTarget = Utils.normalAbsoluteAngle(Math.atan2(enemyLocation.getX() - this.bulletOrigin.getX(), enemyLocation.getY() - this.bulletOrigin.getY()));
            double bulletOffset = Utils.normalRelativeAngle(angleToTarget - this.bulletHeading);
            double guessFactor = bulletOffset / this.MAXIMUM_ESCAPE_ANGLE * this.enemyDirection;
            this.frame.setGuessFactor(guessFactor);
            this.gun.removeGFWave(this);
        }
        return false;
    }
}

