/*
 * Decompiled with CFR 0.152.
 */
package nic;

import java.util.Enumeration;
import java.util.Vector;
import nic.Enemy;
import nic.GravPoint;
import nic.MovementStrategy;
import nic.Nicator;

public class CornerAntiGrav
implements MovementStrategy {
    Nicator rob;
    Vector gravpoints;
    int corneradj = 0;

    public CornerAntiGrav(Nicator pRob) {
        this.rob = pRob;
        this.gravpoints = new Vector();
        this.gravpoints.add(new GravPoint(100.0, 100.0, 150.0));
        this.gravpoints.add(new GravPoint(this.rob.getBattleFieldWidth() - 100.0, 100.0, 150.0));
        this.gravpoints.add(new GravPoint(100.0, this.rob.getBattleFieldHeight() - 100.0, 150.0));
        this.gravpoints.add(new GravPoint(this.rob.getBattleFieldWidth() - 100.0, this.rob.getBattleFieldHeight() - 100.0, 150.0));
        this.gravpoints.add(new GravPoint(this.rob.getBattleFieldWidth() / 2.0, this.rob.getBattleFieldHeight() / 2.0, -90.0));
    }

    public double goodness() {
        if (this.rob.getOthers() == 1) {
            return 0.0;
        }
        if (this.rob.getBattleFieldWidth() * this.rob.getBattleFieldHeight() < 2250000.0 && !this.rob.mm.incorner()) {
            return 2.4;
        }
        return 1.0;
    }

    public void maintenance() {
        if (this.corneradj > 10) {
            this.adjustcornerpoints();
            this.corneradj = 0;
        }
    }

    public boolean subjectToVA() {
        return false;
    }

    public void move() {
        double ang;
        double xforce = 0.0;
        double yforce = 0.0;
        double force = 0.0;
        ++this.corneradj;
        int i = 0;
        while (i < this.gravpoints.size()) {
            GravPoint p = (GravPoint)this.gravpoints.elementAt(i);
            force = p.power / Math.pow(this.rob.hf.getRange(this.rob.getX(), this.rob.getY(), p.x, p.y), 1.5);
            ang = this.rob.hf.absbearing(p.x, p.y, this.rob.getX(), this.rob.getY());
            xforce += Math.sin(ang) * force;
            yforce += Math.cos(ang) * force;
            ++i;
        }
        Enumeration e = this.rob.targets.elements();
        while (e.hasMoreElements()) {
            Enemy en = (Enemy)e.nextElement();
            if (en == null || !en.live) continue;
            force = -1000.0 / Math.pow(this.rob.hf.getRange(this.rob.getX(), this.rob.getY(), en.x, en.y), 2.0);
            ang = this.rob.hf.absbearing(en.x, en.y, this.rob.getX(), this.rob.getY());
            xforce += Math.sin(ang) * force;
            yforce += Math.cos(ang) * force;
        }
        xforce += 5000.0 / Math.pow(this.rob.hf.getRange(this.rob.getX(), this.rob.getY(), this.rob.getBattleFieldWidth(), this.rob.getY()), 3.0);
        xforce -= 5000.0 / Math.pow(this.rob.hf.getRange(this.rob.getX(), this.rob.getY(), 0.0, this.rob.getY()), 3.0);
        yforce += 5000.0 / Math.pow(this.rob.hf.getRange(this.rob.getX(), this.rob.getY(), this.rob.getX(), this.rob.getBattleFieldHeight()), 3.0);
        yforce -= 5000.0 / Math.pow(this.rob.hf.getRange(this.rob.getX(), this.rob.getY(), this.rob.getX(), 0.0), 3.0);
        double i2 = Math.random();
        if (Math.random() > 0.5) {
            xforce += (xforce + yforce) * i2;
            yforce += (xforce + yforce) * (1.0 - i2);
        } else {
            xforce += (xforce + yforce) * i2;
            yforce += (xforce + yforce) * (-1.0 + i2);
        }
        this.rob.mm.goTo(this.rob.getX() - xforce, this.rob.getY() - yforce);
    }

    void adjustcornerpoints() {
        GravPoint g;
        double[] points = new double[4];
        Enumeration e = this.rob.targets.elements();
        int i = 0;
        while (i < 4) {
            double xforce = 0.0;
            double yforce = 0.0;
            e = this.rob.targets.elements();
            g = (GravPoint)this.gravpoints.elementAt(i);
            while (e.hasMoreElements()) {
                Enemy en = (Enemy)e.nextElement();
                if (en == null || !en.live) continue;
                double force = -1000.0 / Math.pow(this.rob.hf.getRange(g.x, g.y, en.x, en.y), 2.0);
                double ang = this.rob.hf.absbearing(en.x, en.y, g.x, g.y);
                xforce += Math.abs(Math.sin(ang) * force);
                yforce += Math.abs(Math.cos(ang) * force);
            }
            points[i] = Math.abs(xforce) + Math.abs(yforce);
            ++i;
        }
        int j = 0;
        int i2 = 1;
        while (i2 < 4) {
            if (points[j] > points[i2]) {
                j = i2;
            }
            ++i2;
        }
        g = (GravPoint)this.gravpoints.elementAt(j);
        g.power = this.rob.hf.getRange(g.x, g.y, this.rob.getX(), this.rob.getY()) * 10.0;
    }
}

