/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.KDTree;

import java.text.DecimalFormat;
import java.util.Arrays;
import rdt.Wraith.KDTree.MaxHeap;
import rdt.Wraith.KDTree.MinHeap;

public class IntervalHeap<T>
implements MinHeap<T>,
MaxHeap<T> {
    private static final int defaultCapacity = 64;
    private Object[] data;
    private double[] keys;
    private int capacity;
    private int size;

    public IntervalHeap() {
        this(64);
    }

    public IntervalHeap(int capacity) {
        this.data = new Object[capacity];
        this.keys = new double[capacity];
        this.capacity = capacity;
        this.size = 0;
    }

    @Override
    public void offer(double key, T value) {
        if (this.size >= this.capacity) {
            this.capacity *= 2;
            this.data = Arrays.copyOf(this.data, this.capacity);
            this.keys = Arrays.copyOf(this.keys, this.capacity);
        }
        ++this.size;
        this.data[this.size - 1] = value;
        this.keys[this.size - 1] = key;
        this.siftInsertedValueUp();
    }

    @Override
    public void removeMin() {
        if (this.size == 0) {
            throw new IllegalStateException();
        }
        --this.size;
        this.data[0] = this.data[this.size];
        this.keys[0] = this.keys[this.size];
        this.data[this.size] = null;
        this.siftDownMin(0);
    }

    @Override
    public void replaceMin(double key, T value) {
        if (this.size == 0) {
            throw new IllegalStateException();
        }
        this.data[0] = value;
        this.keys[0] = key;
        if (this.size > 1) {
            if (this.keys[1] < key) {
                this.swap(0, 1);
            }
            this.siftDownMin(0);
        }
    }

    @Override
    public void removeMax() {
        if (this.size == 0) {
            throw new IllegalStateException();
        }
        if (this.size == 1) {
            this.removeMin();
            return;
        }
        --this.size;
        this.data[1] = this.data[this.size];
        this.keys[1] = this.keys[this.size];
        this.data[this.size] = null;
        this.siftDownMax(1);
    }

    @Override
    public void replaceMax(double key, T value) {
        if (this.size == 0) {
            throw new IllegalStateException();
        }
        if (this.size == 1) {
            this.replaceMin(key, value);
            return;
        }
        this.data[1] = value;
        this.keys[1] = key;
        if (key < this.keys[0]) {
            this.swap(0, 1);
        }
        this.siftDownMax(1);
    }

    @Override
    public T getMin() {
        if (this.size == 0) {
            throw new IllegalStateException();
        }
        return (T)this.data[0];
    }

    @Override
    public T getMax() {
        if (this.size == 0) {
            throw new IllegalStateException();
        }
        if (this.size == 1) {
            return (T)this.data[0];
        }
        return (T)this.data[1];
    }

    @Override
    public double getMinKey() {
        if (this.size == 0) {
            throw new IllegalStateException();
        }
        return this.keys[0];
    }

    @Override
    public double getMaxKey() {
        if (this.size == 0) {
            throw new IllegalStateException();
        }
        if (this.size == 1) {
            return this.keys[0];
        }
        return this.keys[1];
    }

    private int swap(int x, int y) {
        Object yData = this.data[y];
        double yDist = this.keys[y];
        this.data[y] = this.data[x];
        this.keys[y] = this.keys[x];
        this.data[x] = yData;
        this.keys[x] = yDist;
        return y;
    }

    private void siftInsertedValueUp() {
        int u = this.size - 1;
        if (u != 0) {
            if (u == 1) {
                if (this.keys[u] < this.keys[u - 1]) {
                    this.swap(u, u - 1);
                }
            } else if (u % 2 == 1) {
                int p = u / 2 - 1 | 1;
                if (this.keys[u] < this.keys[u - 1]) {
                    if (this.keys[u = this.swap(u, u - 1)] < this.keys[p - 1]) {
                        u = this.swap(u, p - 1);
                        this.siftUpMin(u);
                    }
                } else if (this.keys[u] > this.keys[p]) {
                    u = this.swap(u, p);
                    this.siftUpMax(u);
                }
            } else {
                int p = u / 2 - 1 | 1;
                if (this.keys[u] > this.keys[p]) {
                    u = this.swap(u, p);
                    this.siftUpMax(u);
                } else if (this.keys[u] < this.keys[p - 1]) {
                    u = this.swap(u, p - 1);
                    this.siftUpMin(u);
                }
            }
        }
    }

    private void siftUpMin(int c) {
        int p = c / 2 - 1 & 0xFFFFFFFE;
        while (p >= 0 && this.keys[c] < this.keys[p]) {
            this.swap(c, p);
            c = p;
            p = c / 2 - 1 & 0xFFFFFFFE;
        }
    }

    private void siftUpMax(int c) {
        int p = c / 2 - 1 | 1;
        while (p >= 0 && this.keys[c] > this.keys[p]) {
            this.swap(c, p);
            c = p;
            p = c / 2 - 1 | 1;
        }
    }

    private void siftDownMin(int p) {
        int c = p * 2 + 2;
        while (c < this.size) {
            if (c + 2 < this.size && this.keys[c + 2] < this.keys[c]) {
                c += 2;
            }
            if (!(this.keys[c] < this.keys[p])) break;
            this.swap(p, c);
            if (c + 1 < this.size && this.keys[c + 1] < this.keys[c]) {
                this.swap(c, c + 1);
            }
            p = c;
            c = p * 2 + 2;
        }
    }

    private void siftDownMax(int p) {
        int c = p * 2 + 1;
        while (c <= this.size) {
            if (c == this.size) {
                if (!(this.keys[c - 1] > this.keys[p])) break;
                this.swap(p, c - 1);
                break;
            }
            if (c + 2 == this.size) {
                if (this.keys[c + 1] > this.keys[c]) {
                    if (!(this.keys[c + 1] > this.keys[p])) break;
                    this.swap(p, c + 1);
                    break;
                }
            } else if (c + 2 < this.size && this.keys[c + 2] > this.keys[c]) {
                c += 2;
            }
            if (!(this.keys[c] > this.keys[p])) break;
            this.swap(p, c);
            if (this.keys[c - 1] > this.keys[c]) {
                this.swap(c, c - 1);
            }
            p = c;
            c = p * 2 + 1;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public String toString() {
        DecimalFormat twoPlaces = new DecimalFormat("0.00");
        StringBuffer str = new StringBuffer(IntervalHeap.class.getCanonicalName());
        str.append(", size: ").append(this.size()).append(" capacity: ").append(this.capacity());
        int i = 0;
        int p = 2;
        while (i < this.size()) {
            int x;
            str.append("\t");
            for (x = 0; i + x < this.size() && x < p; ++x) {
                str.append(twoPlaces.format(this.keys[i + x])).append(", ");
            }
            str.append("\n");
            i += x;
            p *= 2;
        }
        return str.toString();
    }

    private boolean validateHeap() {
        int i;
        for (i = 0; i < this.size - 1; i += 2) {
            if (!(this.keys[i] > this.keys[i + 1])) continue;
            return false;
        }
        for (i = 2; i < this.size; ++i) {
            double maxParent = this.keys[i / 2 - 1 | 1];
            double minParent = this.keys[i / 2 - 1 & 0xFFFFFFFE];
            if (!(this.keys[i] > maxParent) && !(this.keys[i] < minParent)) continue;
            return false;
        }
        return true;
    }
}

