/*
 * Decompiled with CFR 0.152.
 */
package mcb.modules;

import mcb.interfaces.AModule;
import mcb.interfaces.INavigator;
import mcb.tools.BotWrapper;
import mcb.tools.FieldPoint;
import mcb.tools.NavOrder;
import mcb.tools.Tools;
import robocode.ScannedRobotEvent;

public class Garmin
extends AModule
implements INavigator {
    private FieldPoint dest;
    private Circle pivotCircle;

    public Garmin(BotWrapper botWrapper) {
        super(botWrapper);
    }

    public FieldPoint getDestination(ScannedRobotEvent scannedRobotEvent) {
        FieldPoint fieldPoint;
        if (this.pivotCircle == null) {
            fieldPoint = new FieldPoint(this.bot.getBattleFieldWidth() / 2.0, this.bot.getBattleFieldHeight() / 2.0);
            this.pivotCircle = new Circle(fieldPoint, 100.0);
        }
        fieldPoint = this.pivotCircle.getGrad(Tools.normalAbsoluteAngle(this.bot.getTime() * 10L));
        Circle circle = new Circle(this.getPosition(scannedRobotEvent), 250.0);
        double d = Tools.normalAbsoluteAngle(Math.toDegrees(Math.atan2(fieldPoint.getX() - circle.x, fieldPoint.getY() - circle.y)));
        FieldPoint fieldPoint2 = circle.angleDance(d);
        FieldPoint fieldPoint3 = new FieldPoint((int)Math.min(Math.max(fieldPoint2.x, 20.0), this.bot.getBattleFieldWidth() - 20.0), (int)Math.min(Math.max(fieldPoint2.y, 20.0), this.bot.getBattleFieldHeight() - 20.0));
        return fieldPoint3;
    }

    public NavOrder go(FieldPoint fieldPoint) {
        double d = Tools.getDistance(new FieldPoint((int)this.bot.getX(), (int)this.bot.getY()), fieldPoint);
        double d2 = Tools.normalAbsoluteAngle(Math.toDegrees(Math.atan2(fieldPoint.getX() - this.bot.getX(), fieldPoint.getY() - this.bot.getY())));
        double d3 = Tools.normalRelativeAngle(d2 - this.bot.getHeading());
        NavOrder navOrder = new NavOrder();
        if (d3 < -90.0 || d3 > 90.0) {
            navOrder.setTurn(Tools.normalRelativeAngle(d3 - 180.0));
            navOrder.setDist(-d);
        } else {
            navOrder.setTurn(d3);
            navOrder.setDist(d);
        }
        return navOrder;
    }

    private FieldPoint getPosition(ScannedRobotEvent scannedRobotEvent) {
        double d = Tools.normalAbsoluteAngle(this.bot.getHeading() + scannedRobotEvent.getBearing());
        return new FieldPoint((int)(this.bot.getX() + Math.sin(Math.toRadians(d)) * scannedRobotEvent.getDistance()), (int)(this.bot.getY() + Math.cos(Math.toRadians(d)) * scannedRobotEvent.getDistance()));
    }

    private class Circle {
        public double x;
        public double y;
        public double r;

        Circle(FieldPoint fieldPoint, double d) {
            this.x = fieldPoint.getX();
            this.y = fieldPoint.getY();
            this.r = d;
        }

        FieldPoint getGrad(double d) {
            return new FieldPoint(Math.min(Math.max(Math.sin(Math.toRadians(d)) * this.r + this.x, 10.0), Garmin.this.bot.getBattleFieldWidth() - 10.0), Math.min(Math.max(Math.cos(Math.toRadians(d)) * this.r + this.y, 10.0), Garmin.this.bot.getBattleFieldHeight() - 10.0));
        }

        FieldPoint angleDance(double d) {
            FieldPoint fieldPoint = this.getGrad(Tools.normalAbsoluteAngle(d - 15.0));
            FieldPoint fieldPoint2 = this.getGrad(Tools.normalAbsoluteAngle(d + 15.0));
            FieldPoint fieldPoint3 = new FieldPoint(Garmin.this.bot.getX(), Garmin.this.bot.getY());
            double d2 = Tools.getDistance(fieldPoint, fieldPoint2);
            double d3 = Tools.getDistance(fieldPoint3, fieldPoint);
            double d4 = Tools.getDistance(fieldPoint3, fieldPoint2);
            if (d3 > d2 - 10.0) {
                Garmin.this.dest = fieldPoint;
            }
            if (d4 > d2 - 10.0) {
                Garmin.this.dest = fieldPoint2;
            }
            if (Garmin.this.dest == null) {
                Garmin.this.dest = fieldPoint;
            }
            return Garmin.this.dest;
        }
    }
}

