/*
 * Decompiled with CFR 0.152.
 */
package jcs;

import java.awt.Color;
import jcs.AntiGrav;
import jcs.Coord;
import jcs.Driver;
import jcs.EnemyList;
import jcs.Gunner;
import jcs.Scanner;
import jcs.TargetingMode;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class Seth
extends AdvancedRobot {
    private long ticks = 0L;
    public Scanner scanner;
    public Coord coord;
    private Coord currentPos;
    public EnemyList enemyList;
    public Driver driver;
    public AntiGrav antiGrav;
    public Gunner gunner;
    public TargetingMode targetingMode;

    public void run() {
        this.scanner = new Scanner(this);
        this.enemyList = new EnemyList(this);
        this.driver = new Driver(this);
        this.gunner = new Gunner(this);
        this.setColors(new Color(90, 23, 165), new Color(90, 23, 165), new Color(90, 23, 165));
        while (true) {
            this.calcCurrentPos();
            this.scanner.doScan();
            this.driver.doMove();
            this.gunner.doShoot();
            this.execute();
            ++this.ticks;
        }
    }

    private final void calcCurrentPos() {
        if (this.currentPos == null) {
            this.currentPos = new Coord(this.getX(), this.getY());
        } else {
            this.currentPos.setXY(this.getX(), this.getY());
        }
    }

    public void setCurrentPos(Coord _currentPos) {
        this.currentPos = _currentPos;
    }

    public Coord getCurrentPos() {
        return this.currentPos;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.scanner.scannedRobotEvent(e);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.enemyList.remove(e.getName());
        if (e.getName().equals(this.gunner.getTargetName())) {
            this.gunner.reaquireTarget();
        }
    }

    public long getTicks() {
        return this.ticks;
    }

    public void onHitByBullet(HitByBulletEvent e) {
    }

    public EnemyList getEnemyList() {
        return this.enemyList;
    }

    public void onHitRobot(HitRobotEvent e) {
        this.driver.hitRobotEvent(e);
    }

    public void onBulletHit(BulletHitEvent e) {
        this.gunner.bulletHitEvent(e);
        System.out.println("Hit " + e.getName());
    }

    public void onHitWall(HitWallEvent e) {
        this.driver.hitWallEvent(e);
    }
}

