/*
 * Decompiled with CFR 0.152.
 */
package deith;

import deith.AccuStats;
import deith.Enemy;
import deith.Move;
import deith.MoveGun;
import deith.MoveStats;
import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Czolgzilla
extends AdvancedRobot {
    static int maxAccuTactics = 3;
    static int maxMoveTactics = 2;
    static int accuTactic = 0;
    static int moveTactic = 0;
    static AccuStats accuStats = null;
    static MoveStats moveStats = null;
    static Enemy enemy = null;
    private Move move = new Move();
    private MoveGun moveGun = new MoveGun();
    private final int chaoticMoveTactic = 1;
    private final int wallMoveTactic = 0;
    private boolean imHit = false;
    private int ramCount = 0;
    private int timeSinceLastScan = 10;
    static double enemyAbsoluteBearing;
    private boolean enemyFire = false;
    static boolean bigBalls;
    private int bigBallsCounter = 0;

    public void run() {
        if (this.getRoundNum() == 0) {
            accuStats = new AccuStats(maxAccuTactics);
            moveStats = new MoveStats(maxMoveTactics);
            enemy = new Enemy();
            enemy.clear();
        }
        accuStats.nextRound();
        moveStats.nextRound();
        enemy.nextRound();
        this.setBodyColor(Color.WHITE);
        this.setGunColor(Color.black);
        this.setRadarColor(Color.WHITE);
        this.setBulletColor(Color.white);
        this.setScanColor(Color.black);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        while (true) {
            try {
                while (true) {
                    this.doScanner();
                    this.move.doMove(this, enemy, moveStats, this.enemyFire, this.imHit);
                    this.imHit = false;
                    this.setMoveTactic(this.move.getMoveTactic());
                    this.setMoveColorTactic(this.getMoveTactic());
                    if (this.move.getAhead() != 0.0) {
                        this.setAhead(this.move.getAhead());
                        this.enemyFire = false;
                    }
                    if (this.move.getRight() != 0.0) {
                        this.setTurnRightRadians(this.move.getRight());
                    }
                    this.moveGun.doMoveGun(this, enemy, accuStats);
                    if (this.moveGun.getRotateAngle() != 0.0) {
                        this.setTurnGunRightRadians(this.moveGun.getRotateAngle());
                    }
                    this.setAccuTactic(this.moveGun.getAccuTactic());
                    this.setGunColorTactic(this.getAccuTactic());
                    this.execute();
                    if (this.getGunTurnRemaining() != 0.0 || this.getGunHeat() != 0.0) continue;
                    this.doFire(enemy.getNow().getDistance());
                    this.execute();
                }
            }
            catch (Exception e) {
                System.out.println("EXEPTION Czol " + e.getMessage());
                continue;
            }
            break;
        }
    }

    public void doScanner() {
        ++this.timeSinceLastScan;
        double radarOffset = Double.POSITIVE_INFINITY;
        if (this.timeSinceLastScan < 3) {
            radarOffset = Utils.normalRelativeAngle((double)(this.getRadarHeadingRadians() - enemyAbsoluteBearing));
            radarOffset += Math.signum(radarOffset) * 0.02;
        }
        this.setTurnRadarLeftRadians(radarOffset);
    }

    public void doFire(double robotDistance) {
        double gp = this.moveGun.getGunPower();
        if (enemy.isAlive() && this.getEnergy() > 0.5 && gp != 0.0) {
            this.fire(gp);
            accuStats.fireBullet(this.getAccuTactic());
            accuStats.nextRound();
            moveStats.nextRound();
        }
    }

    public double getGunPower(double robotDistance) {
        double gunPower = 0.1;
        if (this.getEnergy() < 2.0) {
            gunPower = 0.1;
        } else if (this.getEnergy() < 6.0) {
            double proc = accuStats.getTacticStat(this.getAccuTactic());
            if (proc > 50.0) {
                gunPower = 0.89;
            } else if (proc > 20.0) {
                gunPower = 0.245;
            } else if (proc > 0.0) {
                gunPower = 0.11;
            }
        } else if (robotDistance > 150.0) {
            double proc = accuStats.getTacticStat(this.getAccuTactic());
            if (this.bigBallsCounter == 3) {
                bigBalls = false;
                this.bigBallsCounter = 0;
            }
            if (bigBalls && !enemy.isRambot()) {
                gunPower = 3.0;
                if (proc < 35.0) {
                    ++this.bigBallsCounter;
                }
            } else if (proc > 40.0) {
                gunPower = 3.0;
            } else if (proc > 30.0) {
                gunPower = 2.6;
            } else if (proc > 25.0) {
                gunPower = 2.3;
            } else if (proc > 20.0) {
                gunPower = 2.1;
            } else if (proc > 0.0) {
                if (Math.random() > 0.95) {
                    gunPower = 3.0 * Math.random();
                } else if (Math.random() > 0.8) {
                    gunPower = 2.0 * Math.random();
                } else if (Math.random() > 0.0) {
                    gunPower = Math.random();
                }
                if (gunPower < 0.1) {
                    gunPower = 0.1;
                }
            }
        } else {
            gunPower = 3.0;
        }
        return gunPower;
    }

    public void onRobotDeath(RobotDeathEvent e) {
        enemy.setAlive(false);
        System.out.println(accuStats.toString());
        System.out.println(moveStats.toString());
    }

    public void onDeath(DeathEvent event) {
        System.out.println(accuStats.toString());
        System.out.println(moveStats.toString());
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (enemy.getLastTime() != this.getTime()) {
            enemy.setNow(e);
        }
        enemyAbsoluteBearing = this.getHeadingRadians() + enemy.getNow().getBearingRadians();
        this.timeSinceLastScan = 0;
        if (e.getEnergy() < enemy.getEnergy()) {
            double damage = enemy.getEnergy() - e.getEnergy();
            enemy.setEnergy(e.getEnergy());
            moveStats.missBullet(moveTactic);
            this.enemyFire = true;
        }
        if (e.getDistance() < 50.0) {
            ++this.ramCount;
        }
        if (this.ramCount == 50) {
            enemy.setRambot(true);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        moveStats.hitBullet(moveTactic);
        double damage = e.getBullet().getPower() * 3.0;
        enemy.doDamage(-damage);
        this.imHit = true;
        if (e.getPower() > 2.5 && enemy.getNow().getDistance() > 300.0) {
            bigBalls = true;
        } else if (e.getPower() < 2.5 && enemy.getNow().getDistance() > 300.0) {
            bigBalls = false;
        }
    }

    public void onBulletMissed(BulletMissedEvent e) {
        if (e.getBullet().getName() == this.getName() && enemy.isAlive()) {
            accuStats.missBullet();
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        if (e.getBullet().getVictim() == enemy.getNow().getName()) {
            if (enemy.isAlive()) {
                accuStats.hitBullet();
            }
            double damage = e.getBullet().getPower() * 4.0;
            if (e.getBullet().getPower() > 1.0) {
                damage += 2.0 * (e.getBullet().getPower() - 1.0);
            }
            enemy.doDamage(damage);
        }
    }

    public void onHitRobot(HitRobotEvent e) {
        enemy.setEnergy(e.getEnergy());
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        if (enemy.isAlive()) {
            accuStats.missBullet();
        }
        moveStats.missBullet(moveTactic);
    }

    private void setGunColorTactic(int tactic) {
        switch (tactic) {
            case 0: {
                this.setGunColor(Color.BLACK);
                this.setRadarColor(Color.BLACK);
                break;
            }
            case 1: {
                this.setGunColor(Color.RED);
                this.setRadarColor(Color.RED);
                break;
            }
            case 2: {
                this.setGunColor(Color.WHITE);
                this.setRadarColor(Color.WHITE);
            }
        }
    }

    private void setMoveColorTactic(int tactic) {
        switch (tactic) {
            case 0: {
                this.setBodyColor(Color.BLACK);
                break;
            }
            case 1: {
                this.setBodyColor(Color.RED);
                break;
            }
            case 2: {
                this.setBodyColor(Color.WHITE);
            }
        }
    }

    public int getMoveTactic() {
        return moveTactic;
    }

    public void setMoveTactic(int moveTactic) {
        Czolgzilla.moveTactic = moveTactic;
    }

    public int getAccuTactic() {
        return accuTactic;
    }

    public void setAccuTactic(int accuTactic) {
        Czolgzilla.accuTactic = accuTactic;
    }

    static {
        bigBalls = false;
    }
}

