/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import tcf.DeQueue;
import tcf.Debug;
import tcf.GfBase;
import tcf.OrderedQueue;
import tcf.Pair;
import tcf.Prediction;
import tcf.StaticStore;
import tcf.TestGf;

class DcGuessFactor
implements GfBase {
    public static final int NODE_ITEM_LIMIT = 59;
    public static final int LRU_ITEM_LIMIT = 15000;
    public static final int N_TOP = 30;
    Node m_root = new Node(null);
    DeQueue<Item> m_lru = new DeQueue();
    double[] m_weight;

    DcGuessFactor(String string) {
        Debug.printf("DcGuessFactor(%s)\n", string);
        if (StaticStore.get(string + ".dcroot") != null) {
            this.m_root = (Node)StaticStore.get(string + ".dcroot");
            this.m_lru = (DeQueue)StaticStore.get(string + ".dclru");
            Debug.printf("%s LRU contains %d items\n", string, this.m_lru.size());
        } else {
            StaticStore.put(string + ".dcroot", this.m_root);
            StaticStore.put(string + ".dclru", this.m_lru);
        }
        this.m_weight = new double[]{0.125, 0.0, 0.6666666666666666, 0.01, 0.02, 0.5, 0.004};
    }

    public void learn(double[] dArray, double d) {
        Item item = new Item();
        item.m_gfData = dArray;
        item.m_gf = d;
        this.m_root.add(item);
        this.m_lru.addTail(item);
        if (this.m_lru.size() > 15000) {
            item = this.m_lru.removeHead();
            this.m_root.remove(item);
        }
    }

    public void orig_predict(double[] dArray, Prediction prediction) {
        Node node = this.m_root.findNode(dArray);
        prediction.clear();
        double d = 0.0;
        for (Item item : node.m_items) {
            double d2 = 0.0;
            for (int i = 0; i < this.m_weight.length; ++i) {
                double d3 = (dArray[i] - item.m_gfData[i]) * this.m_weight[i];
                d2 += d3 * d3;
            }
            double d4 = 1.0 / (d2 + 1.0E-6);
            prediction.addGf(item.m_gf, d4);
            d += d4;
        }
        if (d > 0.0) {
            prediction.scale(1.0 / d);
        }
    }

    public void predict(double[] dArray, Prediction prediction) {
        Node node = this.m_root.findNode(dArray);
        prediction.clear();
        double d = 0.0;
        OrderedQueue<Double, Item> orderedQueue = new OrderedQueue<Double, Item>();
        Object object = node.m_items.iterator();
        while (object.hasNext()) {
            Item item = object.next();
            double d2 = 0.0;
            for (int i = 0; i < this.m_weight.length; ++i) {
                double d3 = (dArray[i] - item.m_gfData[i]) * this.m_weight[i];
                d2 += d3 * d3;
            }
            double d4 = 1.0 / (d2 + 1.0E-6);
            if (orderedQueue.size() < 30 || d4 >= (Double)orderedQueue.peek().x) {
                orderedQueue.add(d4, item);
            }
            if (orderedQueue.size() <= 30) continue;
            orderedQueue.remove();
        }
        while ((object = orderedQueue.remove()) != null) {
            prediction.addGf(((Item)((Pair)object).y).m_gf, (Double)((Pair)object).x);
            d += ((Double)((Pair)object).x).doubleValue();
        }
        if (d > 0.0) {
            prediction.scale(1.0 / d);
        }
    }

    public double oldbest(double[] dArray, double d) {
        Node node = this.m_root.findNode(dArray);
        Item item = null;
        double d2 = Double.POSITIVE_INFINITY;
        for (Item item2 : node.m_items) {
            double d3 = 0.0;
            for (int i = 0; i < this.m_weight.length; ++i) {
                double d4 = (dArray[i] - item2.m_gfData[i]) * this.m_weight[i];
                d3 += d4 * d4;
            }
            d3 = Math.sqrt(d3);
            if (item != null && !(d2 > d3)) continue;
            item = item2;
            d2 = d3;
        }
        if (item == null) {
            return 0.5;
        }
        return item.m_gf;
    }

    public double best(double[] dArray, double d, TestGf testGf) {
        Node node = this.m_root.findNode(dArray);
        double d2 = Math.max(10.0, 10.0 / (2.0 * d));
        int n = 11 + (int)d2;
        double[] dArray2 = new double[n];
        for (Item item : node.m_items) {
            int n2;
            if (testGf != null && !testGf.test(item.m_gf)) continue;
            double d3 = 0.0;
            for (n2 = 0; n2 < this.m_weight.length; ++n2) {
                double d4 = (dArray[n2] - item.m_gfData[n2]) * this.m_weight[n2];
                d3 += d4 * d4;
            }
            d3 = Math.sqrt(d3);
            n2 = 5 + (int)(item.m_gf * d2);
            if (n2 < 0 || n2 >= dArray2.length) {
                Debug.printf("index out of range: %d (0..%d) gf=%g\n", n2, dArray2.length - 1, item.m_gf);
                n2 = Math.max(0, Math.min(n2, dArray2.length - 1));
            }
            int n3 = n2;
            dArray2[n3] = dArray2[n3] + 1.0 / (d3 + 0.001);
        }
        int n4 = -1;
        double d5 = 0.0;
        for (int i = 0; i < n - 10; ++i) {
            double d6 = 0.0;
            for (int j = 0; j < 10; ++j) {
                d6 += dArray2[i + j];
            }
            if (!(d6 > 0.0) || n4 >= 0 && !(d5 < d6)) continue;
            n4 = i + 5;
            d5 = d6;
        }
        if (n4 < 0) {
            return 0.5;
        }
        double d7 = (double)n4 / d2;
        return d7;
    }

    public double[][] bestList(double[] dArray) {
        Node node = this.m_root.findNode(dArray);
        assert (node != null);
        double[] dArray2 = new double[31];
        double[] dArray3 = new double[31];
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        for (Item item : node.m_items) {
            int n2;
            double d3 = 0.0;
            for (int i = 0; i < this.m_weight.length; ++i) {
                double d4 = (dArray[i] - item.m_gfData[i]) * this.m_weight[i];
                d3 += d4 * d4;
            }
            double d5 = 1.0 / ((d3 = Math.sqrt(d3)) + 0.001);
            if (!(d5 > 0.0) || !(d5 >= d2)) continue;
            if (n >= dArray2.length) {
                for (n2 = 0; n2 < n; ++n2) {
                    if (dArray2[n2] != d2) continue;
                    dArray2[n2] = dArray2[--n];
                    dArray3[n2] = dArray3[n];
                    break;
                }
            }
            dArray2[n] = d5;
            dArray3[n] = item.m_gf;
            ++n;
            if (d < d5) {
                d = d5;
            }
            d2 = Double.MAX_VALUE;
            for (n2 = 0; n2 < n; ++n2) {
                d2 = Math.min(d2, dArray2[n2]);
            }
        }
        if (n == 0) {
            dArray2[n] = 1.0;
            dArray3[n] = 0.5;
            ++n;
        }
        Object object = new double[2][n];
        for (int i = 0; i < n; ++i) {
            object[0][i] = dArray3[i];
            object[1][i] = dArray2[i] / d;
        }
        return object;
    }

    class Node {
        Node m_parent;
        int m_dim = -1;
        double m_value = 0.0;
        Node m_a = null;
        Node m_b = null;
        List<Item> m_items = new ArrayList<Item>();

        Node(Node node) {
            this.m_parent = node;
        }

        void add(Item item) {
            if (this.m_a != null) {
                if (item.m_gfData[this.m_dim] < this.m_value) {
                    this.m_a.add(item);
                } else {
                    this.m_b.add(item);
                }
            } else {
                this.m_items.add(item);
                if (this.m_items.size() > 59) {
                    this.autoSplitNode();
                }
            }
        }

        void remove(Item item) {
            Node node = DcGuessFactor.this.m_root.findNode(item.m_gfData);
            if (node != null) {
                node.m_items.remove(item);
                if (node.m_items.size() < 19) {
                    Debug.println("Node probably needs to be collapsed or re-segmented");
                }
            }
        }

        Node getSibling() {
            if (this.m_parent == null) {
                return null;
            }
            if (this.m_parent.m_a == this) {
                return this.m_parent.m_b;
            }
            return this.m_parent.m_a;
        }

        Node findNode(double[] dArray) {
            if (this.m_a == null) {
                return this;
            }
            if (dArray[this.m_dim] < this.m_value) {
                return this.m_a.findNode(dArray);
            }
            return this.m_b.findNode(dArray);
        }

        void splitNode(int n, double d) {
            assert (this.m_a == null);
            assert (this.m_b == null);
            assert (this.m_dim < 0);
            assert (this.m_value == 0.0);
            this.m_dim = n;
            this.m_value = d;
            this.m_a = new Node(this);
            this.m_b = new Node(this);
            for (Item item : this.m_items) {
                if (item.m_gfData[n] < d) {
                    this.m_a.m_items.add(item);
                    continue;
                }
                this.m_b.m_items.add(item);
            }
            this.m_items = null;
        }

        private void dumpNodePath() {
            if (this.m_parent != null) {
                this.m_parent.dumpNodePath();
            }
            Debug.printf("Node: %d : %g\n", this.m_dim, this.m_value);
        }

        void autoSplitNode() {
            int n;
            int n2 = Math.min(this.m_items.get((int)0).m_gfData.length, DcGuessFactor.this.m_weight.length);
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            Arrays.fill(dArray, Double.POSITIVE_INFINITY);
            for (Item item : this.m_items) {
                for (n = 0; n < n2; ++n) {
                    if (dArray[n] > item.m_gfData[n]) {
                        dArray[n] = item.m_gfData[n];
                    }
                    if (!(dArray2[n] < item.m_gfData[n])) continue;
                    dArray2[n] = item.m_gfData[n];
                }
            }
            int n3 = 0;
            for (int i = 1; i < n2; ++i) {
                if (!((dArray2[n3] - dArray[n3]) * DcGuessFactor.this.m_weight[n3] < (dArray2[i] - dArray[i]) * DcGuessFactor.this.m_weight[i])) continue;
                n3 = i;
            }
            double[] dArray3 = new double[this.m_items.size()];
            for (n = 0; n < this.m_items.size(); ++n) {
                dArray3[n] = this.m_items.get((int)n).m_gfData[n3];
            }
            Arrays.sort(dArray3);
            double d = (dArray[n3] + dArray2[n3]) / 2.0;
            this.splitNode(n3, d);
        }
    }

    class Item {
        double[] m_gfData;
        double m_gf;

        Item() {
        }
    }
}

