/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import tcf.AbstractPredictor;
import tcf.DataSegmenter;
import tcf.Drifter;
import tcf.PredState;
import tcf.Prediction;
import tcf.StaticStore;

class SegmentedGfPredictor
extends AbstractPredictor {
    private double m_rollDepth;
    private DataSegmenter m_ds;
    private Prediction[] m_p;

    public SegmentedGfPredictor(String string, DataSegmenter dataSegmenter, double d) {
        this.m_rollDepth = d;
        this.m_ds = dataSegmenter;
        if (StaticStore.get(string + ".p") != null) {
            this.m_p = (Prediction[])StaticStore.get(string + ".p");
        } else {
            StaticStore.put(string + ".p", this.m_p);
            this.m_p = new Prediction[dataSegmenter.size()];
            for (int i = 0; i < this.m_p.length; ++i) {
                this.m_p[i] = new Prediction();
            }
        }
    }

    public Object predict(PredState predState, Prediction prediction) {
        double[] dArray = Drifter.calcGfData(predState.m_arena, predState.m_target, predState.m_gun);
        int n = this.m_ds.seg(dArray);
        Prediction prediction2 = this.m_p[n];
        prediction.copyFrom(prediction2);
        return prediction2;
    }

    public void learn(PredState predState, PredState predState2, Object object, double d, boolean bl) {
        if (object instanceof Prediction && bl) {
            Prediction prediction = (Prediction)object;
            int n = Prediction.gfToIndex(d);
            Prediction prediction2 = new Prediction();
            for (int i = 0; i < 101; ++i) {
                double d2 = (double)(n - i) / 3.0;
                prediction2.set(i, 1.0 / (1.0 + d2 * d2));
            }
            prediction.roll(prediction2, this.m_rollDepth);
        }
    }
}

