/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

class Range {
    double min;
    double max;

    public Range(double d) {
        this.min = d - 0.5;
        this.max = d + 0.5;
    }

    public Range(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public Range(long d) {
        if (d == 10000L) {
            this.min = 40.0;
            this.max = 10000.0;
        } else {
            this.min = (double)d - 0.5;
            this.max = (double)d + 0.5;
        }
    }

    public boolean test(double d) {
        return d >= this.min && d <= this.max;
    }

    public boolean isSpecialCaseOf(Range generalRange) {
        if (this.min < generalRange.min) {
            return false;
        }
        return !(this.max > generalRange.max);
    }

    public double cmp(Range r) {
        double intersec = (r.max < this.max ? r.max : this.max) - (r.min > this.min ? r.min : this.min);
        if (intersec < 0.0) {
            return 1.0 / Math.abs(r.min - this.max);
        }
        if (intersec == 0.0) {
            return 1.0;
        }
        return 10.0 + (intersec / (this.max - this.min) + intersec / (r.max - r.min)) / 2.0;
    }

    public void generalizeWith(Range range) {
        this.min = this.min < range.min ? this.min : range.min;
        this.max = this.max > range.max ? this.max : range.max;
    }

    public String toString() {
        return "[" + this.min + "," + this.max + "]";
    }
}

