/*
 * Decompiled with CFR 0.152.
 */
package sqTank.waveSurfing;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import robocode.util.Utils;
import sqTank.util.WaveHelper;

public class LionWWSVMvoid
extends TeamRobot {
    private static double[][][] _surfStats = new double[4][5][47];
    public static Point2D.Double _myLocation;
    public static Point2D.Double _enemyLocation;
    public static LinkedList _enemyWaves;
    private static double _oppEnergy;
    private static Wave _surfWave;
    private static Wave _nextSurfWave;
    private static double _lastDistance;
    private static double _lastLatVel;
    private static double _lastAbsBearingRadians;
    private static double _goAngle;
    private static int _ramCounter;
    private static Rectangle2D.Double _fieldRect;
    public WaveHelper waveHelper = new WaveHelper();
    static final double A_LITTLE_LESS_THAN_HALF_PI = 1.25;
    static final double WALL_STICK = 140.0;
    static final int GF_ZERO = 23;
    static final int GF_ONE = 46;
    private static double _enemyAbsoluteBearing;
    private static int _lastGunOrientation;
    static double lastVChangeTime;
    static int enemyVelocity;
    static double[][][][][][] _gunStats;
    static final double LOG_BASE_E_TO_2_CONVERSION_CONSTANT = 1.4427;

    static {
        _fieldRect = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
        _gunStats = new double[6][4][4][2][3][47];
    }

    public void run() {
        this.setColors(Color.black, Color.black, Color.white);
        _enemyWaves = new LinkedList();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.turnRadarRightRadians(1.0);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double enemyAbsoluteBearing;
        int direction;
        Wave w;
        double d;
        String enemyName = e.getName();
        this.waveHelper.init("SVM", 9, 3, 1, this, enemyName);
        double bulletPower = _oppEnergy - e.getEnergy();
        if (d <= 3.0 && bulletPower > 0.0) {
            w = _nextSurfWave;
            _nextSurfWave.bulletSpeed = Rules.getBulletSpeed((double)bulletPower);
            this.addCustomEvent(w);
            _enemyWaves.addLast(w);
        }
        _nextSurfWave = w = new Wave();
        w.directAngle = _lastAbsBearingRadians;
        w.waveGuessFactors = _surfStats[(int)Math.min((_lastDistance + 50.0) / 200.0, 3.0)][(int)((Math.abs(_lastLatVel) + 1.0) / 2.0)];
        w.orientation = direction = LionWWSVMvoid.sign(_lastLatVel);
        _myLocation = new Point2D.Double(this.getX(), this.getY());
        _enemyAbsoluteBearing = enemyAbsoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        _lastDistance = e.getDistance();
        w.sourceLocation = _enemyLocation = LionWWSVMvoid.project(_myLocation, enemyAbsoluteBearing, _lastDistance);
        w = new Wave();
        new Wave().sourceLocation = _myLocation;
        this.addCustomEvent(w);
        w.directAngle = enemyAbsoluteBearing;
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(w.directAngle - this.getRadarHeadingRadians())) * 2.0);
        try {
            _surfWave = (Wave)((Object)_enemyWaves.getFirst());
            direction = LionWWSVMvoid.sign(this.checkDanger(-1) - this.checkDanger(1));
            _goAngle = _surfWave.absoluteBearing(_myLocation) + 1.25 * (double)direction;
        }
        catch (Exception exception) {
            // empty catch block
        }
        double angle = LionWWSVMvoid.wallSmoothing(_myLocation, _goAngle, direction) - this.getHeadingRadians();
        this.setTurnRightRadians(Math.tan(angle));
        this.setAhead(Math.cos(angle) * Double.POSITIVE_INFINITY);
        double enemyLatVel = e.getVelocity() * Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing);
        _lastGunOrientation = w.orientation = LionWWSVMvoid.sign(enemyLatVel);
        double d2 = lastVChangeTime;
        lastVChangeTime = d2 + 1.0;
        int bestGF = Math.min(3, (int)Math.pow(280.0 * d2 / _lastDistance, 0.7));
        enemyLatVel = Math.abs(enemyLatVel);
        int newVelocity = (int)enemyLatVel;
        if (enemyVelocity != newVelocity) {
            lastVChangeTime = 0.0;
            bestGF = 4;
            if (enemyVelocity > newVelocity) {
                bestGF = 5;
            }
        }
        enemyVelocity = newVelocity;
        w.waveGuessFactors = _gunStats[bestGF][(int)(1.4427 * Math.log(enemyLatVel + 1.5))][LionWWSVMvoid.gunWallDistance(0.18247367367) ? (LionWWSVMvoid.gunWallDistance(0.36494734735) ? (LionWWSVMvoid.gunWallDistance(0.63865785787) ? 3 : 2) : 1) : 0][LionWWSVMvoid.gunWallDistance(-0.36494734735) ? 0 : 1][(int)LionWWSVMvoid.limit(0.0, (_lastDistance - 75.0) / 200.0, 2.0)];
        bestGF = 23;
        int gf = 46;
        while (gf >= 0 && (_oppEnergy = e.getEnergy()) > 0.0) {
            if (w.waveGuessFactors[gf] > w.waveGuessFactors[bestGF]) {
                bestGF = gf;
            }
            --gf;
        }
        double power = 2.0 - Math.max(0.0, (30.0 - this.getEnergy()) / 16.0);
        w.bulletSpeed = Rules.getBulletSpeed((double)power);
        w.distance = -1.5 * w.bulletSpeed;
        Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.getGunHeadingRadians() + (double)_lastGunOrientation * (Math.asin(8.0 / w.bulletSpeed) / 23.0) * (double)(bestGF - 23)));
        this.waveHelper.wave(e);
        if (Math.abs(this.getGunTurnRemaining()) < 3.0) {
            w.weight = 4;
        }
        _lastLatVel = this.getVelocity() * Math.sin(e.getBearingRadians());
        _goAngle = _lastAbsBearingRadians = enemyAbsoluteBearing + Math.PI;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Wave surfWave = _surfWave;
        _oppEnergy += e.getBullet().getPower() * 3.0;
        if (surfWave.distanceToPoint(_myLocation) - surfWave.distance < 100.0) {
            LionWWSVMvoid.logHit(surfWave, _myLocation, 0.7);
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        Point2D.Double bulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
        int x = 0;
        while (x < _enemyWaves.size()) {
            Wave w = (Wave)((Object)_enemyWaves.get(x));
            if (Math.abs(w.distanceToPoint(bulletLocation) - w.distance) < 50.0) {
                LionWWSVMvoid.logHit(w, bulletLocation, 0.7);
            }
            ++x;
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        _oppEnergy -= Rules.getBulletDamage((double)e.getBullet().getPower());
    }

    public void onHitRobot(HitRobotEvent event) {
        ++_ramCounter;
    }

    public void onCustomEvent(CustomEvent e) {
        this.removeCustomEvent(e.getCondition());
    }

    public static void logHit(Wave w, Point2D.Double targetLocation, double rollingDepth) {
        int x = 46;
        while (x >= 0) {
            w.waveGuessFactors[x] = (w.waveGuessFactors[x] * rollingDepth + (double)(1 + w.weight) / (Math.pow(x - LionWWSVMvoid.getFactorIndex(w, targetLocation), 2.0) + 1.0)) / (rollingDepth + 1.0 + (double)w.weight);
            --x;
        }
    }

    private static int getFactorIndex(Wave w, Point2D.Double botLocation) {
        return (int)LionWWSVMvoid.limit(0.0, Utils.normalRelativeAngle((double)(w.absoluteBearing(botLocation) - w.directAngle)) * (double)w.orientation / Math.asin(8.0 / w.bulletSpeed) * 23.0 + 23.0, 46.0);
    }

    private double checkDanger(int direction) {
        double moveDir;
        double moveAngle;
        double maxTurning;
        double lastPredictedDistance;
        Wave surfWave = _surfWave;
        Point2D.Double predictedPosition = _myLocation;
        double predictedHeading = this.getHeadingRadians();
        double predictedVelocity = this.getVelocity();
        int counter = 3;
        do {
            double d;
            moveDir = 1.0;
            moveAngle = LionWWSVMvoid.wallSmoothing(predictedPosition, surfWave.absoluteBearing(predictedPosition) + (double)direction * 1.25, direction) - predictedHeading;
            if (!(Math.cos(d) < 0.0)) continue;
            moveAngle += Math.PI;
            moveDir = -1.0;
        } while ((lastPredictedDistance = surfWave.distanceToPoint(predictedPosition = LionWWSVMvoid.project(predictedPosition, predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + LionWWSVMvoid.limit(-(maxTurning = Rules.getTurnRateRadians((double)Math.abs(predictedVelocity))), Utils.normalRelativeAngle((double)moveAngle), maxTurning))), predictedVelocity = LionWWSVMvoid.limit(-8.0, predictedVelocity + (predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir), 8.0)))) >= surfWave.distance + (double)(++counter) * surfWave.bulletSpeed);
        int index = LionWWSVMvoid.getFactorIndex(surfWave, predictedPosition);
        return (surfWave.waveGuessFactors[index] + 0.01 / (double)(Math.abs(index - 23) + 1)) / Math.pow(lastPredictedDistance, 4.0);
    }

    private static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    private static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    private static int sign(double d) {
        if (d < 0.0) {
            return -1;
        }
        return 1;
    }

    private static double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_fieldRect.contains(LionWWSVMvoid.project(botLocation, angle, 140.0))) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    private static boolean gunWallDistance(double wallDistance) {
        return _fieldRect.contains(LionWWSVMvoid.project(_myLocation, _enemyAbsoluteBearing + (double)_lastGunOrientation * wallDistance, _lastDistance));
    }

    static class Wave
    extends Condition {
        Point2D.Double sourceLocation;
        double[] waveGuessFactors;
        double bulletSpeed;
        double directAngle;
        double distance;
        int orientation;
        int weight;

        Wave() {
        }

        public double distanceToPoint(Point2D.Double p) {
            return this.sourceLocation.distance(p);
        }

        public double absoluteBearing(Point2D.Double target) {
            return Math.atan2(target.x - this.sourceLocation.x, target.y - this.sourceLocation.y);
        }

        public boolean test() {
            double d;
            Point2D.Double double_ = _enemyWaves.contains((Object)this) ? _myLocation : _enemyLocation;
            this.distance += this.bulletSpeed;
            if (this.distanceToPoint(double_) <= d + 2.0 * this.bulletSpeed) {
                if (!_enemyWaves.remove((Object)this)) {
                    LionWWSVMvoid.logHit(this, _enemyLocation, 600.0);
                }
                return true;
            }
            return false;
        }
    }
}

