/*
 * Decompiled with CFR 0.152.
 */
package seed;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.Robot;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import seed.dataset.BulletData;
import seed.predmodel.BattleConfig;
import seed.predmodel.Regressor;
import seed.wave.MyActiveBullet;
import seed.wave.Wave;

public class Anastasia
extends AdvancedRobot {
    public static int BINS = 69;
    public static double[] surfStats = new double[BINS];
    public Point2D.Double myLocation;
    public Point2D.Double enemyLocation;
    public ArrayList<Wave> Waves;
    public ArrayList<Integer> surfDirections;
    public ArrayList<Double> surfAbsBearings;
    public static double _oppEnergy = 100.0;
    public static Rectangle2D.Double fieldRect = null;
    public static double WALL_STICK = 160.0;
    public static Regressor model = new Regressor(100, 100, 6, 4);
    public static BattleConfig bc;
    public static ArrayList<MyActiveBullet> activeBullet;
    public static double myBulletPower;
    public static double enmBulletPower;

    static {
        activeBullet = new ArrayList();
        myBulletPower = 2.0;
        enmBulletPower = 2.0;
    }

    public void run() {
        bc = new BattleConfig((Robot)this);
        if (fieldRect == null) {
            fieldRect = new Rectangle2D.Double(18.0, 18.0, this.getBattleFieldWidth() - 36.0, this.getBattleFieldHeight() - 36.0);
        }
        this.Waves = new ArrayList();
        this.surfDirections = new ArrayList();
        this.surfAbsBearings = new ArrayList();
        this.setBodyColor(Color.white);
        this.setGunColor(Color.white);
        this.setRadarColor(Color.white);
        this.setScanColor(Color.white);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onRoundEnded(RoundEndedEvent e) {
        myBulletPower = 2.0;
        enmBulletPower = 2.0;
        System.out.println("===Weight===");
        model.printWeight();
        System.out.println("===MSE===");
        model.printMSE();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        myBulletPower = enmBulletPower * this.getEnergy() / e.getEnergy();
        this.myLocation = new Point2D.Double(this.getX(), this.getY());
        if (e.getDistance() < 250.0) {
            myBulletPower *= 250.0 / e.getDistance();
        }
        if (myBulletPower > 3.0) {
            myBulletPower = 3.0;
        }
        while (Rules.getBulletDamage((double)myBulletPower) > e.getEnergy()) {
            if (myBulletPower - 0.1 < 0.1) break;
            myBulletPower -= 0.1;
        }
        double lateralVelocity = this.getVelocity() * Math.sin(e.getBearingRadians());
        double absBearing = e.getBearingRadians() + this.getHeadingRadians();
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getRadarHeadingRadians())) * 2.0);
        BulletData shotDataset = new BulletData();
        shotDataset.setSample(this, e, 8, 1);
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absBearing + model.predict(shotDataset) - this.getGunHeadingRadians())));
        this.surfDirections.add(0, lateralVelocity >= 0.0 ? 1 : -1);
        this.surfAbsBearings.add(0, absBearing + Math.PI);
        double bulletPower = _oppEnergy - e.getEnergy();
        if (bulletPower < 3.01 && bulletPower > 0.09 && this.surfDirections.size() > 2) {
            enmBulletPower = bulletPower;
            Wave ew = new Wave();
            ew.fireTime = this.getTime() - 1L;
            ew.distanceTraveled = ew.bulletSpeed = Rules.getBulletSpeed((double)bulletPower);
            ew.direction = this.surfDirections.get(2);
            ew.directAngle = this.surfAbsBearings.get(2);
            ew.fireLocation = (Point2D.Double)this.enemyLocation.clone();
            this.Waves.add(ew);
        }
        _oppEnergy = e.getEnergy();
        this.enemyLocation = Anastasia.project(this.myLocation, absBearing, e.getDistance());
        if (Utils.isNear((double)this.getGunHeat(), (double)0.0) && this.getEnergy() - myBulletPower > 0.1) {
            MyActiveBullet mab = new MyActiveBullet(shotDataset);
            mab.fireTime = this.getTime();
            mab.bulletSpeed = Rules.getBulletSpeed((double)2.0);
            mab.distanceTraveled = 0.0;
            mab.directAngle = absBearing;
            mab.fireLocation = new Point2D.Double(this.getX(), this.getY());
            activeBullet.add(mab);
            this.setFire(myBulletPower);
        }
        this.updateWaves(this.enemyLocation);
        this.doSurfing();
    }

    public void updateWaves(Point2D.Double enemyLocation) {
        int x = 0;
        while (x < this.Waves.size()) {
            Wave ew = this.Waves.get(x);
            ew.distanceTraveled = (double)(this.getTime() - ew.fireTime) * ew.bulletSpeed;
            if (ew.distanceTraveled > this.myLocation.distance(ew.fireLocation) + 50.0) {
                this.Waves.remove(x);
                --x;
            }
            ++x;
        }
        if (enemyLocation == null) {
            return;
        }
        x = 0;
        while (x < activeBullet.size()) {
            MyActiveBullet abw = activeBullet.get(x);
            abw.distanceTraveled = (double)(this.getTime() - abw.fireTime) * abw.bulletSpeed;
            if (abw.distanceTraveled > enemyLocation.distance(abw.fireLocation) + 50.0) {
                model.addSample(activeBullet.get(x).getBullet(enemyLocation.getX(), enemyLocation.getY()));
                activeBullet.remove(x);
                --x;
            }
            ++x;
        }
        model.updateModel();
    }

    public Wave getClosestSurfableWave() {
        double closestDistance = Double.POSITIVE_INFINITY;
        Wave surfWave = null;
        int x = 0;
        while (x < this.Waves.size()) {
            Wave ew = this.Waves.get(x);
            double distance = this.myLocation.distance(ew.fireLocation) - ew.distanceTraveled;
            if (distance > ew.bulletSpeed && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
            ++x;
        }
        return surfWave;
    }

    public static int getFactorIndex(Wave ew, Point2D.Double targetLocation) {
        double offsetAngle = Anastasia.absoluteBearing(ew.fireLocation, targetLocation) - ew.directAngle;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / Anastasia.maxEscapeAngle(ew.bulletSpeed) * (double)ew.direction;
        return (int)Anastasia.limit(0.0, factor * (double)((BINS - 1) / 2) + (double)((BINS - 1) / 2), BINS - 1);
    }

    public void logHit(Wave ew, Point2D.Double targetLocation) {
        int index = Anastasia.getFactorIndex(ew, targetLocation);
        int x = 0;
        while (x < BINS) {
            int n = x;
            surfStats[n] = surfStats[n] + 1.0 / (Math.pow(index - x, 2.0) + 1.0);
            ++x;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (!this.Waves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            Wave hitWave = null;
            int x = 0;
            while (x < this.Waves.size()) {
                Wave ew = this.Waves.get(x);
                if (Math.abs(ew.distanceTraveled - this.myLocation.distance(ew.fireLocation)) < 50.0 && Utils.isNear((double)Rules.getBulletSpeed((double)e.getBullet().getPower()), (double)ew.bulletSpeed)) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this.Waves.remove(this.Waves.lastIndexOf(hitWave));
            }
        }
    }

    public Point2D.Double predictPosition(Wave surfWave, int direction) {
        Point2D.Double predictedPosition = (Point2D.Double)this.myLocation.clone();
        double predictedVelocity = this.getVelocity();
        double predictedHeading = this.getHeadingRadians();
        int counter = 0;
        boolean intercepted = false;
        do {
            double moveAngle = this.wallSmoothing(predictedPosition, Anastasia.absoluteBearing(surfWave.fireLocation, predictedPosition) + (double)direction * 1.5707963267948966, direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + Anastasia.limit(-maxTurning, moveAngle, maxTurning)));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
            predictedVelocity = Anastasia.limit(-8.0, predictedVelocity, 8.0);
            predictedPosition = Anastasia.project(predictedPosition, predictedHeading, predictedVelocity);
            ++counter;
            if (!(predictedPosition.distance(surfWave.fireLocation) < surfWave.distanceTraveled + (double)counter * surfWave.bulletSpeed + surfWave.bulletSpeed)) continue;
            intercepted = true;
        } while (!intercepted && counter < 500);
        return predictedPosition;
    }

    public double checkDanger(Wave surfWave, int direction) {
        int index = Anastasia.getFactorIndex(surfWave, this.predictPosition(surfWave, direction));
        return surfStats[index];
    }

    public void doSurfing() {
        Wave surfWave = this.getClosestSurfableWave();
        if (surfWave == null) {
            return;
        }
        double dangerLeft = this.checkDanger(surfWave, -1);
        double dangerRight = this.checkDanger(surfWave, 1);
        double goAngle = Anastasia.absoluteBearing(surfWave.fireLocation, this.myLocation);
        goAngle = dangerLeft < dangerRight ? this.wallSmoothing(this.myLocation, goAngle - 1.5707963267948966, -1) : this.wallSmoothing(this.myLocation, goAngle + 1.5707963267948966, 1);
        Anastasia.setBackAsFront(this, goAngle);
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!fieldRect.contains(Anastasia.project(botLocation, angle, 160.0))) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    public void onPaint(Graphics2D g) {
        int i = 0;
        while (i < this.Waves.size()) {
            g.setColor(Color.red);
            Wave w = this.Waves.get(i);
            Point2D.Double center = w.fireLocation;
            int radius = (int)w.distanceTraveled;
            if ((double)(radius - 40) < center.distance(this.myLocation)) {
                g.drawOval((int)(center.x - (double)radius), (int)(center.y - (double)radius), radius * 2, radius * 2);
            }
            ++i;
        }
    }
}

