   package jk.precise.util;

   import java.awt.geom.*;


    public class Trig{
   
   //<CREDIT>: Rednaxela for the 'fast trig' functions, although acos is my own
      public static final int DIVISIONS = 8192;
      public static final int acos_DIVISIONS = 131072;
      public static final double K = DIVISIONS/(Math.PI*2);
      public static final double acosK = (acos_DIVISIONS - 1)/2;
      public static final double[] sineTable = new double[DIVISIONS];
      public static final double[] acosTable = new double[acos_DIVISIONS];
      
      static {
         for (int i=0; i<DIVISIONS; i++) 
            sineTable[i] = Math.sin(i/K);
         for(int i = 0; i < acos_DIVISIONS; i++){
            acosTable[i] = Math.acos(i/acosK - 1);
         }
      }
   
       public static final double sin(double value) {
         return  sineTable[(int)(((value*K + 0.5) % DIVISIONS + DIVISIONS))&(DIVISIONS - 1)];
      }
   
       public static final double cos(double value) {
         return sineTable[(int)(((value*K + 0.5) % DIVISIONS + 1.25*DIVISIONS))&(DIVISIONS - 1)];
      }
      
       public static final double acos(double value){
         return acosTable[(int)(value*acosK + (acosK + 0.5))];//&(acos_DIVISIONS - 1)] ;
      }
   
       public static final double asin(double value){
         return Math.PI/2 - acos(value);
      }
   	
       public static final double atan2(double x, double y){
         return (x>=0 ? acos(y / Math.sqrt(x*x + y*y)) :  -acos(y / Math.sqrt(x*x + y*y)));
      }
   
   //</CREDIT>
   
   
   
       public static final Point2D.Double project(Point2D.Double start, double angle, double distance){
         return new Point2D.Double(
            start.x + sin(angle)*distance,
            start.y + cos(angle)*distance);
      }
   
       public static final double absoluteBearing(Point2D.Double source, Point2D.Double target) {
         return atan2(target.x - source.x, target.y - source.y);
      }
   
       public static final double maxEscapeAngle(double velocity) {
         return asin(8.0/velocity);
      }
   
   
   
     //<CREDIT>: Simonton
   	
      static double HALF_PI = Math.PI / 2;
      static double WALL_MARGIN = 18;
      static double S = WALL_MARGIN;
      static double W = WALL_MARGIN;
      static double N = 600 - WALL_MARGIN;
      static double E = 800 - WALL_MARGIN;
      public static final double WALKING_STICK = 160;
    // eDist  = the distance from you to the enemy
    // eAngle = the absolute angle from you to the enemy
    // oDir   =  1 for the clockwise orbit distance
    //          -1 for the counter-clockwise orbit distance
    // returns: the positive orbital distance (in radians) the enemy can travel
    //          before hitting a wall (possibly infinity).
       public static final double wallDistance(double eDist, double eAngle, double oDir, Point2D.Double fireLocation) {
       
         return Math.min(Math.min(Math.min(
            distanceWest(N - fireLocation.y, eDist, eAngle - HALF_PI, oDir),
            distanceWest(E - fireLocation.x, eDist, eAngle + Math.PI, oDir)),
            distanceWest(fireLocation.y - S, eDist, eAngle + HALF_PI, oDir)),
            distanceWest(fireLocation.x - W, eDist, eAngle, oDir));
      }
       //non-iterative wallsmoothing by Simonton - to save your CPUs
   // angle = the angle you'd like to go if there weren't any walls
    // oDir  =  1 if you are currently orbiting the enemy clockwise
    //         -1 if you are currently orbiting the enemy counter-clockwise
    // returns the angle you should travel to avoid walls
       public static final double wallSmoothing(Point2D.Double botLocation, double angle, double oDir) {
         // if(!_fieldRect.contains(project(botLocation,angle + Math.PI*(oDir + 1),WALKING_STICK))){
         angle = smoothWest(N - botLocation.y, angle - HALF_PI, oDir) + HALF_PI;
         angle = smoothWest(E - botLocation.x, angle + Math.PI, oDir) - Math.PI;
         angle = smoothWest(botLocation.y - S, angle + HALF_PI, oDir) - HALF_PI;
         angle = smoothWest(botLocation.x - W, angle, oDir);
         
         // for bots that could calculate an angle that is pointing pretty far
         // into a corner, these three lines may be necessary when travelling
         // counter-clockwise (since the smoothing above may have moved the 
         // walking stick into another wall)
         angle = smoothWest(botLocation.y - S, angle + HALF_PI, oDir) - HALF_PI;
         angle = smoothWest(E - botLocation.x, angle + Math.PI, oDir) - Math.PI;
         angle = smoothWest(N - botLocation.y, angle - HALF_PI, oDir) + HALF_PI;
         // }
         return angle;
      }
   
    // smooths against the west wall
       private static final double smoothWest(double dist, double angle, double oDir) {
         if (dist < -WALKING_STICK * sin(angle)) {
            return acos(oDir * dist / WALKING_STICK) - oDir * HALF_PI;
         }
         return angle;
      }
       private static final double distanceWest(double toWall, double eDist, double eAngle, double oDir) {
         if (eDist <= toWall) {
            return Double.POSITIVE_INFINITY;
         }
         double wallAngle = acos(-oDir * toWall / eDist) + oDir * HALF_PI;
         return robocode.util.Utils.normalAbsoluteAngle(oDir * (wallAngle - eAngle));
      }
      //</CREDIT>
   }