package cs.s2.move;

import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.LinkedList;

import cs.s2.Extension;
import cs.s2.Seraphim;
import cs.s2.misc.Tools;
import cs.s2.misc.Wave;
import cs.s2.stat.SplitSet;
import cs.s2.stat.StatBuffer;
import cs.s2.stat.StatBufferSet;
import cs.s2.stat.StatData;
import cs.utils.BasicTracker;
import cs.utils.Simulate;

import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;
import robocode.util.Utils;


public class SurferBaseX extends Extension {
	
	private static class State {
		long time;
		
		Point2D enemyLocation;
		
		Point2D myLocation;
		double myHeading;
		double myVelocity;
		double myLateralVelocity;
		int direction;
		
		double[] waveData;
	}
	private static final int totalBin = 47;
	public static final StatBufferSet sbs = new StatBufferSet();

	private static final double bestDist = 500;
	private static final double dangerDist = 200;
	
	LinkedList<State> log = new LinkedList<State>();
	LinkedList<Wave> waveLog = new LinkedList<Wave>();
	State lastState = null;
	
	boolean firstTurn = false;
	
	private static long shotsFired = 0;
	private static long shotsHit = 0;
	
	private static double bfwidth = 800;
	private static double bfheight = 600;
	
	public BasicTracker tracker = new BasicTracker(bfwidth,bfheight);
	
	public boolean flattener = false;
	
	public void run() {
		if(bot.getRoundNum() == 0) {
			System.out.println("\tWings: I am in your Danmaku, grazing your bullets.");
			bfwidth = bot.getBattleFieldWidth();
			bfheight = bot.getBattleFieldHeight();
			
			StatBuffer buffer = new StatBuffer(totalBin);
			buffer.setHalflife(0.7);
			sbs.add(buffer, 1.0);
			
			
			/* Fast Buffers */
			SplitSet set = new SplitSet();
			set.add(new double[]{ 2.0, 4.0, 6.0 }, 0); //Abs Lat Velcoity
			set.add(new double[]{ 2.0 }, 1); //Adv Velcoity
			buffer = new StatBuffer(set, totalBin);
			buffer.setHalflife(0.7);
			sbs.add(buffer, 20.0);
			
			/* Fast Buffer */
			set = new SplitSet();
			set.add(new double[]{ 0.5, 2.5, 5.0, 7.5 }, 0); //Abs Lat Velcoity
			set.add(new double[]{ -3, 3 }, 1); //Adv Velcoity
			buffer = new StatBuffer(set, totalBin);
			buffer.setHalflife(0.7);
			sbs.add(buffer, 30.0);
			
			set = new SplitSet();
			set.add(new double[]{ 1, 3, 5, 7 }, 0); //Abs Lat Velcoity
			set.add(new double[]{ -3, 3 }, 1); //Adv Velcoity
			set.add(new double[]{ 0.3, 0.65 }, 3); //Wall Distance Forward
			buffer = new StatBuffer(set, totalBin);
			buffer.setHalflife(0.7);
			sbs.add(buffer, 40.0);
		}
		firstTurn = false;
		lastState = null;
		log.clear();
	}
	
	public void execute() {
		if(Seraphim.isReference) return;
		if(lastState == null) return;
		
		if(bot.getOthers() == 0
		&& waveLog.size() == 0) {
			bot.setAhead(0);
			//bot.setTurnRightRadians(0);
			
			return;
		}
		
		int direction = lastState.direction;

		
		/* This ''should'' be safe. */
		lastState.myLocation = new Point2D.Double(bot.getX(), bot.getY());
		lastState.myHeading = bot.getHeadingRadians();
		lastState.myVelocity = bot.getVelocity();
		lastState.time = bot.getTime();
		long time = lastState.time;
		
		//Do the wave checks
		Iterator<Wave> it = waveLog.iterator();
		while(it.hasNext()) {
			Wave w = it.next();
			if(w.check(lastState.myLocation, lastState.time, sbs, flattener)) {
				it.remove();
			}
		}
		
		//TODO
		//calc.clear();
		
		double[][] danger = new double[][] {
			{ 1, 8, dangerCheck(direction, 8) },
			{ -1, 8, dangerCheck(-direction, 8) },
			{ 0, 0, dangerCheck(0, 0) },
		};
		
		int bestIndex = 0;
		for(int i=0; i<danger.length; ++i) {
			if(danger[i][2] < danger[bestIndex][2]) {
				bestIndex = i;
			}
		}
		
		if(danger[bestIndex][0] < 0) {
			direction = -direction;
		}
		
		Point2D.Double center = (Point2D.Double)lastState.enemyLocation;
		
		double best = 9000;
		//Calculate the best center
		for(Wave w : waveLog) {
			double d = (w.distance(lastState.myLocation) - w.distance(time)) / w.bulletSpeed;
			if(d < best) {
				best = d;
				center = w;
			}
		}
		
		double[] moveData = TestMove(lastState.myLocation, center, lastState.myHeading, lastState.myVelocity);
		
		bot.setTurnRightRadians(moveData[0]);
		
		if(Math.abs(bot.getTurnRemainingRadians()) < 0.1)
			firstTurn = true;
		
		bot.setMaxVelocity(Math.min(moveData[1], danger[bestIndex][1]));
		
		direction *= moveData[2];
		
		if(firstTurn) {
			bot.setAhead(1000*direction);
		} else {
			direction = 0;
		}
		
	}
	
	//TODO
	//LinkedList<Point2D> calc = new LinkedList<Point2D>(); 
	
	public double dangerCheck(int direction, double maxVelocity) {
		LinkedList<Wave> wLog = new LinkedList<Wave>();
		for(Wave w : waveLog) {
			Wave wave = w.clone();
			wave.resetMinMax();
			wLog.add(wave);
		}
		
		Point2D.Double current = new Point2D.Double(lastState.myLocation.getX(),lastState.myLocation.getY());
		
		double oldDistance = current.distance(lastState.enemyLocation);
		
		double velocity = lastState.myVelocity;
		double heading = lastState.myHeading;
		double danger = 0;
		
		long startTime = bot.getTime();
		long timeDelta = 0;
		
		Point2D.Double center = (Point2D.Double)lastState.enemyLocation;
		
		while(wLog.size() > 0 || timeDelta < 15) {
			Iterator<Wave> it = wLog.iterator();
			while(it.hasNext()) {
				Wave w = it.next();
				if(w.check(current, startTime + timeDelta, null, false)) {
					double minGF = w.min / w.escapeAngle;
					double maxGF = w.max / w.escapeAngle;
					
					if(minGF > maxGF) {
						double tmp = maxGF;
						maxGF = minGF;
						minGF = tmp;
					}
					
					double cDanger = 0;
					
					if(minGF <= 0 && maxGF >= 0) {
						cDanger += 1.0;
					}
					
					if(minGF <= w.linearGF && maxGF >= w.linearGF) {
						cDanger += 1.0;
					}
					
					if(minGF <= w.circularGF && maxGF >= w.circularGF) {
						cDanger += 1.0;
					}
					
					//determine the bins covered by the GF
					double bin[] = sbs.getCombinedScoreData(new StatData(w.data,0));
					double min = StatBuffer.GFToIndex(minGF, bin.length);
					double max = StatBuffer.GFToIndex(maxGF, bin.length);
					
					for (int i = (int) (min); i < bin.length && i <= (int) (max + 1); ++i) {
						if (i >= min && i <= max) {
							cDanger += bin[i];
						} else {
							cDanger += bin[i] * (1.0 - Math.min(Math.abs(i - min), Math.abs(i - max)));
						}
					}
					
					double power = (-(w.bulletSpeed - 20.0)) / 3.0;
					double tDist = Math.max((lastState.myLocation.distance(w) - w.distance(startTime))/ w.bulletSpeed, 1.0);
					double weight = power / (tDist*tDist);
					
					danger += cDanger * weight;
					
					it.remove();
				}
			}
			
			double best = 9000;
			for(Wave w2 : wLog) {
				double d = (w2.distance(lastState.myLocation) - w2.distance(startTime + timeDelta)) / w2.bulletSpeed;;
				if(d < best) {
					best = d;
					center = w2;
				}
			}
			
			double[] moveData = TestMove(current, center, heading, velocity);
			
			int moveDirection = Tools.signum(direction*moveData[2]);
			
			Simulate sim = new Simulate();
			sim.position = current;
			sim.velocity = velocity;
			sim.maxVelocity = Math.min(maxVelocity, moveData[1]);
			sim.direction = moveDirection;
			sim.heading = heading;
			sim.angleToTurn = moveData[0];
			sim.step();
			
			heading = sim.heading;
			velocity = sim.velocity;
			
			if(!battlefield.contains(current)) {
				danger += 0.01;
			}
			
			if(++timeDelta > 128) break;
		}
		
		double newDistance = current.distance(lastState.enemyLocation);
		if(newDistance < dangerDist && newDistance < oldDistance) {
			danger += 0.1;
		}
		
		danger += 0.00001 / newDistance; 
		
		return danger;
	}
	
	public double[] TestMove(Point2D myLocation, Point2D center, double heading, double velocity) {
		center = new Point2D.Double(
					Math.max(120, Math.min(bfwidth - 120, center.getX())),
					Math.max(120, Math.min(bfheight - 120, center.getY()))
				);
		
		double absBearing = Tools.absoluteBearing(center, myLocation);
		double lateralVelocity = velocity * Math.sin(heading - absBearing);
		int direction = Tools.sign(lateralVelocity);
		double moveAngle = absBearing + (Math.PI / 2.0) * direction;
		double distance = myLocation.distance(center); 
		/* Limit the max away angle to 20 degrees. */
		//double distModifier = -Math.min(Math.abs(bestDist - distance) / bestDist, Math.PI/9.0) * direction;
		double distModifier = ((distance - bestDist) / bestDist) * direction;
		
		if(Math.abs(velocity) < 1e-4 || Math.abs(distance - bestDist) < 50) distModifier = 0;
		
		moveAngle += distModifier;
		
		/* Wall smoothing */
		while(!battlefield.contains(Tools.project(myLocation, moveAngle, 160))) {
			moveAngle += 0.05*direction;
		}
		
		/* Determine the best direction */
		double turn  = Utils.normalRelativeAngle(moveAngle - heading);
		if(Math.abs(turn) > Math.PI / 2.0) {
			turn = Utils.normalRelativeAngle(turn + Math.PI);
			direction = -direction;
		}
		/* If the turn is to large, slow down a bit */
		double maxVelocity = Rules.MAX_VELOCITY;
		if(turn > Math.PI / 8.0)
			maxVelocity = 3.0;
		
		return new double[] {
			turn,
			maxVelocity,
			direction
		};
	}
	
	public void onStatus(StatusEvent e) {
		tracker.onStatus(e);
		
		if(noflat || bot.getRoundNum() == 0) return;
		double ratio = (double)shotsHit / (double)shotsFired;
		if(ratio > 0.11)
			flattener = true;
	}

	public void onBulletHit(BulletHitEvent e) {
		if(Seraphim.isReference) return;
		tracker.onBulletHit(e);
	}
	
	public void onHitByBullet(HitByBulletEvent e) {
		if(Seraphim.isReference) return;
		tracker.onHitByBullet(e);
		++shotsHit;
		
		handleBullet(e.getBullet(),false);
	}
	
	public void onBulletHitBullet(BulletHitBulletEvent e) {
		if(Seraphim.isReference) return;
		
		handleBullet(e.getHitBullet(),true);
	}
	
	static boolean noflat = false;
	static boolean flatCheck = false;
	
	long vChangeTime = 0;
	
	/**
	 * Handle an actual enemy bullet
	 */
	private void handleBullet(Bullet b, boolean collision) {
		Point2D.Double bulletPosition = new Point2D.Double(b.getX(),b.getY());
		
		long time = bot.getTime();

		/* Find the matching wave */
		Iterator<Wave> wi = waveLog.iterator();
		while(wi.hasNext()) {
			Wave wave = wi.next();

			double wavePower = Tools.bulletSpeedToPower(wave.bulletSpeed);
			
			/* check if the power is close enough to be our wave. This
			 * margin is small, only to allow room for rounding errors
			 */
			if(Math.abs(b.getPower()-wavePower) < 0.001) {
				double d = wave.distanceSq(bulletPosition);

				/* the current distance of the wave */
				boolean match = false;

				if(collision) {
					double rad1 = wave.bulletSpeed*((time-1) - wave.fireTime);
					double rad2 = wave.bulletSpeed*((time-2) - wave.fireTime);

					if(Math.abs(rad1*rad1-d) < 128) {
						match = true;
					} else if(Math.abs(rad2*rad2-d) < 128) {
						match = true;
					}

				} else {
					double rad0 = wave.bulletSpeed*(time - wave.fireTime);
					if(Math.abs(d-rad0*rad0) < 128) {
						match = true;
					}
				}

				if(match) {
					double gf = Utils.normalRelativeAngle(b.getHeadingRadians() - wave.baseAngle)
							/ wave.escapeAngle;
					sbs.update(new StatData(wave.data, gf), 1.0);

					wi.remove();

					return;
				}
			}
		}
	}
	
	public void onHitRobot(HitRobotEvent e) {
		tracker.onHitRobot(e);
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		if(Seraphim.isReference) return;
		
		tracker.onScannedRobot(e);
		
		if(!flatCheck) {
			if(e.getName().toLowerCase().contains("stelo") || e.getName().toLowerCase().contains("polishedruby")) {
				noflat = true;
			}
			if(e.getName().equals("stelo.Mirror")) {
				noflat = false;
			}
			flatCheck = true;
		}
		
		double bearing = e.getBearingRadians();
		
		State state = new State();
		state.time = e.getTime();
		
		state.myLocation = new Point2D.Double(bot.getX(),bot.getY());
		state.myHeading = bot.getHeadingRadians();
		state.myVelocity = bot.getVelocity();
		state.myLateralVelocity = state.myVelocity * Math.sin(bearing);
		double myAdvancingVelocity = state.myVelocity * Math.cos(bearing);
		double distance = e.getDistance();
		
		double eAbsoluteBearing = state.myHeading + e.getBearingRadians();
		
		state.direction = Tools.sign(state.myLateralVelocity);
		
		if(lastState != null) {
			if(Math.abs(state.myLateralVelocity) < 1e-4)
				state.direction = lastState.direction;
			
			if(Math.abs(lastState.myVelocity - state.myVelocity) > 0.5) {
				vChangeTime = state.time;
			}
		}
		
		state.enemyLocation = Tools.project(state.myLocation, state.myHeading + bearing, e.getDistance());
		
		double fWall = getWallDistance(state.enemyLocation, eAbsoluteBearing + Math.PI, distance, state.direction);
		
		state.waveData = new double[] {
			Math.abs(state.myLateralVelocity),
			myAdvancingVelocity,
			distance,
			fWall,
			(state.time - vChangeTime) / distance
		};
		
		log.addFirst(state);
		
		if(log.size() > 32)
			log.removeLast();
		
		if(log.size() > 3) {
			/* Determine energy drop delta */
			double enemyEnergyDelta = tracker.enemyEnergyDelta;
			if(enemyEnergyDelta > 0.09 && enemyEnergyDelta < 3.001) {
				/* Get our state from 2 turns ago. */
				State waveState = log.get(2);
				
				++shotsFired;
				//int direction = waveState.myLateralVelocity;
				
				Wave w = new Wave(
						lastState.enemyLocation,
						Tools.absoluteBearing(waveState.enemyLocation, waveState.myLocation),
						Rules.getBulletSpeed(enemyEnergyDelta),
						waveState.direction,
						state.time - 1
					);
				
				w.realWave = true;
				
				/** Anti-Linear */
				/* Calculate where I will be when the bullet intercepts me */
				Point2D antiPos = waveState.myLocation;
				long tTime = 0;
				while((++tTime)*w.bulletSpeed < antiPos.distance(w)) {
					//&& battlefield.contains(linPos)
					antiPos = Tools.project(antiPos, waveState.myHeading, waveState.myVelocity);
					if(!battlefield.contains(antiPos)) {
						antiPos = new Point2D.Double(
								Math.min(Math.max(18.0, antiPos.getX()), bot.getBattleFieldWidth() - 18.0),
								Math.min(Math.max(18.0, antiPos.getY()), bot.getBattleFieldHeight() - 18.0)
								); 
						break;
					}
				}
				
				/* Found the location, calculate the GF to it. */
				double angle = Tools.absoluteBearing(w, antiPos);
				angle = Utils.normalRelativeAngle(angle - w.baseAngle);
				w.linearGF = angle / w.escapeAngle;
				
				
				/** Anti-Circular */
				tTime = 0;
				antiPos = waveState.myLocation;
				double heading = waveState.myHeading;
				double circularHeadingChange = waveState.myHeading - log.get(3).myHeading;
				while((++tTime)*w.bulletSpeed < antiPos.distance(w)) {
					antiPos = Tools.project(antiPos, heading, waveState.myVelocity);
					heading += circularHeadingChange;
					
					if(!battlefield.contains(antiPos)) {
						antiPos = new Point2D.Double(
								Math.min(Math.max(18.0, antiPos.getX()), bot.getBattleFieldWidth() - 18.0),
								Math.min(Math.max(18.0, antiPos.getY()), bot.getBattleFieldHeight() - 18.0)
								); 
						break;
					}
				}
				angle = Tools.absoluteBearing(w, antiPos);
				angle = Utils.normalRelativeAngle(angle - w.baseAngle);
				w.circularGF = angle / w.escapeAngle;
				
				w.data = waveState.waveData;
				//w.bins = sbs.getCombinedScoreData(new StatData(w.data,0));
				
				//w.realWeight = 0.01;
				w.realWeight = 0.1;
				w.fakeWeight = 0.0;
				
				waveLog.add(w);
			}
		}
		
		lastState = state;
	}
	
	public void onRoundEnd() {
		//shotsFired
		if(shotsFired > 0) {
			double ratio = (double)shotsHit / (double)shotsFired * 100.0;
			System.out.printf("Enemy Hit Ratio: %06.2f%% (%04d/%04d)\n", ratio, shotsHit, shotsFired);
		}
	}
}
