package simonton.core;

import java.awt.*;

import robocode.*;

public interface Bot {

	public abstract void run();
	
	public abstract void onScannedRobot(ScannedRobotEvent e);
	
	public abstract void onBulletHit(BulletHitEvent e);
	
	public abstract void onBulletMissed(BulletMissedEvent e);
	
	public abstract void onHitByBullet(HitByBulletEvent e);
	
	public abstract void onHitRobot(HitRobotEvent e);
	
	public abstract void onHitWall(HitWallEvent e);

	public abstract void onBulletHitBullet(BulletHitBulletEvent e);
	
	public abstract void onDeath(DeathEvent e);

	public abstract void onWin(WinEvent e);

	public abstract void onPaint(Graphics2D g);

	public abstract double getGunCoolingRate();

	public abstract void setTurnRightRadians(double toTurn);
	
	public abstract void setTurnRight(double toTurn);

	public abstract void setTurnGunRightRadians(double toTurn);

	public abstract void setAhead(double toMove);
	
	public abstract void setBack(double toMove);

	public abstract double getDistanceRemaining();

	public abstract double getHeadingRadians();

	public abstract double getHeading();

	public abstract double getTurnRemainingRadians();

	public abstract double getVelocity();

	public abstract double getX();

	public abstract double getY();

	public abstract long getTime();

	public abstract double getGunHeadingRadians();

	public abstract double getGunTurnRemainingRadians();

	public abstract double getGunHeat();

	public abstract double getEnergy();

	public abstract int getNumRounds();

	public abstract int getRoundNum();
	
	public abstract Bullet setFireBullet(double power);
	
	public abstract String getName();
}