package PSW;
import robocode.*;
import java.awt.Color;

// API help : http://robocode.sourceforge.net/docs/robocode/robocode/Robot.html

/**
 * Relentless - a robot by Patrick White
 * No mercy - once it's locked on it's a battle to the death (or gone out of range). You an' me, hoss.
 * Keeps a "grudge list":
 *   - Being shot by a robot is worth grudge points equal to the power of the shot (unless the robot shooting is the current target)
 * When targeting:
 *   - If the grudge list is empty, locks onto the first robot it sees
 *   - Otherwise it locks onto the robot with the most grudge points
 * When locked on:
 *   - Drives towards the robot
 *   - Within a certain distance, starts firing with power proportional to the distance (shots fired from closer are more likely to hit)
 *   - Maintains distance when low on health.
 */
public class Relentless extends AdvancedRobot
{
	String targetName = null;
	int ticks = 0;
	/**
	 * run: Relentless's default behavior
	 */
	public void run() {
		//setColors(Color.white,Color.black,Color.black); // body,gun,radar

		// Robot main loop
		while(true) {
			// Replace the next 4 lines with any behavior you would like
			ticks++;
			scan();
			if(targetName == null || ticks > 5){
				setTurnLeft(45);//If there is no target or the target has disappeared, search around
				setAhead(-50);
				if(ticks < 15)targetName = null;//Assume it was terminated by someone else or has gone out of range
			}
			execute();
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		if(targetName == null)targetName = e.getName();//If it's a new robot, lock onto it
		//TODO: advanced target selection
		else if(!targetName.equals(e.getName()))return; //I have no quarrel with you (unless you're in the queue, in which case I'll deal with you later)
		//everything from this point occurs to the target robot only
		ticks = 0;//reset the ticks since the target was last
		double distance = e.getDistance();
		//if(distance < 200)setFire(distance * -0.0145 + 3.5);
		if(distance < 100)setFire(3);
		if(getEnergy() > 50 || distance > 75)setAhead(distance);
		if(getEnergy() < 50 && distance < 50)setAhead(-30);//stop ramming at low health - in early prototypes this was fine in 1v1 but left little health for multi-man melee
		setTurnLeft(0);
		setTurnRight(e.getBearing());
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		//GRUUUUDGE
	}
	public void onBulletHit(BulletHitEvent e) {
		if(e.getName().equals(targetName) && e.getEnergy() <= 0)targetName = null;//target eliminated...
	}
	/**
	 * onHitWall: What to do when you hit a wall
	 */
	public void onHitWall(HitWallEvent e) {
		setAhead(20);//this only happens when moving backwards and searching
	}	
}
