package theo.real.surf.predictor;

import robocode.*;
import robocode.util.Utils;
import java.util.*;
import java.awt.geom.*;
import java.util.*;
import theo.real.gun.*;
import theo.real.Ahab;
import theo.real.enemy.*;
import theo.real.wave.*;
import theo.real.utils.*;
import theo.real.surf.*;
import java.awt.Color;
import java.awt.Graphics2D;


public class RoboPredicter
{

	//To watch the velocity of a robot

	double totalDistance;
	double turnSegment;
	Point2D.Double nextPosition;
	double moveDistance;
	double heading;
	int veldir;
	
	List<Point2D.Double> positionList = new ArrayList<Point2D.Double>();
	
	

	public RoboPredicter(Object owner, double totalDistance, double heading, int veldir){
		this.totalDistance = totalDistance;
		this.heading = heading;
		this.veldir = veldir;
		this.positionList.clear();
		try{
			SurfHandler moments = (SurfHandler)owner;
			this.nextPosition = new Point2D.Double(moments.owner.pos.x,moments.owner.pos.y);
				developSurf(moments);
		}
		catch(Exception e){
			try{
				GunHandler moments = (GunHandler)owner;
				this.nextPosition = new Point2D.Double(moments.owner.pos.x,moments.owner.pos.y);
					developEnemy(moments);
			}
			catch(Exception ea){
				
			}
		}
	}
	
	protected void developSurf(SurfHandler moments){
		double realVelocity =  moments.owner.getVelocity();
		double distRemaining = this.totalDistance;
		Moments skidMap = new Moments(realVelocity,distRemaining,veldir);
		List<Double> surfDistances = skidMap.getResults();
		long ticks = 0;		
		nextPosition = moments.owner.pos;
		//double heading = moments.owner.heading;
	    for (Double surfVel : surfDistances){
			nextPosition = WaveUtils.project(nextPosition,surfVel*veldir/*(moments.currentWave.latDirection<0?-1:1)/*surfVel*moments.owner.latDirection*/,heading);
			positionList.add(nextPosition);
			/*for(Point2D.Double pt : positionList){
				System.out.println(pt.toString());
			}*/
			ticks ++;
			double distanceFromShot = nextPosition.distance(moments.currentWave.startPoint);
			distanceFromShot -= moments.currentWave.distTraveled -
									(moments.currentWave.velocity * ticks);
			if(distanceFromShot-moments.currentWave.velocity<18 || surfVel <= 0){
				break;
			}
		}
		
		//for(Point2D.Double pos: positionList){
		//	ticks ++;
			
			
	//	}
	}
	
	protected void developEnemy(GunHandler moments){
		
	}
	
	public List<Point2D.Double> getPosList(){
		return this.positionList;
	}

}

