package jok;

/**
 * MyClass - a class by (your name here)
 */
public class BotMath
{
	//returns the distance between two x,y coordinates
	public static double getRange( double x1,double y1, double x2,double y2 )
	{
		double xo = x2-x1;
		double yo = y2-y1;
		double h = Math.sqrt( xo*xo + yo*yo );
		return h;
	}
	
	//gets the absolute bearing between to x,y coordinates
	public static double absbearing( double x1,double y1, double x2,double y2 )
	{
		double xo = x2-x1;
		double yo = y2-y1;
		double h = getRange( x1,y1, x2,y2 );
		if( xo > 0 && yo > 0 )
		{
			return Math.toDegrees(Math.asin( xo / h ));
		}
		if( xo > 0 && yo < 0 )
		{
			return Math.toDegrees(Math.PI - Math.asin( xo / h ));
		}
		if( xo < 0 && yo < 0 )
		{
			return Math.toDegrees(Math.PI + Math.asin( -xo / h ));
		}
		if( xo < 0 && yo > 0 )
		{
			return Math.toDegrees(2.0*Math.PI - Math.asin( -xo / h ));
		}
		return 0;
	}
	
	public static int sign(double angle)
	{
		angle = normaliseHeading(angle);
		if(angle <= 180) return 1;
		else return -1;
	}
	
	public static double normaliseBearing(double angle)
	{
		double trimmedAngle = (angle % 360);
		if(trimmedAngle > 180) return (trimmedAngle%180) - 180;
		else if(trimmedAngle < -180) return (trimmedAngle%180) + 180;
		else return trimmedAngle;
	}
	
	public static double normaliseHeading(double angle)
	{
		if(angle < 0) return (angle%360) + 360;
		else return (angle%360);
	}
}
