package nat.nano;

import robocode.AdvancedRobot;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

/**
 * Ocnirp - a robot by Nat Pavasant
 * 
 * "Battle for the one-on-one nano-bot crown!"
 * 
 * @version 1.73
 * @author Nat Pavasant
 */
@SuppressWarnings("unused")
public final class Ocnirp extends AdvancedRobot {
	/**
	 * Size of pattern to match. 45 is the maximum value or robot will skip a
	 * turn in unacceptable rate. 30 is a standard value.
	 * 
	 * ^ With old subtract-by-1 method, new one with divide-by-2 has no bound in 35 rounds game.
	 */
	private static final int PATTERN_DEPTH = 198;
	
	/**
	 * If Math.random() exceed this number, the robot will change the direction.
	 */
	private static final double CHANGE_INTERVAL = 0.92;
	
	/**
	 * Preferred distance between this robot and enemy.
	 */
	private static final double PREFERRED_DISTANCE = 180d;
	
	/**
	 * Fire power, it used to be 2.5, but my crazy part of my brain told me to
	 * reduce this a bit.
	 */
	private static final double FIRE_POWER = 2.4433565d;
	
	/**
	 * Bullet velocity. It should be {@code 20 - 3 * FIRE_POWER}, but my crazy
	 * part of my brain told me to leave this 12.5
	 */
	private static final double BULLET_VELOCITY = 12.5d;
	
	/**
	 * Distance offset to turn
	 */
	private static final double DISTANCE_OFFSET = 0.38435d;
	
	/**
	 * Distance offset to turn
	 */
	private static final double DISTANCE_CONTROLLER = 237.5;
	
	/**
	 * Velocity trick multiplier, make this higher will make more change that
	 * robot will move at max velocity
	 */
	private static final double VELOCITY_MULTIPILER = 17.78456345d;
	
	/**
	 * Minimum velocity for the velocity trick
	 */
	private static final double VELOCITY_MINIMUM = 2d;
	
	/**
	 * Factor to scale the pattern data.
	 */
	private static final double PATTERN_SCALE = 2d;
	
	/**
	 * A static variable to keep which direction it is moving.
	 */
	private static int dir = 100;
	
	/**
	 * Main robot method. For nanobot, this contains only radar control.
	 */
	public void run() {
		// 5 bytes
		setAdjustGunForRobotTurn(true);
		
		// 5 bytes
		// setAdjustRadarForGunTurn(true);
		
		// 7 bytes
		turnRadarRightRadians(Double.POSITIVE_INFINITY);
	}
	
	/**
	 * What to do when you see another robot.
	 * 
	 * Main robot operation method for almost all nano/micro/mini robots.
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		/*
		 * Variable order here is important. We can save ~3-4 bytes here. since
		 * all math operation must be done on registers. Java virtual machine
		 * has 4 register slot. First register will be taken by {@code this}
		 * object. Then each parameters will take the rest of registers. If
		 * there are any registers left, the variables defined in the method is
		 * filled the register until it full. Every type will take 1 registers
		 * except double, which take 2. If double is the fourth variable
		 * defined, it will overflow to the extra fifth register.
		 * 
		 * So, the most
		 * used variable should define first, which will be enemy absolute
		 * bearing in most cases. In this case, we define most used int before
		 * and make double overflow its register.
		 */
		// 8-byte pattern protector
		int matchLen = Math.min(PATTERN_DEPTH, (int)getTime());	// PM Stuff
//		int matchLen = PATTERN_DEPTH;	// PM Stuff
		double angle;					// enemy absolute bearing
		double dist;					// enemy distance
		int matchPos;					// PM Stuff
		
// ///////////////////////////////////////////////////////////////////////////////
// Radar
//
// Do infinity lock (8 bytes)
		setTurnRadarLeftRadians(getRadarTurnRemaining());
// ///////////////////////////////////////////////////////////////////////////////

// ///////////////////////////////////////////////////////////////////////////////
// Movement (Perpendicular and Random with distance control)
//
// Turn perpendicular to an enemy, and add/deduct the angle a bit to
// control the distance
//
//		setTurnRightRadians(
//				Math.cos(angle = e.getBearingRadians())
//				- Math.signum(
//						getVelocity() * ((dist = e.getDistance()) - PREFERRED_DISTANCE)
//				) * DISTANCE_OFFSET);
//		setTurnRightRadians(Math.cos(
//						(angle = e.getBearingRadians())
//						- ((dist = e.getDistance()) - PREFERRED_DISTANCE)
//						* getVelocity() / DISTANCE_CONTROLLER
//		));
//
// No distance controller (15 bytes)
//
		setTurnRightRadians(Math.cos(angle = e.getBearingRadians()));
//
// Move ahead (8 bytes)
//
		setAhead(dir);
//
// If random() exceed the change interval (10 bytes)
//
		if (Math.random() > CHANGE_INTERVAL) {
//
// Reverse direction (11 bytes)
// Optimize to save 2 bytes
//
//			dir = -dir; // cost 2 more bytes
			onHitWall(null);
//			
// Velocity trick (15 bytes)
//
//			setMaxVelocity(Math.random() * VELOCITY_MULTIPILER + VELOCITY_MINIMUM);
//
		}
//
// ///////////////////////////////////////////////////////////////////////////////

// ///////////////////////////////////////////////////////////////////////////////
// Eric Simonton's Lateral Velocity Pattern Matching Gun
//
// Define counter
//
		int i;
//
// Append enemy log (42 bytes)
//
		enemyHistory = String.valueOf(
				(char)  Math.round( PATTERN_SCALE * (e.getVelocity() * Math.sin(e
						.getHeadingRadians()
						- (angle += getHeadingRadians()))))).concat(
				enemyHistory);
//
// Match the history (32 bytes)
//
		while ((matchPos = enemyHistory.indexOf(enemyHistory.substring(0,
				matchLen *= (2d/3d)), i = (int) (((dist = e.getDistance()) / 12.5) - 1))) < 0)
			;
//
// Get the firing angle (34 bytes)
//
		do
			angle +=
				Math.asin
				((short) enemyHistory.charAt(--matchPos) / dist
				  / PATTERN_SCALE );
		while (--i > 0);
//
// Turn the gun (13 bytes)
//
		setTurnGunRightRadians(Utils.normalRelativeAngle(angle
				- getGunHeadingRadians()));
//
// Fire (7 bytes)
//
		setFire(FIRE_POWER);
//
// Anti-rammer firing (16 bytes)
//
//		setFire(FIRE_POWER + ((dist > 100) ? 0 : 1));
//
// ///////////////////////////////////////////////////////////////////////////////
	}
	
	/**
	 * When hit wall, reverse direction
	 */
	public void onHitWall(HitWallEvent e) {
		dir = -dir;
	}
	
	/**
	 * Enemy history string. Preloaded to prevent StringIndexOutOfBoundException.
	 */
	private static String enemyHistory = "" + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 1 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 2 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) -1 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
	+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) -2 + (char) -4
	+ (char) -6 + (char) -8 + (char) -8 + (char) -8 + (char) -8
	+ (char) -8 + (char) -8 + (char) -8 + (char) -8 + (char) -8
	+ (char) -8 + (char) -8 + (char) -8 + (char) -8 + (char) -8
	+ (char) -8 + (char) -8 + (char) -8 + (char) -8 + (char) -8
	+ (char) -8 + (char) -8 + (char) -8 + (char) -8 + (char) -8
	+ (char) -8 + (char) -8 + (char) -8 + (char) -8 + (char) -8
	+ (char) -8 + (char) -8 + (char) -8 + (char) -8 + (char) -8
	+ (char) -8 + (char) -8 + (char) -8 + (char) -8 + (char) -8
	+ (char) -8 + (char) -7 + (char) -6 + (char) -5 + (char) -4
	+ (char) -3 + (char) -2 + (char) -1 + (char) 0 + (char) 2
	+ (char) 4 + (char) 6 + (char) 8 + (char) 8 + (char) 8 + (char) 8
	+ (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8
	+ (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8
	+ (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8
	+ (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8
	+ (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8
	+ (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8
	+ (char) 8 + (char) 7 + (char) 6 + (char) 5 + (char) 4 + (char) 3
	+ (char) 2 + (char) 1 + (char) 0;
}
