package nat.ether.stats;

import nat.ether.utils.Range;

// CREDIT: Rednaxela
public final class BinUtils {
	private BinUtils() {
	}

	public static float indexToGF(int bins, double index) {
		return (float) ((index / (bins - 1)) * 2 - 1);
	}

	public static float gfToIndex(int bins, double gf) {
		return (float) (Math.min(1, Math.max(0, (gf + 1) / 2)) * (bins - 1));
	}

	public static float[] makeSmoothedBins(int bins, Range range) {
		final float[] d = new float[bins];
		makeSmoothedBins(d, range, 1.0f);
		return d;
	}

	public static void makeSmoothedBins(float[] bins, Range range, float weight) {
		final Range indexRange = new Range(gfToIndex(bins.length, range.lower), gfToIndex(bins.length, range.upper));
		final float center = (float) indexRange.getMean();
		for (int i = 0; i < bins.length; i++) {
			bins[i] += weight / Math.pow(indexRange.distanceOutside(i) * 1.3 + 0.2 * Math.abs(i - center) + 1, 1.5);
		}
	}

	public static float[] makeFullSBins(int bins, Range range) {
		final float[] d = new float[bins];
		makeFullSBins(d, range, 1.0f);
		return d;
	}

	public static void makeFullSBins(float[] bins, Range range, float weight) {
		final int centerIndex = (int) Math.round(gfToIndex(bins.length, range.lower));
		for (int i = 0; i < bins.length; i++) {
			bins[i] += weight / Math.pow(1.5 * Math.abs(i - centerIndex) + 1, 1.5);
		}
	}

	public static float[] makeRectBins(int bins, Range range) {
		final float[] d = new float[bins];
		makeRectBins(d, range, 1.0f);
		return d;
	}

	public static void makeRectBins(float[] bins, Range range, float weight) {
		final float lower = gfToIndex(bins.length, range.lower);
		final float upper = gfToIndex(bins.length, range.upper);
		final int minindex = (int) Math.floor(lower);
		final int maxindex = (int) Math.ceil(upper);
		for (int i = minindex; i <= maxindex; i++) {
			if (i > minindex && i < maxindex)
				bins[i] += 1.0 * weight;
			else
				bins[i] += (1 - Math.max(0, (lower - i)) - Math.max(0, (i - upper))) * weight;
		}
	}

	public static float getTotal(float[] bins) {
		float total = 0;
		for (int i = 0; i < bins.length; i++) {
			total += bins[i];
		}
		return total;
	}

	public static float getTotalInRect(float[] bins, Range range) {
		float total = 0;
		final float lower = gfToIndex(bins.length, range.lower);
		final float upper = gfToIndex(bins.length, range.upper);
		final int minindex = (int) Math.floor(lower);
		final int maxindex = (int) Math.ceil(upper);
		for (int i = minindex; i <= maxindex; i++) {
			if (i > minindex && i < maxindex)
				total += bins[i];
			else
				total += bins[i] * (1 - Math.max(0, (lower - i)) - Math.max(0, (i - upper)));
		}
		return total;
	}

	public static float getPeakInRange(float[] bins, Range range) {
		final float lower = gfToIndex(bins.length, range.lower);
		final float upper = gfToIndex(bins.length, range.upper);
		final int minindex = Math.max(0, (int) Math.ceil(lower));
		final int maxindex = Math.min(bins.length - 1, (int) Math.floor(upper));
		int max = minindex;
		for (int i = minindex + 1; i <= maxindex; i++) {
			if (bins[i] > bins[max])
				max = i;
		}
		return bins[max];
	}

	public static float getPeakOutsideRange(float[] bins, Range range) {
		final float lower = gfToIndex(bins.length, range.lower);
		final float upper = gfToIndex(bins.length, range.upper);
		final int minindex = Math.max(0, (int) Math.floor(lower));
		final int maxindex = Math.min(bins.length - 1, (int) Math.ceil(upper));
		int max = 0;
		for (int i = 0; i < bins.length; i++) {
			if (i == minindex + 1)
				i = maxindex;
			if (bins[i] > bins[max])
				max = i;
		}
		return bins[max];
	}

	public static float getMinOutsideRange(float[] bins, Range range) {
		final float lower = gfToIndex(bins.length, range.lower);
		final float upper = gfToIndex(bins.length, range.upper);
		final int minindex = Math.max(0, (int) Math.floor(lower));
		final int maxindex = Math.min(bins.length - 1, (int) Math.ceil(upper));
		int min = 0;
		for (int i = 0; i < bins.length; i++) {
			if (i == minindex + 1)
				i = maxindex;
			if (bins[i] < bins[min])
				min = i;
		}
		return bins[min];
	}
}
