package bvh.hdr;

import java.util.*;
import java.util.Random;
import java.util.ArrayList;
import java.util.List;
import java.awt.geom.*;
import java.awt.Color;
import robocode.*;
import robocode.util.Utils;
import bvh.hdr.RoboUtils;


/**
 * <h2>Hodur</h2> <h3>- a (mini) robot</h3>
 * 
 * <quote>"Hodur or Hod was a son of Odin. He was the blind god of winter, who
 *   was tricked by Loki into killing Balder. Balder's death was avenged
 *   by Vali who killed Hodur.</quote>
 * 
 * <p>this bot is just a joke-project...it's realy blind and depends on its
 * information by beeing hit...</p>
 * 
 * <p>Wijzigingshistorie v0.53 (20-06-2005):</p>
 * <ul>
 *  <li>moet gelijk zijn aan 0.50_sterk!</li>
 * </ul>
 * 
 * <p>Wijzigingshistorie v0.4 (20-06-2005):</p>
 * <ul>
 *  <li>beweging in korte cirkel rond doel, na verloop van tijd (geen hits) rond centrum
 *    met straal 2/3 zodat alle wand kruipertjes worden vermeden.</li>
 *  <li>schieten in richting tegenstander met huidige lineaire voorspelling, anders richting 
 *    centrum van de bewegingscirkel.</li>
 *  <li>indien doel lang niet "gescanned"/bijgewerkt, dan schieten met lichte kogels om doel
 *    te zoeken.</li>
 *  <li>reorganisatie van de code.</li>
 * </ul>
 * 
 * <p>Wijzigingshistorie v0.3 (14-01-2004):</p>
 * <ul>
 *  <li> ?
 * </ul>
 * 
 * <p>Wijzigingshistorie v0.2 (14-01-2004):</p>
 * <ul>
 *  <li>alle bekende events toegevoegd die info over de tegenstander geven:
 *    * onHitByBullet
 *    * onBulletHit
 *    * onHitRobot
 *   </li>
 * </ul>
 * <p>Wijzigingshistorie v0.1 (12-01-2004):</p>
 * <ul>
 *  <li>gebaseerd op mini.Fenrir v0.21</li>
 *  <li>alle info komt van de onHitByBullet, dit i.t.t. de gebuikelijke onScannedRobot ;-)</li>
 * </ul>
 * 
 * @date 20-jun-2005
 * @version 0.4
 * @author Bart "Loki" van Hest
 */

public class Hodur extends AdvancedRobot implements Droid, Constanten {

// Definitie van variabelen
   private int                 cirkelDir = 1;
   public  Point2D.Double      huidigePositie = new Point2D.Double(0,0);
   public  Point2D.Double      middelpunt = new Point2D.Double(400,300);

// variabelen die huidig doel of directe bedreiging bevatten:
   private Doel                doel   = new Doel();

/**
* run: Hodur's hoofdroutine:
*/
   public void run() {
      // initieer tank kleuren:
      setColors(Color.white, Color.white, Color.white);

      // initialisatie tank:
      setAdjustGunForRobotTurn(true);
      setAdjustRadarForGunTurn(true);

      // bepaal middelpunt slagveld:
      middelpunt.setLocation(getBattleFieldWidth()/2D, getBattleFieldHeight()/2D);

      // levensloop:
      while(true) {
         if (!doel.isInfoActueel(getTime())) {
            doel.setPositie(middelpunt);
            doel.setAfstand(0.9*middelpunt.getY());
         }
         navigatie();   // verplaats robot:
         stuurKannon(); // stuur kanon aan:
         execute();
      } // einde levensloop
   } // einde run-method

/**
* onHitByBullet: acties n.a.v. een treffer door de tegenstander:
*/
   public void onHitByBullet(HitByBulletEvent evt)
   {
      doel.setInfo(evt, this);  // leg informatie over doel vast:
   }

/**
* onBulletHit: acties n.a.v. een treffer op de tegenstander:
* <ul>
*  <li>locatie tegenstander bepalen en vastleggen.</li>
*  <li>kanon richten?</li>
*  </ul>
*/
   public void onBulletHit(BulletHitEvent evt)
   {
      doel.setInfo(evt, this);  // leg informatie over doel vast:
   }

/**
* onHitRobot: acties n.a.v. een botsing met de tegenstander:
*  - locatie tegenstander bepalen en vastleggen.
*  - kanon richten?
*/
    public void onHitRobot(HitRobotEvent evt)
    {
      doel.setInfo(evt, this);  // leg informatie over doel vast:
    }

/**
* onWin: Niet stil blijven zitten om laatste op mij afgevuurde kogels te ontwijken.
* (zie UltimateDeathToNanoBots)
*/
   public void onWin(WinEvent e) 
   {
      stop();
   }

/**
* onRobotDeath: indien doel vernietigd dan dit 'vrijgeven'.
*/
   public void onRobotDeath(RobotDeathEvent evt) 
   {
      // en stop beweging om rondvliegende kogels te ontwijken..
      stop();
   }

   public void onHitWall(HitWallEvent event) {
     cirkelDir *= -1;
   }

/**
* navigatie(): Beweging o.b.v. potentiaalveld waarbij minder gunstige
* posities een hogere potentiaal krijgen en bot richting laagste potentiaal
* beweegd.
*/
   private void navigatie() {
      double straal, richting;
      Point2D.Double bestemming = null;
      int poging = 0;

      huidigePositie.setLocation(getX(), getY()); // werken met oude, huidige en nieuwe positie !!!

      if ( Math.abs(getDistanceRemaining()) < 18  ) {

// bestemming kiezen door om doel heen te draaien. Indien de nieuwe positie niet
// binnen het slagveld valt, dan afstand/draaihoek aanpassen tot dit wel het geval is.
      straal   = STANDAARDSTRAAL-doel.positie.distance(huidigePositie)/STANDAARDSTRAAL;
      richting = RoboUtils.bepaalRichting(huidigePositie, doel.positie) + KWARTPI*cirkelDir;
         
      do {
         bestemming = RoboUtils.projecteerPositie(doel.positie
                                                 ,richting
                                                 ,straal
                                                 );
         // straal en richting bijwerken omdat anders de wand wordt geraakt.
         straal   = straal/(poging+1);
         richting = richting + poging*EENZESTIENDEPI;

      } while (poging++ < 100 && !RoboUtils.slagveld(getBattleFieldWidth(), getBattleFieldHeight()).contains(bestemming));

if (poging>310){
System.out.println("navigatie(): === huidigePositie="+huidigePositie + " ===");
System.out.println("navigatie(): geen bestemming gevonden binnen 32 pogingen; bestemming="+bestemming);
System.out.println("navigatie():   richting(graden)="+Math.toDegrees(richting)+", straal="+straal);
}

// controleer of draaihoek gelijk is aan minimale draaihoek:
      double hoek = Utils.normalRelativeAngle(RoboUtils.bepaalRichting(bestemming, huidigePositie) - getHeadingRadians());
      double draaiHoek = Math.atan(Math.tan(hoek));

// draai en verplaats robot:
      setTurnRightRadians(draaiHoek);
      setAhead(huidigePositie.distance(bestemming) * (hoek == draaiHoek ? 1 : -1));

      }
// eventueel snelheid minderen om sneller te kunnen draaien:
      if ( Math.abs(getTurnRemainingRadians()) > KWARTPI )
         setMaxVelocity( (90D-Math.abs(getTurnRemaining()))/7.5D );
      else
         setMaxVelocity(MAXIMUM_SNELHEID);

//         oudePositie.setLocation(huidigePositie.x, huidigePositie.y);
   }

/**
* Vuurkracht konstant (onafhankelijk van de doelafstand en de (voorspelde) hoek tussen kanon en doel)
*
* v0.2 (28-08-2002)
*/
   private void stuurKannon() {
         double kanonVuurrichting;

         // vuurkracht afhankelijk van laatste scan van tegenstander om eigen energie te conserveren
         long   nu = getTime();
         long   deltaT = nu - doel.scanTijd;
         double kanonVuurkracht = 3D-deltaT/31D;
         
        if (deltaT < KORTEPROBEERTIJD) {
            kanonVuurkracht   = 3D;
            kanonVuurrichting = doel.richting;
//System.out.println("stuurKannon():    deltaT < KORTEPROBEERTIJD: kanonVuurrichting ="+kanonVuurrichting);
        }
        else if (doel.isInfoActueel(nu) ) {
            kanonVuurrichting = doel.lineaireBewegingsSchatter(huidigePositie.getX()
                                                              ,huidigePositie.getY()
                                                              ,nu
                                                              ,(20D - 3D * kanonVuurkracht)
                                                              );
//System.out.println("stuurKannon():           doel.isInfoActueel: kanonVuurrichting ="+kanonVuurrichting);
        }
        else {
           kanonVuurrichting = RoboUtils.bepaalRichting(middelpunt, huidigePositie);
//System.out.println("stuurKannon(): else (dt > LANGEPROBEERTIJD): kanonVuurrichting ="+kanonVuurrichting);
        }
        
// en tenslotte kanon op voorspelde positie van het doel richten:
         setTurnGunRightRadians( Utils.normalRelativeAngle( kanonVuurrichting
                                                          - getGunHeadingRadians()
                                                          )
                               );

         if (getEnergy()                  > kanonVuurkracht
          && getGunTurnRemainingRadians() < Math.atan2(18D,doel.afstand)
            )   setFire( kanonVuurkracht );

   } // einde method stuurKannon()
} // EINDE CLASS Hodur
