/*
 * Copyright (c) 2004 Marcin Fuszara
 */  
package fushi.PvP1;
import robocode.*;

/* this class manages all targeting strategies that a robot
 * can use and switches them if needed;
 */
public class TargetingManager
{
   
   // robot for which this manager is used
   AdvancedRobot robot;
   // robot's gun
   Gun gun;
   // enemy in one-on-one battle
   Enemy enemy;
   
   // targeting used for the robot
   Targeting targeting;

   /* at construction provide robot, its body
    * and enemy in one-on-one battle
    */
   public TargetingManager( AdvancedRobot robot, Gun gun, Enemy enemy )
   {
      this.robot = robot;
      this.gun = gun;
      this.enemy = enemy;
      initialize();
   }
   
   /* manages the strategies and runs an active strategy
    */   
   public void run()
   {
      // change targeting strategy if needed
      switchStrategy();
      // prepare orders
      targeting.run();
   }

   /* prepare movement strategies
    */
   void initialize()
   {
      // create targeting logic
      targeting = new PatternMatchingTargeting( robot, gun, enemy );
   }
   
   /* takes care to change targeting strategy
    */
   void switchStrategy()
   {
      //TODO
   }
   
   /*
    * event handlers redirecting events to active targeting strategy
    */
    
   public void onBulletHit( BulletHitEvent e )
   {
      targeting.onBulletHit( e );
   }
   
   public void onBulletHitBullet( BulletHitBulletEvent e )
   {
      targeting.onBulletHitBullet( e );
   }
   
   public void onBulletMissed( BulletMissedEvent e )
   {
      targeting.onBulletMissed( e );
   }
   
}