package EE;

import robocode.*;
//import java.text.NumberFormat;

public class Enemy {

	private double bearing;
	private double distance;
	private double energy;
	private double heading;
	private String name;
	private double velocity;
	private double prevX, prevY, prevV, prevR, thisX, thisY, thisV, thisR; 
	
	// constructor
	public Enemy() {
		reset();
	}

	public void reset() {
		bearing = 0.0;
		distance = 0.0;
		energy = 0.0;
		heading = 0.0;
		name = "";
		velocity = 0.0;
		x = 0.0;
		y = 0.0;
	}

	public void reset_koord(){
		prevX = 0.0;
		prevY = 0.0;
		thisX = 0.0;
		thisY = 0.0;
		prevV = 0.0;
		prevR = 0.0;
		thisV = 0.0;
		thisR = 0.0;
	}

	public void write_koord(){
		prevX = thisX;		
		prevY = thisY;
		prevV = thisV;		
		prevR = thisR;
		thisX = x;			
		thisY = y;
		thisV = velocity;	
		thisR = heading;
	}

	public void update(ScannedRobotEvent e, Robot robot) {
		bearing = e.getBearing();
		distance = e.getDistance();
		energy = e.getEnergy();
		heading = e.getHeading();
		name = e.getName();
		velocity = e.getVelocity();
		double absBearingDeg = (robot.getHeading() + e.getBearing());
		if (absBearingDeg < 0) absBearingDeg += 360;

		// yes, you use the _sine_ to get the X value because 0 deg is North
		x = robot.getX() + Math.sin(Math.toRadians(absBearingDeg)) * e.getDistance();

		// likewise, you use the _cosine_ to get the Y value for the same reason
		y = robot.getY() + Math.cos(Math.toRadians(absBearingDeg)) * e.getDistance();
	}

	public double getX() { return x; }
	public double getY() { return y; }
	public boolean none() { return name.equals(""); }
	public double getBearing()  { return bearing; }
	public double getDistance() { return distance; }
	public double getEnergy()   { return energy; }
	public double getHeading()  { return heading; }
	public String getName()     { return name; }
	public double getVelocity() { return velocity; }
	public double getPrevX() 	{ return prevX; }
	public double getPrevY() 	{ return prevY; }
	public double getPrevV() 	{ return prevV; }
	public double getPrevR() 	{ return prevR; }

	public double getFutureX(long when) {
		return x + Math.sin(Math.toRadians(getHeading())) * getVelocity() * when;
	}

	public double getFutureY(long when) {
		return y + Math.cos(Math.toRadians(getHeading())) * getVelocity() * when;
	}

	private double x;
	private double y;
}

