package davidalves.net;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.*;
import robocode.util.Utils;
public class DuelistMicroMkII extends AdvancedRobot {
	static final int MAX_WAVE_TABLE_SIZE = 1000;
	static final double MAX_MATCH_ERROR = 50.0;
	static List waves = new Vector();
	static long lastMoveTime;
	static double targetDirection;
	static double timer;
	static double targetX, targetY;
	static double bulletPower;
	public void run() {
		//Duelist colors
		setColors(Color.darkGray, Color.darkGray, Color.cyan);
		
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);
		
		//out.println("wave count: " + waves.size());
		do {
			turnRadarRightRadians(targetDirection = timer = lastMoveTime = 1);
		} while (true);
	}
	public void onScannedRobot(ScannedRobotEvent e) {
		double distance, absoluteBearing, bestX, bestY, destinationX, destinationY;
		double myX, myY, error, attackAngle, gunOffset = 0, bestError = MAX_MATCH_ERROR, bestAttackAngle = Double.NEGATIVE_INFINITY;
		//Not very clean, but this is the most efficient way I've found to set
		// x, y, distance, and bearing
		targetX = (bestX = myX = getX())
				+ Math.sin(absoluteBearing = e.getBearingRadians()
						+ getHeadingRadians()) * (distance = e.getDistance());
		targetY = (bestY = myY = getY()) + Math.cos(absoluteBearing)
				* (distance);
		//Track which direction the target is moving (Clockwise vs.
		// Counter-clockwise) and how long they have been moving
		if (e.getVelocity() == 0.0) {
			lastMoveTime = getTime();
		} else {
			targetDirection = (targetDirection = e.getVelocity()
					* Math.sin(e.getHeadingRadians() - absoluteBearing)) / Math.abs(targetDirection);
		}
		//Spin Radar
		setTurnRadarRightRadians(Math.sin(absoluteBearing
				- getRadarHeadingRadians()));
		//Update wave table
		Iterator i = waves.iterator();
		while (i.hasNext()) {
			MicroWave mw;
			if ((error = Math.abs(distance - (mw = (MicroWave) i.next()).distanceAtFireTime) / 20.0 //Distance error
					//+ Math.abs(mw.bulletSpeed - (20 - 3 * bulletPower)) //bullet power error
					+ 1.0 / e.getEnergy() //Infinite error for disabled opponents so we fire head-on
					+ Math.abs(getTime() - lastMoveTime - mw.enemyMoveTime)) //Last move time error
					< bestError) {
				bestError = error;
				gunOffset = mw.solutionAngle * targetDirection;
			}
		}
		//out.println("Match error: " + bestError + " offset: " + gunOffset);
		
		setTurnGunRightRadians(Utils.normalRelativeAngle(absoluteBearing
				+ (gunOffset * (bulletPower + 3) / 6.0) - getGunHeadingRadians()));
		
		//Fire bullet + wave
		if(getEnergy()+1 > Math.min(e.getEnergy(),5)) //Survival
		if(setFireBullet(bulletPower = Math.min(3,getEnergy() / 10))!= null && bulletPower >= 3.0){
			MicroWave mw;
			(mw = new MicroWave()).distanceAtFireTime = distance;
			mw.initialAngle = absoluteBearing;
			mw.x = myX;
			mw.y = myY;
			mw.enemyMoveTime = getTime() - lastMoveTime;
			mw.targetDirection = targetDirection;
			addCustomEvent(mw);
		}
		
		/* *********************** Drive Tank ********************** */
		if (timer-- < 0) {
			do {
				// Pick a new random destination
				//Much smaller than the old method, though it requires more
				// iterations to get a good destination
				//Thanks to DrLoco for the suggestion.
				destinationX = 50.0 + Math.random()
						* (getBattleFieldWidth() - 100.0);
				destinationY = 50.0 + Math.random()
						* (getBattleFieldHeight() - 100.0);
				/*
				 * Check if driving to the new random destination will make us
				 * drive closer to perpendicular than the current best destination.
				 * If so, change the best destination to the current one.
				 */
				if ((attackAngle = Math.abs((Math.tan(Math.atan2(
						destinationX - myX, destinationY - myY)
						- absoluteBearing)))) > bestAttackAngle) {
					bestX = destinationX;
					bestY = destinationY;
					bestAttackAngle = attackAngle;
				}
			} while (bestAttackAngle < 1.45);
			
			
			//destinationY now represents the angle to turn to. Re-using
			// variables saves space! :-)
			//destinationX now represents the angle to turn to, normalized to
			// between -90 and 90 degrees
			setTurnRightRadians(destinationX = Math.atan(Math
					.tan(destinationY = Utils.normalRelativeAngle(Math.atan2(
							bestX - myX, bestY - myY)
							- getHeadingRadians()))));
			setAhead((destinationX == destinationY ? 1.0 : -1.0)
					* (Point2D.distance(myX, myY, bestX, bestY)));
			//Set the movement timer to a random number between 0 and the time
			// a medium power bullet would take to reach us.
			timer = Math.random() * distance / 13; 
		}
		execute();
	}
	class MicroWave extends Condition {
		public long enemyMoveTime;
		//public double bulletSpeed;
		public double distanceAtFireTime = 0;
		public double targetDirection;
		public double x, y, distanceTraveled, solutionAngle = 0, initialAngle;
		public boolean test() {
			if ((distanceTraveled += 11) > Point2D.Double.distance(x, y,
					targetX, targetY)) {
				solutionAngle = this.targetDirection
						* Utils.normalRelativeAngle(Math.atan2(targetX - x,
								targetY - y)
								- initialAngle);
				//out.println("Wave hit at time " + getTime() + "
				// solutionAngle is " + solutionAngle);
				
				// Limit the size of the wave table so we don't annoy PEZ and/or skip turns
				if(waves.size() < MAX_WAVE_TABLE_SIZE)waves.add(this);
				removeCustomEvent(this);
			}
			return false;
		}
	}
}