/*
 * Decompiled with CFR 0.152.
 */
package acid;

import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Bl4ck
extends AdvancedRobot {
    double prevX = 0.0;
    double prevY = 0.0;
    double prevAimX = 0.0;
    double prevAimY = 0.0;
    double speed = 100.0;
    boolean lockedRev = false;
    boolean overRide = true;
    boolean lockDown = true;
    double energy = 0.0;
    double bulletPower = 1.0;
    int bulletsHit = 1;
    int bulletsMissed = 1;
    double bestX;
    double bestY;
    int startRound;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setBodyColor(Color.BLACK);
        this.setGunColor(Color.BLACK);
        this.setBodyColor(Color.BLACK);
        this.setRadarColor(Color.BLACK);
        this.setScanColor(Color.RED);
        this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        while (true) {
            this.scan();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double carTurn;
        if (this.energy != e.getEnergy()) {
            this.reverse2();
            this.energy = e.getEnergy();
        }
        double radarTurn = this.getHeadingRadians() + e.getBearingRadians() - this.getRadarHeadingRadians();
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)radarTurn));
        if (e.getDistance() < 310.0 && !this.overRide) {
            carTurn = this.getHeadingRadians() + e.getBearingRadians() - this.getHeadingRadians() + 1.5707963267948966;
            this.setTurnRightRadians(Utils.normalRelativeAngle((double)carTurn));
            if ((this.getX() < 50.0 || this.getY() < 50.0 || this.getY() > this.getBattleFieldHeight() - 50.0 || this.getX() > this.getBattleFieldWidth() - 50.0) && !this.lockedRev) {
                this.reverse();
                this.lockedRev = true;
            }
            if (this.getX() > 50.0 && this.getY() > 50.0 && this.getY() < this.getBattleFieldHeight() - 50.0 && this.getX() < this.getBattleFieldWidth() - 50.0 && this.lockedRev) {
                this.lockedRev = false;
            }
            this.setAhead(this.speed);
        } else {
            this.overRide = true;
            carTurn = this.getHeadingRadians() + e.getBearingRadians() - this.getHeadingRadians();
            this.setTurnRightRadians(Utils.normalRelativeAngle((double)carTurn));
            this.setAhead(10.0);
            if (e.getDistance() < 300.0) {
                this.overRide = false;
            }
        }
        if (e.getDistance() < 50.0) {
            this.reverse();
        }
        this.bulletPower = 3.0 - e.getDistance() / 200.0;
        double velocity = 20.0 - 3.0 * this.bulletPower;
        double timeToHit = e.getDistance() / velocity * 1.5;
        double aimX = Math.sin(this.getRadarHeadingRadians()) * e.getDistance() + this.getX();
        double aimY = Math.cos(this.getRadarHeadingRadians()) * e.getDistance() + this.getY();
        double enemySpeedX = aimX - this.prevAimX;
        double enemySpeedY = aimY - this.prevAimY;
        double plusAimX = timeToHit * (Math.sin(e.getHeadingRadians()) * enemySpeedX);
        double plusAimY = timeToHit * (Math.cos(e.getHeadingRadians()) * enemySpeedY);
        this.prevAimX = aimX;
        this.prevAimY = aimY;
        if ((double)(this.bulletsHit / this.bulletsMissed) < 0.1) {
            this.lockDown = false;
        }
        if (this.lockDown) {
            aimX = Math.sin(e.getHeadingRadians()) > 0.0 ? (aimX += plusAimX) : (aimX -= plusAimX);
            aimY = Math.cos(e.getHeadingRadians()) > 0.0 ? (aimY += plusAimY) : (aimY -= plusAimY);
        }
        double angle = Utils.normalAbsoluteAngle((double)Math.atan2(aimX - this.getX(), aimY - this.getY()));
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(angle - this.getGunHeadingRadians())));
        if (this.getEnergy() > 10.0) {
            this.fire(this.bulletPower);
        }
    }

    void reverse() {
        this.speed = -this.speed;
    }

    void reverse2() {
        if (!(this.getX() < 100.0 || this.getY() < 100.0 || this.getY() > this.getBattleFieldHeight() - 100.0 || this.getX() > this.getBattleFieldWidth() - 100.0)) {
            switch ((int)Math.ceil(Math.random() * 2.0)) {
                case 1: {
                    this.speed = -this.speed;
                    break;
                }
            }
        }
    }

    public void onHitRobot(HitRobotEvent e) {
        this.reverse();
    }

    public void onHitWall(HitWallEvent e) {
        this.reverse();
    }

    public void onBulletHit(BulletHitEvent event) {
        ++this.bulletsHit;
    }

    public void onBulletMissed(BulletMissedEvent event) {
        ++this.bulletsMissed;
    }
}

