/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.Movement.DangerPrediction;

import rdt.AgentSmith.Movement.EnemyWaveManager;
import rdt.RobotData.RobotDataSnapshot;
import rdt.Targeting.Targeting;
import rdt.Waves.WaveData;

public abstract class DangerCalculationBase {
    private EnemyWaveManager _enemyWaveManager = null;

    public DangerCalculationBase(EnemyWaveManager enemyWaveManager) {
        this._enemyWaveManager = enemyWaveManager;
    }

    public abstract double GetDanger(long var1, double var3, double var5);

    protected int GetNumEnemyWaves() {
        return this._enemyWaveManager.GetNumActiveWaves();
    }

    protected double GetDistanceSqToClosestPredictedWave(int waveIndex, long tick, double x, double y) {
        WaveData enemyWave = this._enemyWaveManager.GetActiveWave(waveIndex);
        long snapshotIndex = tick - enemyWave.VirtualGunData.TickFired;
        if (snapshotIndex >= (long)WaveData.WaveSnapshotCount) {
            return Double.MAX_VALUE;
        }
        double closestDistance = Double.MAX_VALUE;
        int snapshotIndexInt = (int)snapshotIndex;
        int index = 0;
        while (index < enemyWave.NumWaveAngles) {
            WaveData.WaveAngleSnapshotData data = enemyWave.AngleSnapshots[index][snapshotIndexInt];
            double dX = x - data.CurrentLocationX;
            double dY = y - data.CurrentLocationY;
            double distanceSq = dX * dX + dY * dY;
            closestDistance = Math.min(closestDistance, distanceSq);
            ++index;
        }
        return closestDistance;
    }

    protected double GetDistanceToTargetSq(double x, double y) {
        RobotDataSnapshot snapshot = Targeting.GetCurrentTarget().Snapshots.get(0);
        double dX = x - snapshot.LocationX;
        double dY = y - snapshot.LocationY;
        return dX * dX + dY * dY;
    }
}

