/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.Movement.DangerPrediction;

import rdt.AgentSmith.Movement.DangerPrediction.DangerPredictionState;

public class MovementCommand {
    public DangerPredictionState PredictCommand(eCommand command, DangerPredictionState previousState) {
        return this.PredictCommand(command, previousState, null);
    }

    public DangerPredictionState PredictCommand(eCommand command, DangerPredictionState previousState, DangerPredictionState stateToFill) {
        double currentVelocity = previousState.Velocity;
        double maxTurning = Math.toRadians(10.0 - 0.75 * Math.abs(currentVelocity));
        double turnAngle = 0.0;
        switch (command) {
            case Forward: 
            case Back: {
                break;
            }
            case ForwardLeft: 
            case BackRight: {
                turnAngle = -maxTurning;
                break;
            }
            case ForwardRight: 
            case BackLeft: {
                turnAngle = maxTurning;
                break;
            }
        }
        double newHeading = previousState.Heading + turnAngle;
        double newVelocity = this.GetVelocity(command, currentVelocity);
        double dX = Math.sin(newHeading) * newVelocity;
        double dY = Math.cos(newHeading) * newVelocity;
        DangerPredictionState newState = stateToFill;
        if (newState == null) {
            newState = new DangerPredictionState();
        }
        newState.Heading = newHeading;
        newState.Velocity = newVelocity;
        newState.X = previousState.X + dX;
        newState.Y = previousState.Y + dY;
        return newState;
    }

    private double GetVelocity(eCommand command, double currentVelocity) {
        double newVelocity = currentVelocity;
        switch (command) {
            case Forward: 
            case ForwardLeft: 
            case ForwardRight: {
                if (currentVelocity >= 0.0) {
                    newVelocity += 1.0;
                    break;
                }
                newVelocity += MovementCommand.maxDecel(currentVelocity);
                break;
            }
            case Back: 
            case BackLeft: 
            case BackRight: {
                if (currentVelocity <= 0.0) {
                    newVelocity -= 1.0;
                    break;
                }
                newVelocity -= MovementCommand.maxDecel(currentVelocity);
                break;
            }
        }
        newVelocity = Math.min(newVelocity, 8.0);
        newVelocity = Math.max(newVelocity, -8.0);
        return newVelocity;
    }

    private static double maxDecel(double speed) {
        double decelTime = Math.abs(speed) / 2.0;
        double accelTime = 1.0 - decelTime;
        return Math.min(1.0, decelTime) * 2.0 + Math.max(0.0, accelTime) * 1.0;
    }

    public static enum eCommand {
        Forward,
        ForwardLeft,
        ForwardRight,
        Back,
        BackLeft,
        BackRight,
        MAX;

    }
}

