/*
 * Decompiled with CFR 0.152.
 */
package rdt.RobotData;

import rdt.AgentSmith.AgentSmith;
import rdt.RobotData.RobotData;
import rdt.RobotData.RobotDataSnapshot;
import rdt.Utils.MathUtils;
import rdt.Utils.RuleUtils;
import robocode.util.Utils;

public class RobotDataModification {
    public static void Reset(RobotData data) {
        data.Valid = false;
        data.Dead = false;
        data.TickLastUpdated = -1L;
        data.NumSnapshots = 0;
        data.Snapshots.clear();
    }

    public static RobotDataSnapshot GetSnapshotToFill(RobotData data) {
        RobotDataSnapshot snapshot = null;
        if (data.NumSnapshots > 0 && data.TickLastUpdated == data.Snapshots.get((int)0).SnapshotTick) {
            return data.Snapshots.get(0);
        }
        if (data.Snapshots.size() < data.MaxSnapshots) {
            snapshot = new RobotDataSnapshot();
        } else {
            snapshot = data.Snapshots.get(data.MaxSnapshots - 1);
            data.Snapshots.remove(data.MaxSnapshots - 1);
            if (data.NumSnapshots >= data.MaxSnapshots) {
                --data.NumSnapshots;
            }
        }
        ++data.NumSnapshots;
        data.Snapshots.add(0, snapshot);
        return snapshot;
    }

    public static void UpdateSnapshot(RobotData dataToUpdate, double x, double y, double absHeading, double velocity, double energy, double targetX, double targetY, double absAngleFromTarget) {
        dataToUpdate.Valid = true;
        dataToUpdate.TickLastUpdated = AgentSmith.Instance().getTime();
        RobotDataSnapshot snapshot = RobotDataModification.GetSnapshotToFill(dataToUpdate);
        snapshot.SnapshotTick = dataToUpdate.TickLastUpdated;
        snapshot.LocationX = x;
        snapshot.LocationY = y;
        snapshot.AbsoluteHeading = absHeading;
        snapshot.VelocityAlongHeading = velocity;
        snapshot.LateralVelocity = Math.abs(velocity * Math.sin(absHeading - absAngleFromTarget));
        snapshot.AdvancingVelocity = velocity * -Math.cos(absHeading - absAngleFromTarget);
        snapshot.AbsoluteAngleFromTarget = absAngleFromTarget;
        snapshot.Energy = energy;
        double diffX = x - targetX;
        double diffY = y - targetY;
        snapshot.DistanceToTarget = Math.sqrt(diffX * diffX + diffY * diffY);
        double previousVelocity = snapshot.VelocityAlongHeading;
        double previousEnergy = snapshot.Energy;
        double previousDirection = 0.0;
        double previousX = x;
        double previousY = y;
        double previousNonZeroVelocity = 0.0;
        long previousTicksSinceDirectionChange = 0L;
        long previousTicksSinceDeceleration = 0L;
        snapshot.LastFiredTick = 0L;
        snapshot.LastFiredFirepower = 0.0;
        if (dataToUpdate.NumSnapshots > 1) {
            RobotDataSnapshot lastSnapshot = dataToUpdate.Snapshots.get(1);
            previousVelocity = lastSnapshot.VelocityAlongHeading;
            previousEnergy = lastSnapshot.Energy;
            previousDirection = lastSnapshot.RotationDirectionToTarget;
            previousX = lastSnapshot.LocationX;
            previousY = lastSnapshot.LocationY;
            previousNonZeroVelocity = lastSnapshot.LastNonZeroVelocityAlongHeading;
            previousTicksSinceDirectionChange = lastSnapshot.TicksSinceDirectionChange;
            previousTicksSinceDeceleration = lastSnapshot.TicksSinceDeceleration;
            snapshot.LastFiredTick = lastSnapshot.LastFiredTick;
            snapshot.LastFiredFirepower = lastSnapshot.LastFiredFirepower;
        }
        double deltaXPerTick = x - previousX;
        double deltaYPerTick = y - previousY;
        double lastKnownGoodX = x;
        double lastKnownGoodY = y;
        double padding = AgentSmith.Instance().GetBotSizeMinHalf();
        double battleWidth = AgentSmith.Instance().getBattleFieldWidth();
        double battleHeight = AgentSmith.Instance().getBattleFieldHeight();
        int index = 0;
        while (index < RobotDataSnapshot.MAX_PREDICTED_POSITIONS) {
            double predictedX = x + deltaXPerTick * (double)index;
            double predictedY = y + deltaYPerTick * (double)index;
            if (RuleUtils.IsOutsideBattlefield(predictedX, predictedY, padding, battleWidth, battleHeight)) {
                predictedX = lastKnownGoodX;
                predictedY = lastKnownGoodY;
            } else {
                lastKnownGoodX = predictedX;
                lastKnownGoodY = predictedY;
            }
            snapshot.PredictedPositionsX[index] = predictedX;
            snapshot.PredictedPositionsY[index] = predictedY;
            ++index;
        }
        snapshot.LastNonZeroVelocityAlongHeading = previousNonZeroVelocity;
        if (!Utils.isNear((double)snapshot.VelocityAlongHeading, (double)0.0)) {
            snapshot.LastNonZeroVelocityAlongHeading = snapshot.VelocityAlongHeading;
        }
        snapshot.TicksSinceDirectionChange = Math.signum(snapshot.LastNonZeroVelocityAlongHeading) != Math.signum(previousNonZeroVelocity) ? 0L : previousTicksSinceDirectionChange + 1L;
        snapshot.AccelerationAlongHeading = velocity - previousVelocity;
        snapshot.AccelerationAlongHeading = Math.max(Math.min(snapshot.AccelerationAlongHeading, 2.0), -2.0);
        snapshot.AccelerationAlongVelocityVector = snapshot.AccelerationAlongHeading * Math.signum(snapshot.VelocityAlongHeading);
        snapshot.TicksSinceDeceleration = snapshot.AccelerationAlongVelocityVector < 0.0 ? 0L : previousTicksSinceDeceleration + 1L;
        snapshot.BulletFirepower = RobotDataModification.DetectBulletFirepower(previousEnergy, energy, snapshot.LastFiredFirepower, snapshot.SnapshotTick, snapshot.LastFiredTick);
        if (snapshot.BulletFirepower > 0.0) {
            snapshot.LastFiredTick = snapshot.SnapshotTick;
            snapshot.LastFiredFirepower = snapshot.BulletFirepower;
        }
        double prevAngle = MathUtils.GetAngle(targetX, targetY, previousX, previousY);
        prevAngle = Utils.normalAbsoluteAngle((double)prevAngle);
        double diff = absAngleFromTarget - prevAngle;
        diff = Utils.normalRelativeAngle((double)diff);
        double newDirection = 1.0;
        if (Utils.isNear((double)0.0, (double)diff) || Math.abs(velocity) < 1.0) {
            newDirection = previousDirection;
        } else if (diff < 0.0) {
            newDirection = -1.0;
        }
        snapshot.RotationDirectionToTarget = newDirection;
        int oldSnapshotIndex = Math.min(10, dataToUpdate.NumSnapshots - 1);
        double distanceLast10 = 0.0;
        if (oldSnapshotIndex > 0) {
            RobotDataSnapshot oldSnapshot = dataToUpdate.Snapshots.get(oldSnapshotIndex);
            double dX = x - oldSnapshot.LocationX;
            double dY = y - oldSnapshot.LocationY;
            distanceLast10 = Math.sqrt(dX * dX + dY * dY);
        }
        snapshot.DistanceLast10 = distanceLast10;
        double dX = Math.sin(absHeading);
        double dY = Math.cos(absHeading);
        snapshot.DistanceToWallAhead = RuleUtils.GetDistanceToWall(x, y, dX, dY);
        snapshot.DistanceToWallBehind = RuleUtils.GetDistanceToWall(x, y, -dX, -dY);
    }

    public static double DetectBulletFirepower(double oldEnergy, double newEnergy, double previousFirepowerUsed, long currentTick, long previousFiredTick) {
        long ticksSinceFired = currentTick - previousFiredTick;
        double gunHeatCooled = (double)ticksSinceFired * 0.1;
        double previousGunHeatGenerated = 0.0;
        if (previousFirepowerUsed > 0.0) {
            previousGunHeatGenerated = 1.0 + previousFirepowerUsed / 5.0;
        }
        if (gunHeatCooled < previousGunHeatGenerated) {
            return 0.0;
        }
        double diff = oldEnergy - newEnergy;
        if (diff > 0.0 && diff <= 3.0) {
            return diff;
        }
        return 0.0;
    }
}

