/*
 * Decompiled with CFR 0.152.
 */
package rdt;

import java.awt.Graphics2D;
import java.util.Vector;
import rdt.Debug.DebugUsageCounter;
import rdt.SubsystemMode;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;

public class SubsystemManager {
    private Vector<SubsystemMode> _modes = null;
    private String _subsystemName;

    public void Initialise(String subsystemName) {
        this._subsystemName = subsystemName;
        this._modes = new Vector();
    }

    public void AddMode(SubsystemMode mode) {
        this._modes.add(mode);
    }

    public void OnRoundStart() {
        int count = 0;
        while (count < this._modes.size()) {
            SubsystemMode mode = this._modes.get(count);
            if (mode != null) {
                mode.OnRoundStart();
            }
            ++count;
        }
    }

    public void Update() {
        float highestPriority = -1.0f;
        SubsystemMode highestPriorityMode = null;
        int count = 0;
        while (count < this._modes.size()) {
            SubsystemMode mode = this._modes.get(count);
            if (mode != null) {
                mode.Update();
                float priority = mode.GetPriority();
                if (priority > highestPriority) {
                    highestPriority = priority;
                    highestPriorityMode = mode;
                }
            }
            ++count;
        }
        if (highestPriorityMode != null) {
            highestPriorityMode.UpdateHighestPriority();
            DebugUsageCounter.IncrementCount(this._subsystemName, highestPriorityMode.GetName());
        }
    }

    public void OnHitByBulletEvent(HitByBulletEvent event) {
        int count = 0;
        while (count < this._modes.size()) {
            SubsystemMode mode = this._modes.get(count);
            if (mode != null) {
                mode.OnHitByBulletEvent(event);
            }
            ++count;
        }
    }

    public void OnBulletHitEvent(BulletHitEvent event) {
        int count = 0;
        while (count < this._modes.size()) {
            SubsystemMode mode = this._modes.get(count);
            if (mode != null) {
                mode.OnBulletHitEvent(event);
            }
            ++count;
        }
    }

    public void OnBulletHitBulletEvent(BulletHitBulletEvent event) {
        int count = 0;
        while (count < this._modes.size()) {
            SubsystemMode mode = this._modes.get(count);
            if (mode != null) {
                mode.OnBulletHitBulletEvent(event);
            }
            ++count;
        }
    }

    public void OnBulletMissedEvent(BulletMissedEvent event) {
        int count = 0;
        while (count < this._modes.size()) {
            SubsystemMode mode = this._modes.get(count);
            if (mode != null) {
                mode.OnBulletMissedEvent(event);
            }
            ++count;
        }
    }

    public void DebugDraw(Graphics2D gfx) {
        int count = 0;
        while (count < this._modes.size()) {
            SubsystemMode mode = this._modes.get(count);
            if (mode != null) {
                mode.DebugDraw(gfx);
            }
            ++count;
        }
    }
}

