/*
 * Decompiled with CFR 0.152.
 */
package rdt.Utils;

import rdt.Utils.CircleCircleIntersectionResult;

public class MathUtils {
    public static final double DOUBLE_PI = Math.PI * 2;
    public static final double PI = Math.PI;
    public static final double HALF_PI = 1.5707963267948966;

    public static double GetAngle(double x1, double y1, double x2, double y2) {
        return Math.atan2(x2 - x1, y2 - y1);
    }

    public static double CalcRollingAverage(double currentRollingAverage, double newEntry, double history, double weighting) {
        return (currentRollingAverage * history + newEntry * weighting) / (history + weighting);
    }

    public static double Clamp(double value, double min, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static int Clamp(int value, int min, int max) {
        return Math.max(min, Math.min(value, max));
    }

    public static long Clamp(long value, long min, long max) {
        return Math.max(min, Math.min(value, max));
    }

    public static void CircleCircleIntersection(double x0, double y0, double r0, double x1, double y1, double r1, CircleCircleIntersectionResult result) {
        result.Intersection = false;
        double dy = y1 - y0;
        double dx = x1 - x0;
        double d = Math.sqrt(dy * dy + dx * dx);
        if (d > r0 + r1) {
            return;
        }
        if (d < Math.abs(r0 - r1)) {
            return;
        }
        double a = (r0 * r0 - r1 * r1 + d * d) / (2.0 * d);
        double x2 = x0 + dx * a / d;
        double y2 = y0 + dy * a / d;
        double h = Math.sqrt(r0 * r0 - a * a);
        double rx = -dy * (h / d);
        double ry = dx * (h / d);
        result.X1 = x2 + rx;
        result.X2 = x2 - rx;
        result.Y1 = y2 + ry;
        result.Y2 = y2 - ry;
        result.Intersection = true;
    }

    public static double PointOnSideOfLine(double lineX1, double lineY1, double lineX2, double lineY2, double pointX, double pointY) {
        return (pointX - lineX1) * (lineY2 - lineY1) - (pointY - lineY1) * (lineX2 - lineX1);
    }
}

