/*
 * Decompiled with CFR 0.152.
 */
package rdt.VirtualGuns.Guns.DC;

import java.util.ArrayList;
import rdt.AgentSmith.AgentSmith;
import rdt.RobotData.RobotDataSnapshot;
import rdt.Waves.WaveData;

public class Segmentation {
    private ArrayList<eSegmentation> _segmentationList;

    public Segmentation(ArrayList<eSegmentation> segmentationList) {
        this._segmentationList = segmentationList;
    }

    public double[] GetData(RobotDataSnapshot snapshot, WaveData.eWaveType waveType) {
        double[] data = new double[this._segmentationList.size()];
        int dataIndex = 0;
        if (this._segmentationList.contains((Object)eSegmentation.Distance)) {
            data[dataIndex] = this.GetDistance(snapshot);
            ++dataIndex;
        }
        if (this._segmentationList.contains((Object)eSegmentation.Velocity)) {
            data[dataIndex] = this.GetVelocity(snapshot);
            ++dataIndex;
        }
        if (this._segmentationList.contains((Object)eSegmentation.Acceleration)) {
            data[dataIndex] = this.GetAcceleration(snapshot);
            ++dataIndex;
        }
        if (this._segmentationList.contains((Object)eSegmentation.LateralVelocity)) {
            data[dataIndex] = this.GetLateralVelocity(snapshot);
            ++dataIndex;
        }
        if (this._segmentationList.contains((Object)eSegmentation.AdvancingVelocity)) {
            data[dataIndex] = this.GetAdvancingVelocity(snapshot);
            ++dataIndex;
        }
        if (this._segmentationList.contains((Object)eSegmentation.TimeSinceDirectionChange)) {
            data[dataIndex] = this.GetTimeSinceDirectionChange(snapshot);
            ++dataIndex;
        }
        if (this._segmentationList.contains((Object)eSegmentation.TimeSinceDeceleration)) {
            data[dataIndex] = this.GetTimeSinceDeceleration(snapshot);
            ++dataIndex;
        }
        if (this._segmentationList.contains((Object)eSegmentation.TotalTicks)) {
            data[dataIndex] = this.GetTotalTicks();
            ++dataIndex;
        }
        if (this._segmentationList.contains((Object)eSegmentation.WaveType)) {
            data[dataIndex] = this.GetWaveType(waveType);
            ++dataIndex;
        }
        if (this._segmentationList.contains((Object)eSegmentation.DistanceLast10)) {
            data[dataIndex] = this.GetDistanceLast10(snapshot);
            ++dataIndex;
        }
        if (this._segmentationList.contains((Object)eSegmentation.DistanceToWallAhead)) {
            data[dataIndex] = this.GetDistanceToWall(snapshot.DistanceToWallAhead);
            ++dataIndex;
        }
        if (this._segmentationList.contains((Object)eSegmentation.DistanceToWallBehind)) {
            data[dataIndex] = this.GetDistanceToWall(snapshot.DistanceToWallBehind);
            ++dataIndex;
        }
        return data;
    }

    private double GetDistance(RobotDataSnapshot snapshot) {
        return this.NormaliseLinear(snapshot.DistanceToTarget, 0.0, AgentSmith.Instance().getBattleFieldWidth());
    }

    private double GetVelocity(RobotDataSnapshot snapshot) {
        return this.NormaliseLinear(Math.abs(snapshot.VelocityAlongHeading), 0.0, 8.0);
    }

    private double GetAcceleration(RobotDataSnapshot snapshot) {
        return this.NormaliseLinear(snapshot.AccelerationAlongVelocityVector, -2.0, 1.0);
    }

    private double GetLateralVelocity(RobotDataSnapshot snapshot) {
        return this.NormaliseLinear(snapshot.LateralVelocity, 0.0, 8.0);
    }

    private double GetAdvancingVelocity(RobotDataSnapshot snapshot) {
        return this.NormaliseLinear(snapshot.AdvancingVelocity, -8.0, 8.0);
    }

    private double GetTimeSinceDirectionChange(RobotDataSnapshot snapshot) {
        return this.NormaliseNonLinear(snapshot.TicksSinceDirectionChange, (double)0.01f);
    }

    private double GetTimeSinceDeceleration(RobotDataSnapshot snapshot) {
        return this.NormaliseNonLinear(snapshot.TicksSinceDeceleration, (double)0.01f);
    }

    private double GetTotalTicks() {
        return this.NormaliseNonLinear(AgentSmith.Instance().GetTotalTicks(), (double)0.01f);
    }

    private double GetDistanceLast10(RobotDataSnapshot snapshot) {
        return this.NormaliseLinear(snapshot.DistanceLast10, 0.0, 80.0);
    }

    private double GetDistanceToWall(double distanceToWall) {
        return this.NormaliseLinear(distanceToWall, 0.0, 800.0);
    }

    private double GetWaveType(WaveData.eWaveType waveType) {
        if (waveType == WaveData.eWaveType.Real) {
            return 0.55;
        }
        return 0.45;
    }

    private double NormaliseLinear(double val, double min, double max) {
        val = Math.min(val, max);
        val = Math.max(min, val);
        double range = max - min;
        return (val - min) / range;
    }

    private double NormaliseNonLinear(long val, double k) {
        return 1.0 / (1.0 + k * (double)val);
    }

    private double NormaliseNonLinear(double val, double k) {
        return 1.0 / (1.0 + k * val);
    }

    public static enum eSegmentation {
        Distance,
        Velocity,
        Acceleration,
        LateralVelocity,
        AdvancingVelocity,
        TimeSinceDirectionChange,
        TimeSinceDeceleration,
        TotalTicks,
        WaveType,
        DistanceLast10,
        DistanceToWallAhead,
        DistanceToWallBehind;

    }
}

