/*
 * Decompiled with CFR 0.152.
 */
package rdt.VirtualGuns;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import rdt.AgentSmith.AgentSmith;
import rdt.RobotData.RobotData;
import rdt.Utils.MaximumEscapeAngle;
import rdt.VirtualGuns.VirtualGun;
import rdt.VirtualGuns.VirtualGunDataInterface;
import rdt.VirtualGuns.VirtualGunFiringData;
import rdt.VirtualGuns.VirtualGunStats;
import rdt.VirtualGuns.VirtualGunsFiringData;
import rdt.Waves.WaveData;
import rdt.Waves.WaveManager;
import rdt.Waves.WaveTargetListener;
import robocode.Rules;

public class VirtualGuns
implements WaveTargetListener {
    private ArrayList<VirtualGun> _virtualGuns = new ArrayList();
    private ArrayList<VirtualGunStats> _virtualGunStats = new ArrayList();
    private WaveManager _waveManager = null;
    private VirtualGunDataInterface _dataInterface = null;
    private String _name;
    private int _debugX;
    private int _debugY;
    private double _actualWeight;
    private double _virtualWeight;
    private boolean _triggerOnWavePassed;
    private VirtualGunsFiringData _lastDataGenerated = null;

    public VirtualGuns(String name, int debugX, int debugY, WaveManager manager, VirtualGunDataInterface dataInterface, double actualWeight, double virtualWeight, boolean triggerOnWavePassed) {
        this._debugX = debugX;
        this._debugY = debugY;
        if (manager != null) {
            this._waveManager = manager;
            this._waveManager.AddTargetListener(this);
        }
        this._name = name;
        this._dataInterface = dataInterface;
        this._actualWeight = actualWeight;
        this._virtualWeight = virtualWeight;
        this._triggerOnWavePassed = triggerOnWavePassed;
    }

    public int AddVirtualGun(VirtualGun gun) {
        gun.SetDataInterface(this._dataInterface);
        this._virtualGuns.add(gun);
        this._virtualGunStats.add(new VirtualGunStats(gun.GetName(), this._actualWeight, this._virtualWeight));
        return this._virtualGuns.size() - 1;
    }

    public int GetNumVirtualGuns() {
        return this._virtualGuns.size();
    }

    public VirtualGunStats GetGunStats(int gunIndex) {
        if (gunIndex < 0 || gunIndex >= this._virtualGuns.size()) {
            return null;
        }
        return this._virtualGunStats.get(gunIndex);
    }

    public void Update() {
        int numGuns = this._virtualGuns.size();
        int gunIndex = 0;
        while (gunIndex < numGuns) {
            this._virtualGuns.get(gunIndex).Update();
            ++gunIndex;
        }
    }

    public VirtualGunsFiringData GetFiringData(double bulletFirepower) {
        RobotData targetData = this._dataInterface.GetTargetData();
        VirtualGunsFiringData firingData = new VirtualGunsFiringData();
        firingData.FirePower = bulletFirepower;
        firingData.TickFired = this._dataInterface.GetTargetData().TickLastUpdated - (long)this._dataInterface.GetTargetDataAge() + 1L;
        firingData.FiringLocationX = this._dataInterface.GetFiringLocationX();
        firingData.FiringLocationY = this._dataInterface.GetFiringLocationY();
        firingData.BulletVelocity = Rules.getBulletSpeed((double)bulletFirepower);
        firingData.TargetSnapshotAtFireTime.CopyFrom(targetData.Snapshots.get(this._dataInterface.GetTargetDataAge()));
        firingData.MEA = new MaximumEscapeAngle(this._dataInterface.GetFiringLocationX(), this._dataInterface.GetFiringLocationY(), firingData.TargetSnapshotAtFireTime, bulletFirepower);
        int numGuns = this._virtualGuns.size();
        int gunIndex = 0;
        while (gunIndex < numGuns) {
            VirtualGunFiringData gunFiringData = this._virtualGuns.get(gunIndex).GetFiringData(firingData);
            firingData.GunFiringData.add(gunFiringData);
            ++gunIndex;
        }
        this._lastDataGenerated = firingData;
        return firingData;
    }

    @Override
    public void OnPassedTarget(WaveData wave, double targetLocationX, double targetLocationY) {
        if (wave.VirtualGunData == null) {
            System.out.println("VirtualGunData for wave is null for some reason");
            return;
        }
        int listSize = wave.VirtualGunData.GunFiringData.size();
        int index = 0;
        while (index < listSize) {
            VirtualGunStats stats = this._virtualGunStats.get(index);
            this._virtualGuns.get(index).OnWaveReachedTarget(wave);
            boolean hitTarget = this.DidHitTarget(wave.VirtualGunData, targetLocationX, targetLocationY, index, AgentSmith.Instance().getTime());
            if (wave.WaveType == WaveData.eWaveType.Virtual) {
                if (hitTarget) {
                    stats.LogHitVirtual(wave.VirtualGunData.FirePower);
                } else {
                    stats.LogMissVirtual();
                }
            } else if (wave.WaveType == WaveData.eWaveType.Real) {
                if (hitTarget) {
                    stats.LogHitActual(wave.VirtualGunData.FirePower);
                } else {
                    stats.LogMissActual();
                }
            }
            ++index;
        }
    }

    public void OnBulletHitBullet(double x, double y) {
        if (this._waveManager == null) {
            return;
        }
        WaveData wave = this._waveManager.GetWaveWhichCouldHaveHit(x, y, WaveData.eWaveType.Real);
        if (wave == null) {
            return;
        }
        wave.WaveType = WaveData.eWaveType.Virtual;
    }

    public void OnHitByBullet(double x, double y) {
        if (this._waveManager == null) {
            return;
        }
        WaveData wave = this._waveManager.GetWaveWhichCouldHaveHit(x, y, WaveData.eWaveType.Any);
        if (wave == null) {
            return;
        }
        int listSize = wave.VirtualGunData.GunFiringData.size();
        int index = 0;
        while (index < listSize) {
            this._virtualGuns.get(index).OnActualHitOnTarget(wave, x, y);
            ++index;
        }
    }

    private boolean DidHitTarget(VirtualGunsFiringData firingData, double targetX, double targetY, int virtualGunIndex, long absTick) {
        double targetBotHalfWidth;
        double dY;
        double predictedY;
        double distanceAwayY;
        long numTicks;
        double firingAbsAngle = firingData.GunFiringData.get((int)virtualGunIndex).FiringAbsoluteAngles.get(0);
        double dX = Math.sin(firingAbsAngle);
        double predictedX = firingData.FiringLocationX + dX * (double)(numTicks = absTick - firingData.TickFired) * firingData.BulletVelocity;
        double distanceAwayX = targetX - predictedX;
        double distanceAwaySq = distanceAwayX * distanceAwayX + (distanceAwayY = targetY - (predictedY = firingData.FiringLocationY + (dY = Math.cos(firingAbsAngle)) * (double)numTicks * firingData.BulletVelocity)) * distanceAwayY;
        return distanceAwaySq <= (targetBotHalfWidth = AgentSmith.Instance().GetBotSizeMaxHalf()) * targetBotHalfWidth;
    }

    public void DebugDraw(Graphics2D gfx) {
        gfx.setColor(Color.white);
        int numStats = this._virtualGunStats.size();
        int x = this._debugX;
        int y = this._debugY;
        int deltaY = 20;
        int statIndex = 0;
        while (statIndex < numStats) {
            VirtualGunStats stats = this._virtualGunStats.get(statIndex);
            gfx.drawString(stats.GetDebugText(), x, y);
            y += deltaY;
            this._virtualGuns.get(statIndex).DebugDraw(gfx, this._dataInterface.GetFiringLocationX(), this._dataInterface.GetFiringLocationY(), this._dataInterface.GetTargetData());
            ++statIndex;
        }
        if (this._lastDataGenerated != null) {
            this._lastDataGenerated.MEA.DebugDraw(gfx, this._dataInterface.GetFiringLocationX(), this._dataInterface.GetFiringLocationY());
        }
    }
}

