/*
 * Decompiled with CFR 0.152.
 */
package bh.units;

import bh.units.Duration;
import bh.units.Heading;
import bh.units.RelativeLocation;
import bh.units.Speed;
import bh.util.Vector;

public class Velocity {
    protected Heading heading;
    protected Speed speed;

    public Velocity(Heading heading, Speed speed) {
        this.heading = heading;
        this.speed = speed;
    }

    public Heading getHeading() {
        return this.heading;
    }

    public Speed getSpeed() {
        return this.speed;
    }

    public Speed getXSpeed() {
        return this.speed.times(this.heading.toAngle().sin());
    }

    public Speed getYSpeed() {
        return this.speed.times(this.heading.toAngle().cos());
    }

    public RelativeLocation multiply(Duration duration) {
        return new RelativeLocation(this.heading, this.speed.times(duration));
    }

    public Vector toVector() {
        return new Vector(this.heading).times(this.speed.toDouble());
    }

    public String toString() {
        return "<" + this.heading + ", " + Math.round(this.speed.toDouble()) + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Velocity)) {
            return false;
        }
        Velocity velocity = (Velocity)o;
        return velocity.heading.equals(this.heading) && velocity.speed.equals(this.speed);
    }

    public int hashCode() {
        return this.heading.hashCode() * 31 + this.speed.hashCode();
    }
}

