/*
 * Decompiled with CFR 0.152.
 */
package metal.shared;

import metal.shared.MBullet;
import metal.shared.MMath;
import metal.shared.MPoint;

public class MAngle {
    public static double absolute(MPoint point1, MPoint point2) {
        double x0 = point2.getX() - point1.getX();
        double y0 = point2.getY() - point1.getY();
        double angle = MMath.atan2(x0, y0);
        angle = MAngle.absolute(angle);
        return angle;
    }

    public static double absolute(double angle) {
        if (angle >= 0.0 && angle < 360.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle < 0.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle >= 360.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    public static double max(double speed, double power) {
        return 1.1 * MMath.asin(speed / MBullet.getSpeed(power));
    }

    public static double relative(double angle) {
        if (angle > -180.0 && angle <= 180.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle <= -180.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle > 180.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }
}

