/*
 * Decompiled with CFR 0.152.
 */
package metal.shared;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import metal.shared.MAim1;
import metal.shared.MBotData;
import metal.shared.MBullet;
import metal.shared.MPoint;
import metal.shared.MScorer;
import metal.shared.MUtil2;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.DeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class MGun1 {
    static final double BEST_DISTANCE = 525.0;
    static Rectangle2D.Double BF;
    static final int GF_ONE = 24;
    static final int GF_ZERO = 12;
    static double bearingDirection;
    static double circleDir;
    double circleTime = 0.0;
    static double enemyDistance;
    static double enemyEnergy;
    static double enemyFirePower;
    static double enemyFireTime;
    static double enemyLatVel;
    static MPoint enemyLocation;
    static String enemyName;
    static double enemyVelocity;
    static boolean flat;
    static int[][][][][][] guessFactors;
    static double hits;
    static double lastLatVel;
    static double lastReverseTime;
    static double lastVChangeTime;
    static double lastVelocity;
    static double numBadHits;
    static double numWins;
    double product = 1.0;
    static MPoint robotLocation;
    boolean saved = false;
    static double shots;
    boolean stopping = false;
    static boolean testmode;

    static {
        flat = true;
        bearingDirection = 1.0;
        circleDir = 1.0;
        guessFactors = new int[3][5][3][3][6][25];
        testmode = false;
        hits = 0.0;
        shots = 0.0;
    }

    public MGun1() {
        MBotData.print("SYSTEM:  Gun        ... OK");
        BF = new Rectangle2D.Double(18.0, 18.0, MBotData.self.getBattleFieldWidth() - 36.0, MBotData.self.getBattleFieldHeight() - 36.0);
        MScorer.init();
    }

    public void convertCribSheet(byte[][][][][] crib) {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 5) {
                int k = 0;
                while (k < 3) {
                    int l = 0;
                    while (l < 3) {
                        int m = 0;
                        while (m < 6) {
                            int[] nArray = guessFactors[i][j][k][l][m];
                            byte by = crib[i][j][k][l][m];
                            nArray[by] = nArray[by] + 15;
                            ++m;
                        }
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public int getBestGF(int[] gfs) {
        int bestGF = 12;
        int gf = 24;
        while (gf >= 0) {
            if (gfs[gf] > gfs[bestGF]) {
                bestGF = gf;
            }
            --gf;
        }
        return bestGF;
    }

    public byte[][][][][] getCribSheet() {
        byte[][][][][] crib = new byte[3][5][3][3][6];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 5) {
                int k = 0;
                while (k < 3) {
                    int l = 0;
                    while (l < 3) {
                        int m = 0;
                        while (m < 6) {
                            crib[i][j][k][l][m] = (byte)this.getBestGF(guessFactors[i][j][k][l][m]);
                            ++m;
                        }
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return crib;
    }

    public void loadData() {
        try {
            Object o = MUtil2.restoreObject(MBotData.self.getDataFile(enemyName));
            byte[][][][][] crib = (byte[][][][][])o;
            this.convertCribSheet(crib);
        }
        catch (Exception e) {
            MBotData.self.out.println("Unable to load data.");
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        hits += 1.0;
    }

    public void onDeath(DeathEvent e) {
        this.printStats();
        this.saveData();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double d;
        if (enemyName == null) {
            enemyName = e.getName();
            if (!testmode) {
                this.loadData();
            }
        }
        robotLocation = MBotData.enemy;
        double enemyAbsoluteBearing = MBotData.self.getHeadingRadians() + e.getBearingRadians();
        enemyDistance = e.getDistance();
        enemyLocation = MUtil2.projectMotion(robotLocation, enemyAbsoluteBearing, enemyDistance);
        enemyEnergy -= e.getEnergy();
        if (d >= 0.1 && enemyEnergy <= 3.0) {
            enemyFirePower = enemyEnergy;
            enemyFireTime = MBotData.self.getTime();
        }
        enemyEnergy = e.getEnergy();
        MicroWave w = new MicroWave();
        lastLatVel = enemyLatVel;
        lastVelocity = enemyVelocity;
        enemyVelocity = e.getVelocity();
        enemyLatVel = enemyVelocity * Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing);
        int distanceIndex = Math.min(5, (int)enemyDistance / 140);
        MBullet.calcPower(0.0);
        double bulletPower = MBullet.power;
        double theta = Math.min(MBotData.self.getEnergy() / 4.0, Math.min(enemyEnergy / 4.0, bulletPower));
        if (theta == bulletPower) {
            MBotData.self.addCustomEvent(w);
        }
        bulletPower = theta;
        w.bulletVelocity = MUtil2.bulletVelocity(bulletPower);
        int accelIndex = (int)Math.round(Math.abs(enemyLatVel) - Math.abs(lastLatVel));
        if (enemyLatVel != 0.0) {
            bearingDirection = enemyLatVel > 0.0 ? 1.0 : -1.0;
        }
        w.bearingDirection = bearingDirection * MUtil2.maxEscapeAngle(w.bulletVelocity) / 12.0;
        double d2 = lastVChangeTime;
        lastVChangeTime = d2 + 1.0;
        double moveTime = w.bulletVelocity * d2 / enemyDistance;
        int bestGF = moveTime < 0.1 ? 1 : (moveTime < 0.3 ? 2 : (moveTime < 1.0 ? 3 : 4));
        int vIndex = (int)Math.abs(enemyLatVel / 3.0);
        if (Math.abs(Math.abs(enemyVelocity) - Math.abs(lastVelocity)) > 0.6) {
            lastVChangeTime = 0.0;
            bestGF = 0;
            accelIndex = (int)Math.round(Math.abs(enemyVelocity) - Math.abs(lastVelocity));
            vIndex = (int)Math.abs(enemyVelocity / 3.0);
        }
        if (accelIndex != 0) {
            accelIndex = accelIndex > 0 ? 1 : 2;
        }
        w.firePosition = robotLocation;
        w.enemyAbsBearing = enemyAbsoluteBearing;
        w.waveGuessFactors = guessFactors[accelIndex][bestGF][vIndex][BF.contains(MUtil2.projectMotion(robotLocation, enemyAbsoluteBearing + w.bearingDirection * 12.0, enemyDistance)) ? 0 : (BF.contains(MUtil2.projectMotion(robotLocation, enemyAbsoluteBearing + 0.5 * w.bearingDirection * 12.0, enemyDistance)) ? 1 : 2)][distanceIndex];
        bestGF = 12;
        int gf = 24;
        while (gf >= 0 && enemyEnergy > 0.0) {
            if (w.waveGuessFactors[gf] > w.waveGuessFactors[bestGF]) {
                bestGF = gf;
            }
            --gf;
        }
        MBotData.self.setTurnGunRightRadians(MAim1.Linear.getAngle(w.bearingDirection, bestGF - 12));
        if (MBotData.self.getEnergy() > 1.0 || distanceIndex == 0) {
            if (MBotData.self.getGunHeat() == 0.0) {
                shots += 1.0;
            }
            if (accelIndex == 2 || accelIndex == 0) {
                MBotData.self.setFire(bulletPower);
            } else if (MBotData.enemy.speed == 0.0) {
                MBotData.self.setFire(bulletPower);
            }
        }
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        MBotData.self.out.println("Skipped turn");
    }

    public void onWin(WinEvent e) {
        numWins += 1.0;
        this.printStats();
    }

    public void printStats() {
        MBotData.self.out.println("");
        MBotData.self.out.println("-----------------------");
        MBotData.self.out.println("Statistics for opponent " + enemyName);
        MBotData.self.out.println("-----------------------");
        MBotData.self.out.println("Win rate         |  " + (double)((int)(1000.0 * numWins / (double)(MBotData.self.getRoundNum() + 1))) / 10.0 + "%");
        MBotData.self.out.println("My accuracy      |  " + (double)((int)(1000.0 * hits / shots)) / 10.0 + "%");
        MBotData.self.out.println("");
    }

    public void saveData() {
        if (!testmode && MBotData.self.getRoundNum() + 4 > MBotData.self.getNumRounds() && !this.saved) {
            MUtil2.saveObject(this.getCribSheet(), MBotData.self.getDataFile(enemyName));
        }
        this.saved = true;
    }

    class MicroWave
    extends Condition {
        double bearingDirection;
        double bulletVelocity;
        double distance;
        double enemyAbsBearing;
        Point2D.Double firePosition;
        int[] waveGuessFactors;

        MicroWave() {
        }

        public boolean test() {
            double d;
            this.distance += this.bulletVelocity;
            if (enemyLocation.distance(this.firePosition) <= d + this.bulletVelocity) {
                try {
                    int n = (int)Math.round(Utils.normalRelativeAngle((double)(MUtil2.absoluteBearing(this.firePosition, enemyLocation) - this.enemyAbsBearing)) / this.bearingDirection + 12.0);
                    this.waveGuessFactors[n] = this.waveGuessFactors[n] + 1;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    // empty catch block
                }
                MBotData.self.removeCustomEvent(this);
            }
            return false;
        }
    }
}

