/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.data;

import dmh.robocode.data.BattleConstants;
import dmh.robocode.data.Location;
import dmh.robocode.utils.Geometry;

public class PerfectHitMovement {
    private int distanceMoved;
    private int bearing;
    private int changeOfBearing;

    public PerfectHitMovement(double distanceMoved, double bearing, double originalBearing, double originalVelocity) {
        this.distanceMoved = (int)Math.round(distanceMoved);
        this.bearing = (int)Math.round(bearing);
        if (originalVelocity < 0.0) {
            originalBearing += 180.0;
        }
        this.changeOfBearing = (int)Math.round(Geometry.getRelativeBearing(originalBearing, bearing));
    }

    public Location applyAbsoluteMovement(Location enemyStart) {
        Location enemyFinish = Geometry.getLocationAtBearing(enemyStart, this.bearing, this.distanceMoved);
        return this.getResultIfOnBattlefield(enemyFinish);
    }

    public Location applyRelativeMovement(Location enemyStart, double enemyCurrentHeading) {
        Location enemyFinish = Geometry.getLocationAtBearing(enemyStart, enemyCurrentHeading + (double)this.changeOfBearing, this.distanceMoved);
        return this.getResultIfOnBattlefield(enemyFinish);
    }

    private Location getResultIfOnBattlefield(Location enemyFinish) {
        if (enemyFinish.isOnBattlefield(BattleConstants.getInstance().getBattlefieldWidth(), BattleConstants.getInstance().getBattlefieldHeight())) {
            return enemyFinish;
        }
        return null;
    }
}

