/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.navigator;

import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.navigator.NavigatorCommand;
import dmh.robocode.simulate.SimulateableRobot;
import dmh.robocode.utils.Geometry;
import java.awt.Graphics2D;

public class NavigateToRamEnemy
implements NavigatorCommand {
    private EnemyRobot enemy;
    private SimulateableRobot myRobot;
    private static int MAX_AHEAD = 50;
    private int ahead = MAX_AHEAD;
    private int direction = 1;

    public NavigateToRamEnemy(EnemyRobot enemy, SimulateableRobot myRobot) {
        this.enemy = enemy;
        this.myRobot = myRobot;
    }

    @Override
    public void setWiggleFactor(int wiggleFactor) {
    }

    @Override
    public int getWiggleFactor() {
        return 0;
    }

    @Override
    public void setWiggleExpiry(long wiggleExpiry) {
    }

    @Override
    public long getWiggleExpiry() {
        return 0L;
    }

    @Override
    public boolean isDone() {
        return !this.enemy.isAlive();
    }

    @Override
    public double getRightTurn() {
        double enemyBearing = Geometry.getBearingBetweenLocations(this.myRobot.getLocation(), this.enemy.getLatestRadarObservation().getLocation());
        double forwardTurn = Geometry.getRelativeBearing(this.myRobot.getHeading(), enemyBearing);
        double backwardsTurn = Geometry.getRelativeBearing(this.myRobot.getHeading() + 180.0, enemyBearing);
        if (Math.abs(forwardTurn) < Math.abs(backwardsTurn)) {
            this.direction = 1;
            return forwardTurn;
        }
        this.direction = -1;
        return backwardsTurn;
    }

    @Override
    public double getAhead() {
        return (double)this.direction * 8.0 * 3.0;
    }

    @Override
    public double getVelocity() {
        return 8.0;
    }

    public EnemyRobot getEnemy() {
        return this.enemy;
    }

    @Override
    public void executed() {
    }

    @Override
    public void reverseDirection() {
    }

    @Override
    public void paint(Graphics2D g) {
    }
}

