/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.robot;

import dmh.robocode.bullet.DangerousBullet;
import dmh.robocode.data.Location;
import dmh.robocode.data.RadarObservation;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.enemy.EnemySet;
import dmh.robocode.gunner.GunnerBlastEnemy;
import dmh.robocode.gunner.GunnerDoNothing;
import dmh.robocode.gunner.aiming.AimBetweenFurthestPossibleForwardsAndBackwards;
import dmh.robocode.gunner.aiming.AimByInterpolatingStraightAhead;
import dmh.robocode.gunner.aiming.AimByMovementSequenceReplay;
import dmh.robocode.gunner.aiming.AimByRepeatingLastMove;
import dmh.robocode.gunner.aiming.AimByRepeatingLastMoveImproved;
import dmh.robocode.gunner.aiming.AimBySprayingAtLongDistance;
import dmh.robocode.gunner.aiming.AimForAverageLocation;
import dmh.robocode.gunner.aiming.AimForRecentLocation;
import dmh.robocode.gunner.aiming.AimUsingFixedTimeMachineReplay;
import dmh.robocode.gunner.aiming.AimUsingPerfectMovementsA;
import dmh.robocode.gunner.enemy.EnemyShootAtMyCurrentLocation;
import dmh.robocode.gunner.enemy.EnemyShootUsingRoughLinearInterpolation;
import dmh.robocode.navigator.NavigateRightAnglesToEnemy;
import dmh.robocode.navigator.NavigateToEnemy;
import dmh.robocode.navigator.NavigateToLocation;
import dmh.robocode.navigator.NavigateToLocations;
import dmh.robocode.navigator.NavigateToRamEnemy;
import dmh.robocode.navigator.target.EnemyTargetDefault;
import dmh.robocode.radar.RadarFullScan;
import dmh.robocode.radar.RadarNarrowLock;
import dmh.robocode.robot.CommandBasedRobot;
import dmh.robocode.simulate.RobotMovementSimulator;
import dmh.robocode.utils.BearingSelector;
import dmh.robocode.utils.Geometry;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import robocode.BattleEndedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;

public class BlackDeath
extends CommandBasedRobot {
    private static ColourScheme colourScheme = ColourScheme.BLACK_DEATH;
    private static boolean isLearningToAimAllowed = true;
    private static boolean isLearningFromEnemyStatsAllowed = true;
    private static boolean displayEndOfRoundStats = false;
    private static boolean paintAllowed = false;
    private static boolean displayFinalDebugStats = false;
    private static final double ABORT_ATTACK_RATIO = 1.3;
    private boolean attackConstantly = false;
    static double edgeSafetyMargin = 100.0;
    static double startModeEdgeMargin = 150.0;
    static double searchModeEdgeMargin = 800.0;
    private Location searchBottomLeft;
    private Location searchTopRight;
    private Location searchTopLeft;
    private Location searchBottomRight;
    private Location startBottomLeft;
    private Location startTopRight;
    private Location startTopLeft;
    private Location startBottomRight;
    private Location battleCentre;
    private BattleModeType battleMode;
    private long timeModeStarted;
    private long chickenLength;
    private static double aggressionFactor = 1.2;
    private int escapeLockTimer = 0;
    private EnemyRobot currentEnemyTarget = null;
    private boolean haveAttacked = false;
    private long timeWhenLastHitWhenPlayingDead;
    private double closestNewBulletDistance = 1200.0;
    private int chickenSuccess = 0;
    private int chickenFailure = 0;
    private List<Location> myExpectedMotionPath = null;

    @Override
    public void setupEnemyStrategies(EnemyRobot enemy) {
        enemy.addAimingStrategy(new AimByRepeatingLastMove(this, enemy, isLearningToAimAllowed, Color.CYAN));
        enemy.addAimingStrategy(new AimByRepeatingLastMoveImproved(this, enemy, isLearningToAimAllowed, Color.CYAN));
        enemy.addAimingStrategy(new AimByInterpolatingStraightAhead(this, enemy, isLearningToAimAllowed, Color.CYAN));
        enemy.addAimingStrategy(new AimForRecentLocation(this, enemy, isLearningToAimAllowed, Color.GREEN));
        enemy.addAimingStrategy(new AimForAverageLocation(this, enemy, isLearningToAimAllowed, 50L, 10, Color.GREEN));
        enemy.addAimingStrategy(new AimBySprayingAtLongDistance(this, enemy, isLearningToAimAllowed, Color.GREEN));
        enemy.addAimingStrategy(new AimByMovementSequenceReplay(this, enemy, isLearningToAimAllowed, Color.YELLOW));
        enemy.addAimingStrategy(new AimUsingFixedTimeMachineReplay(this, enemy, isLearningToAimAllowed, 5L, Color.YELLOW));
        enemy.addAimingStrategy(new AimUsingFixedTimeMachineReplay(this, enemy, isLearningToAimAllowed, 10L, Color.YELLOW));
        enemy.addAimingStrategy(new AimUsingFixedTimeMachineReplay(this, enemy, isLearningToAimAllowed, 20L, Color.YELLOW));
        enemy.addAimingStrategy(new AimUsingFixedTimeMachineReplay(this, enemy, isLearningToAimAllowed, 30L, Color.YELLOW));
        enemy.addAimingStrategy(new AimUsingFixedTimeMachineReplay(this, enemy, isLearningToAimAllowed, 40L, Color.YELLOW));
        enemy.addAimingStrategy(new AimUsingFixedTimeMachineReplay(this, enemy, isLearningToAimAllowed, 50L, Color.YELLOW));
        enemy.addAimingStrategy(new AimBetweenFurthestPossibleForwardsAndBackwards(this, enemy, isLearningToAimAllowed, Color.WHITE));
        enemy.addShootingAtUsStrategy(new EnemyShootAtMyCurrentLocation(this, enemy));
        enemy.addShootingAtUsStrategy(new EnemyShootUsingRoughLinearInterpolation(this, enemy));
    }

    @Override
    protected void initialiseRobotCommands() {
        this.createStandardLocations();
        this.initializeStartMode();
        if (!isLearningFromEnemyStatsAllowed) {
            enemies.turnOffLearning();
        }
        if (!displayFinalDebugStats) {
            this.doNotDisplayFinalDebugStats();
        }
    }

    private void createStandardLocations() {
        double maxMargin = Math.min(this.getBattleFieldHeight(), this.getBattleFieldWidth()) / 4.0;
        searchModeEdgeMargin = Math.min(searchModeEdgeMargin, maxMargin);
        startModeEdgeMargin = Math.min(searchModeEdgeMargin, maxMargin);
        this.searchBottomLeft = new Location(searchModeEdgeMargin, searchModeEdgeMargin);
        this.searchTopRight = new Location(this.getBattleFieldWidth() - searchModeEdgeMargin, this.getBattleFieldHeight() - searchModeEdgeMargin);
        this.searchTopLeft = new Location(searchModeEdgeMargin, this.getBattleFieldHeight() - searchModeEdgeMargin);
        this.searchBottomRight = new Location(this.getBattleFieldWidth() - searchModeEdgeMargin, searchModeEdgeMargin);
        this.startBottomLeft = new Location(startModeEdgeMargin, startModeEdgeMargin);
        this.startTopRight = new Location(this.getBattleFieldWidth() - startModeEdgeMargin, this.getBattleFieldHeight() - startModeEdgeMargin);
        this.startTopLeft = new Location(startModeEdgeMargin, this.getBattleFieldHeight() - startModeEdgeMargin);
        this.startBottomRight = new Location(this.getBattleFieldWidth() - startModeEdgeMargin, startModeEdgeMargin);
        this.battleCentre = new Location(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0);
    }

    @Override
    protected void adjustRobotCommands() {
        switch (this.battleMode) {
            case START: {
                this.operateStartMode();
                break;
            }
            case DEFEND: {
                this.operateDefendMode();
                break;
            }
            case ATTACK: {
                this.operateAttackMode();
                break;
            }
            case SEARCH: {
                this.operateSearchMode();
                break;
            }
            case ESCAPE: {
                this.operateEscapeMode();
                break;
            }
            case CHICKEN: {
                this.operateChickenMode();
                break;
            }
            case RAMMING: {
                this.operateRammingMode();
                break;
            }
            case PLAY_DEAD: {
                this.operatePlayDeadMode();
            }
        }
        if (colourScheme == ColourScheme.AIMING_STRATEGY && this.gunnerCommand.getAimingStrategy() != null) {
            this.setDebugColour(this.gunnerCommand.getAimingStrategy().getDebugColour());
        }
        this.closestNewBulletDistance = 1200.0;
    }

    @Override
    public String getShootingCategory(EnemyRobot enemy, double bulletSpeed) {
        StringBuffer category = new StringBuffer();
        double distance = Geometry.getDistanceBetweenLocations(this.getLocation(), enemy.getLatestRadarObservation().getLocation());
        if (distance < 200.0) {
            category.append("S");
        } else if (distance < 400.0) {
            category.append("M");
        } else {
            category.append("L");
        }
        return category.toString();
    }

    @Override
    public void onHitRobot(HitRobotEvent event) {
        if (this.battleMode == BattleModeType.CHICKEN) {
            ++this.chickenSuccess;
        }
        super.onHitRobot(event);
    }

    @Override
    public void onHitByBullet(HitByBulletEvent event) {
        if (this.battleMode == BattleModeType.PLAY_DEAD) {
            this.timeWhenLastHitWhenPlayingDead = this.getTime();
        } else {
            RadarObservation enemyObservation = enemies.getEnemy(event.getName()).getLatestRadarObservation();
            if (enemyObservation != null && Geometry.getDistanceBetweenLocations(this.getLocation(), enemyObservation.getLocation()) > 150.0) {
                this.navigatorCommand.setWiggleFactor(Math.min(this.navigatorCommand.getWiggleFactor() + 10, 20));
                this.navigatorCommand.setWiggleExpiry(this.getTime() + 100L);
            }
            if (this.battleMode == BattleModeType.CHICKEN) {
                ++this.chickenFailure;
            }
            super.onHitByBullet(event);
        }
    }

    @Override
    public void onEnemyHasFired(EnemyRobot enemy, double bulletPower) {
        super.onEnemyHasFired(enemy, bulletPower);
        double newBulletDistance = Geometry.getDistanceBetweenLocations(this.getLocation(), enemy.getLatestRadarObservation().getLocation());
        this.closestNewBulletDistance = Math.min(newBulletDistance, this.closestNewBulletDistance);
    }

    @Override
    public void onRoundEnded(RoundEndedEvent event) {
        super.onRoundEnded(event);
        GunnerBlastEnemy.displayAimingDebugStats();
    }

    @Override
    public void onBattleEnded(BattleEndedEvent event) {
        super.onBattleEnded(event);
    }

    @Override
    public void setPanicColours() {
        colourScheme = ColourScheme.PANIC;
        super.setPanicColours();
    }

    @Override
    public void onDeath(DeathEvent event) {
        super.onDeath(event);
        if (this.haveAttacked) {
            aggressionFactor -= 0.1;
        }
    }

    @Override
    public void onRobotDeath(RobotDeathEvent event) {
        super.onRobotDeath(event);
        if (this.haveAttacked) {
            switch (this.getOthers()) {
                case 0: {
                    aggressionFactor += 0.05;
                    break;
                }
                case 1: {
                    aggressionFactor += 0.02;
                    break;
                }
                case 2: {
                    aggressionFactor += 0.01;
                    break;
                }
            }
        }
    }

    @Override
    public double getEnemyLikelyToBeAimingForUs(EnemyRobot enemy) {
        EnemySet recentEnemies = this.getLiveEnemiesSeenRecently();
        double enemyDistance = Geometry.getDistanceBetweenLocations(this.getLocation(), enemy.getLatestRadarObservation().getLocation());
        if (enemyDistance <= 200.0 || enemy == recentEnemies.getClosestLiveEnemy(this.getLocation())) {
            return 100.0;
        }
        return 100 / recentEnemies.getNumberOfEnemies();
    }

    @Override
    protected void displayDebugInfoPerRound() {
        super.displayDebugInfoPerRound();
        if (displayEndOfRoundStats) {
            enemies.displayDebugEndOfRound();
        }
    }

    @Override
    protected void displayDebugInfoPerTurn() {
        super.displayDebugInfoPerTurn();
    }

    public void onPaint(Graphics2D g) {
        if (paintAllowed) {
            if (this.navigatorCommand != null) {
                this.navigatorCommand.paint(g);
            }
            for (DangerousBullet bullet : this.getDangerousBullets()) {
                bullet.paint(g, this.getTime());
            }
            if (this.myExpectedMotionPath != null) {
                g.setColor(Color.white);
                for (Location visiting : this.myExpectedMotionPath) {
                    g.fillOval((int)Math.round(visiting.getX()) - 1, (int)Math.round(visiting.getY()) - 1, 2, 2);
                }
            }
        }
    }

    public void setupEnemyStrategiesPREVIOUS(EnemyRobot enemy) {
        enemy.addAimingStrategy(new AimByRepeatingLastMove(this, enemy, isLearningToAimAllowed, Color.BLUE));
        enemy.addAimingStrategy(new AimForRecentLocation(this, enemy, isLearningToAimAllowed, Color.PINK));
        enemy.addAimingStrategy(new AimByInterpolatingStraightAhead(this, enemy, isLearningToAimAllowed, Color.GREEN));
        enemy.addAimingStrategy(new AimByMovementSequenceReplay(this, enemy, isLearningToAimAllowed, Color.ORANGE));
        enemy.addAimingStrategy(new AimForAverageLocation(this, enemy, isLearningToAimAllowed, 50L, 10, Color.CYAN));
        enemy.addAimingStrategy(new AimByRepeatingLastMoveImproved(this, enemy, isLearningToAimAllowed, Color.BLACK));
        enemy.addAimingStrategy(new AimBetweenFurthestPossibleForwardsAndBackwards(this, enemy, isLearningToAimAllowed, Color.WHITE));
        enemy.addAimingStrategy(new AimBySprayingAtLongDistance(this, enemy, isLearningToAimAllowed, Color.MAGENTA));
        enemy.addAimingStrategy(new AimUsingPerfectMovementsA(this, enemy, isLearningToAimAllowed, Color.RED));
        enemy.addShootingAtUsStrategy(new EnemyShootAtMyCurrentLocation(this, enemy));
        enemy.addShootingAtUsStrategy(new EnemyShootUsingRoughLinearInterpolation(this, enemy));
    }

    private void initializeStartMode() {
        this.battleMode = BattleModeType.START;
        this.setColoursForStartMode();
        if (this.getOthers() == 1) {
            this.navigateToCentre();
        } else {
            this.navigateToNearestCorner();
        }
        this.gunnerCommand = new GunnerDoNothing();
        this.radarCommand = new RadarFullScan(this);
        this.timeModeStarted = this.getTime();
    }

    private void operateStartMode() {
        if (this.radarCommand.isDone()) {
            if (this.getOthers() == 1) {
                this.initializeBestOneVersusOneMode();
            } else {
                this.initializeDefendMode();
            }
            return;
        }
    }

    private void setColoursForStartMode() {
        switch (colourScheme) {
            case AIMING_STRATEGY: 
            case BLACK_DEATH: {
                this.setAllColors(Color.black);
                this.setBulletColor(Color.red);
                break;
            }
            case ROBOT_STATE: {
                this.setBodyColor(Color.black);
                this.setRadarColor(Color.black);
                this.setDebugColour(Color.blue);
                break;
            }
            default: {
                this.setPanicColours();
            }
        }
    }

    private void navigateToNearestCorner() {
        this.navigatorCommand = this.getX() < this.getBattleFieldWidth() / 2.0 ? (this.getY() < this.getBattleFieldHeight() / 2.0 ? new NavigateToLocation(this.startBottomLeft, this) : new NavigateToLocation(this.startTopLeft, this)) : (this.getY() < this.getBattleFieldHeight() / 2.0 ? new NavigateToLocation(this.startBottomRight, this) : new NavigateToLocation(this.startTopRight, this));
    }

    private void navigateToCentre() {
        this.navigatorCommand = new NavigateToLocation(this.battleCentre, this);
    }

    private void initializeDefendMode() {
        this.battleMode = BattleModeType.DEFEND;
        this.currentEnemyTarget = null;
        this.setColoursForDefendMode();
        this.setupDefensiveFireWithRadar();
        this.navigateToSafePlace();
        this.timeModeStarted = this.getTime();
    }

    private void operateDefendMode() {
        if (this.underCloseAttack()) {
            this.myExpectedMotionPath = null;
            this.initializeEscapeMode();
            return;
        }
        if (this.safeToAttackNow()) {
            this.myExpectedMotionPath = null;
            this.initializeAttackMode();
            return;
        }
        if (this.isSafeToRam()) {
            this.myExpectedMotionPath = null;
            this.initializeRammingMode();
            return;
        }
        if (this.isSafeToPlayDead()) {
            this.myExpectedMotionPath = null;
            this.initializePlayDeadMode();
            return;
        }
        if (this.isSafeForChicken()) {
            this.myExpectedMotionPath = null;
            this.initializeChickenMode();
            return;
        }
        if (this.getGunNotFiredPeriod() > 0 && this.getGunNotFiredPeriod() % 20 == 0 && enemies.getNumberOfLiveEnemiesSeenSince(this.getTime()) < this.getOthers()) {
            this.radarCommand = new RadarFullScan(this);
        }
        if (this.getJustFired()) {
            this.radarCommand = new RadarFullScan(this);
        }
        if (this.radarCommand.isDone() || this.gunnerCommand.isDone()) {
            this.setupDefensiveFireWithRadar();
        }
        if (this.navigatorCommand.isDone() || this.closestNewBulletDistance < 250.0) {
            this.navigateToSafePlace();
        }
        if (this.getHitByBullet() && enemies.getAllLiveEnemiesCloserThan(this.getLocation(), 300.0).getNumberOfEnemies() == 0) {
            this.navigateToSafePlace(true);
        }
        if (enemies.getNumberOfLiveEnemiesSeenSince(this.getTime() - 10L) == 0 && this.getDangerousBullets().size() == 0 && this.getTime() - this.timeModeStarted > 30L) {
            this.initializeSearchMode();
            return;
        }
    }

    private void setColoursForDefendMode() {
        if (colourScheme == ColourScheme.ROBOT_STATE) {
            this.setDebugColour(Color.yellow);
        }
    }

    private void navigateToSafePlace() {
        this.navigateToSafePlace(false);
    }

    private void navigateToSafePlace(boolean forceRadicalChange) {
        double rootBearing;
        double velocity = 8.0;
        EnemySet liveEnemiesSeenRecently = this.getLiveEnemiesSeenRecently();
        double distance = velocity * 15.0;
        if (liveEnemiesSeenRecently.getAllLiveEnemiesCloserThan(this.getLocation(), 300.0).getNumberOfEnemies() > 0) {
            distance = velocity * 10.0;
        } else if (this.getOthers() == 1 && liveEnemiesSeenRecently.getNumberOfEnemies() == 1 && liveEnemiesSeenRecently.iterator().next().isAlwaysShootingAtCurrentLocation() && this.getLocation().getHowCloseToCorner() > 200.0) {
            velocity = 4.0;
        }
        int granularity = 2;
        double minimumDeviation = 20.0;
        double bestBearing = rootBearing = this.getHeading() + minimumDeviation;
        double bestRating = -9999999.0;
        double maximumOffsetToTry = 360.0 - 2.0 * minimumDeviation;
        for (double bearingOffset = 0.0; bearingOffset <= maximumOffsetToTry; bearingOffset += 45.0) {
            double rating = this.getTravelSafetyRating(rootBearing + bearingOffset, distance, granularity, velocity, false);
            if (!(rating > bestRating)) continue;
            bestRating = rating;
            bestBearing = rootBearing + bearingOffset;
        }
        boolean explain = false;
        this.getTravelSafetyRating(bestBearing, distance, granularity, velocity, false);
        Location targetLocation = Geometry.getLocationAtBearing(this.getLocation(), bestBearing, distance);
        this.navigatorCommand = new NavigateToLocation(targetLocation, this, velocity);
    }

    private void aimTowardsNearestEnemyForRamming(double bestBearing, double bestVelocity, double maxDistance) {
        EnemyRobot closestEnemy = this.getLiveEnemiesSeenRecently().getClosestLiveEnemy(this.getLocation());
        if (closestEnemy != null) {
            Location targetLocation = closestEnemy.getLatestRadarObservation().getLocation();
            if (Geometry.getDistanceBetweenLocations(this.getLocation(), targetLocation) > maxDistance) {
                double bearing = Geometry.getBearingBetweenLocations(this.getLocation(), targetLocation);
                targetLocation = Geometry.getLocationAtBearing(this.getLocation(), bearing, maxDistance);
            }
            this.navigatorCommand = new NavigateToLocation(targetLocation, this, 8.0);
        }
    }

    private double getTravelSafetyRating(double bearing, double distance, int granularity, double velocity, boolean explain) {
        if (explain) {
            this.myExpectedMotionPath = new ArrayList<Location>();
        }
        HashMap<DangerousBullet, Double> closestHits = new HashMap<DangerousBullet, Double>();
        Location target = Geometry.getLocationAtBearing(this.getLocation(), bearing, distance);
        double edgeRating = 0.0;
        double distanceFromEdge = target.getHowCloseToEdgeOfBattlefield();
        if (distanceFromEdge < this.getWidth() + this.getHeight()) {
            edgeRating = -999999.0 + distanceFromEdge * distanceFromEdge;
        }
        RobotMovementSimulator mySimulator = new RobotMovementSimulator(this.getLocation(), this.getHeading(), this.getVelocity(), this.getTime());
        NavigateToLocation navigator = new NavigateToLocation(target, mySimulator, velocity);
        int scoreFreq = 0;
        int timeTaken = 0;
        while (!navigator.isDone()) {
            navigator.executed();
            mySimulator.takeTurn(navigator.getRightTurn(), navigator.getAhead(), navigator.getVelocity());
            if (explain) {
                this.myExpectedMotionPath.add(mySimulator.getLocation());
            }
            ++timeTaken;
            if (++scoreFreq != granularity) continue;
            scoreFreq = 0;
            for (DangerousBullet bullet : this.getDangerousBullets()) {
                double howClose = Geometry.getDistanceBetweenLocations(mySimulator.getLocation(), bullet.getLocationAtTime(mySimulator.getTime()));
                Double existingHowClose = (Double)closestHits.get(bullet);
                if (existingHowClose != null && !(howClose < existingHowClose)) continue;
                closestHits.put(bullet, howClose);
            }
        }
        for (int extraHeading = -10; extraHeading <= 10; extraHeading += 10) {
            for (int extraTime = 0; extraTime <= 10; extraTime += granularity) {
                Location approxFutureLocation = Geometry.getLocationAtBearing(mySimulator.getLocation(), mySimulator.getHeading() + (double)extraHeading, (double)extraTime * mySimulator.getVelocity());
                for (DangerousBullet bullet : this.getDangerousBullets()) {
                    double howClose = Geometry.getDistanceBetweenLocations(approxFutureLocation, bullet.getLocationAtTime(mySimulator.getTime()));
                    Double existingHowClose = (Double)closestHits.get(bullet);
                    if (existingHowClose != null && !(howClose < existingHowClose)) continue;
                    closestHits.put(bullet, howClose);
                }
            }
        }
        double bulletHitRating = 0.0;
        for (Map.Entry entry : closestHits.entrySet()) {
            bulletHitRating -= this.getDamageCausedByDangerousBullet((DangerousBullet)entry.getKey(), (Double)entry.getValue());
        }
        if (explain) {
            System.out.println(Math.round(edgeRating) + "\t" + Math.round(bulletHitRating) + "\t" + Math.round(this.getMotionScoreAdjustment(this.getEnergy() / 50.0, velocity, bearing)) + "\t" + Math.round(this.getLocationSafetyRating(target, timeTaken)));
        }
        return edgeRating + bulletHitRating + this.getMotionScoreAdjustment(this.getEnergy() / 50.0, velocity, bearing) + this.getLocationSafetyRating(target, timeTaken);
    }

    private double getMotionScoreAdjustment(double maxScore, double velocity, double bearing) {
        double weighting = 0.0;
        double maxPossibleWeighting = 6.0;
        double changeOfHeading = Math.abs(Geometry.getRelativeBearing(bearing, this.getHeading()));
        double changeOfVelocity = Math.abs(this.getVelocity() - velocity);
        if (changeOfHeading >= 145.0) {
            weighting += 3.0;
        } else if (changeOfHeading >= 45.0) {
            weighting += 1.0;
        }
        return maxScore * (weighting += Math.min(3.0, changeOfVelocity / 2.0)) / maxPossibleWeighting;
    }

    private double getLocationSafetyRating(Location possibleLocation, int timeTaken) {
        EnemySet enemiesSeenRecently = this.getLiveEnemiesSeenRecently();
        if (enemiesSeenRecently.getNumberOfEnemies() == 1) {
            return this.getSingleEnemyLocationSafetyRating(possibleLocation, enemiesSeenRecently.getClosestLiveEnemy(possibleLocation), timeTaken);
        }
        return this.getMeleeLocationSafetyRating(possibleLocation, enemiesSeenRecently);
    }

    private double getSingleEnemyLocationSafetyRating(Location possibleLocation, EnemyRobot enemy, int timeTaken) {
        double possibleDistance1 = Geometry.getDistanceBetweenLocations(possibleLocation, enemy.getLatestRadarObservation().getLocation());
        double possibleDistance2 = possibleDistance1 - (double)timeTaken * 8.0;
        double futureDistance = Math.max(0.0, (possibleDistance1 + possibleDistance2) / 2.0);
        return this.getEnemySafetyRatingForDistance(futureDistance, enemy.getLatestRadarObservation().getEnergy()) - this.getLocationEdgeDanger(possibleLocation);
    }

    private double getLocationEdgeDanger(Location possibleLocation) {
        return 0.0;
    }

    private double getEnemySafetyRatingForDistance(double distance, double enemyEnergy) {
        double maxTargetDistance = 500.0;
        double minTargetDistance = 400.0;
        double distancePenalty = 50.0;
        if (distance < minTargetDistance) {
            return (distance - minTargetDistance) / 10.0 - 8.0;
        }
        if (distance > maxTargetDistance) {
            return (maxTargetDistance - distance) / distancePenalty;
        }
        return 0.0;
    }

    private double getSingleEnemyLocationSafetyRating_NEWBUTCRAP(Location possibleLocation, EnemyRobot enemy) {
        double distance = Geometry.getDistanceBetweenLocations(possibleLocation, enemy.getAverageLocation());
        double minDistance = Math.max(enemy.getOptimumAttackDistance() - 100.0, 200.0);
        double maxDistance = Math.min(enemy.getOptimumAttackDistance() + 50.0, 200.0);
        if (distance < minDistance) {
            return (distance - minDistance) / 10.0 - 8.0;
        }
        if (distance > maxDistance) {
            return (maxDistance - distance) / 25.0;
        }
        return 0.0;
    }

    private double getMeleeLocationSafetyRating(Location possibleLocation, EnemySet enemiesSeenRecently) {
        double dangerRating = enemiesSeenRecently.getTotalDangerEnergyWithGravity(600.0, possibleLocation);
        double targetRating = enemiesSeenRecently.getBestDoubleTargetEnergyWithGravity(400.0, possibleLocation);
        if (possibleLocation.getHowCloseToEdgeOfBattlefield(this.getBattleFieldWidth(), this.getBattleFieldHeight()) < edgeSafetyMargin) {
            dangerRating += enemies.getTotalDangerEnergy();
            targetRating /= 2.0;
        }
        return targetRating - dangerRating;
    }

    private void setupDefensiveFireWithRadar() {
        EnemyRobot closestEnemy = this.getLiveEnemiesSeenRecently().getBestShootingTarget(this.getLocation());
        if (closestEnemy != this.currentEnemyTarget) {
            this.currentEnemyTarget = closestEnemy;
            this.setGunnerToDefend(this.currentEnemyTarget);
        }
        this.setRadarToNarrowTrackEnemy(this.currentEnemyTarget);
    }

    private void setGunnerToDefend(EnemyRobot enemy) {
        if (enemy != null) {
            double fullPowerSuccess = Math.max(10, 20 - this.getLiveEnemiesSeenRecently().getNumberOfEnemies() * 4);
            int remainingBullets = 5;
            double shootingPowerDecayFactor = 1.0;
            this.gunnerCommand = new GunnerBlastEnemy(this, enemy, remainingBullets, fullPowerSuccess, shootingPowerDecayFactor);
        } else {
            this.gunnerCommand = new GunnerDoNothing();
        }
    }

    private boolean safeToAttackNow() {
        if (this.getOthers() <= 1) {
            return false;
        }
        double dangerEnergy = this.getLiveEnemiesSeenRecently().getTotalDangerEnergy();
        double maxDamageTwoBullets = Rules.getBulletDamage((double)3.0) * 2.0;
        return dangerEnergy < this.getEnergy() * aggressionFactor && dangerEnergy < (this.getEnergy() - maxDamageTwoBullets) * aggressionFactor * 1.3;
    }

    private void initializeAttackMode() {
        this.battleMode = BattleModeType.ATTACK;
        this.setColoursForAttackMode();
        this.setupEnemyFullAttack();
        this.timeModeStarted = this.getTime();
        this.haveAttacked = true;
    }

    private void operateAttackMode() {
        if (this.underCloseAttack()) {
            this.initializeEscapeMode();
            return;
        }
        if (this.gunnerCommand.isDone()) {
            this.setupEnemyFullAttack();
        }
        if (enemies.getNumberOfLiveEnemiesSeenSince(this.getTime() - 10L) == 0 && this.getTime() - this.timeModeStarted > 30L) {
            this.initializeSearchMode();
            return;
        }
        if (this.shouldAbortAttack()) {
            this.initializeDefendMode();
            return;
        }
        this.turnOnWiggleCloseToDangerousBullets(250.0);
        this.turnOffWiggleCloseToEnemy(150.0);
    }

    private void setColoursForAttackMode() {
        if (colourScheme == ColourScheme.ROBOT_STATE) {
            this.setDebugColour(Color.red);
        }
    }

    private void setupEnemyFullAttack() {
        EnemyRobot closestEnemy = this.getLiveEnemiesSeenRecently().getBestShootingTarget(this.getLocation());
        this.setGunnerToAttackEnemy(closestEnemy);
        this.setRadarToNarrowTrackEnemy(closestEnemy);
        this.setNavigatorToChaseEnemy(closestEnemy);
    }

    private boolean shouldAbortAttack() {
        if (this.attackConstantly) {
            return false;
        }
        return this.getOthers() == 1 || this.getLiveEnemiesSeenRecently().getTotalDangerEnergy() > this.getEnergy() * 1.3 * aggressionFactor;
    }

    private void turnOffWiggleCloseToEnemy(double closeDistance) {
        double enemyDistance;
        if (this.currentEnemyTarget != null && this.navigatorCommand.getWiggleFactor() > 0 && (enemyDistance = Geometry.getDistanceBetweenLocations(this.getLocation(), this.currentEnemyTarget.getLatestRadarObservation().getLocation())) <= closeDistance) {
            this.navigatorCommand.setWiggleFactor(0);
        }
    }

    private void turnOnWiggleCloseToDangerousBullets(double dangerDistance) {
        int minimumWiggle = (int)this.getDamageFromBulletsAtFutureLocation(this.getLocation(), dangerDistance);
        if (minimumWiggle > 0) {
            this.navigatorCommand.setWiggleFactor(minimumWiggle);
            this.navigatorCommand.setWiggleExpiry(this.getTime() + 100L);
        }
    }

    private void initializeEscapeMode() {
        this.battleMode = BattleModeType.ESCAPE;
        this.setColoursForEscapeMode();
        this.timeModeStarted = this.getTime();
        this.navigatorCommand = new NavigateToLocation(this.getEscapeLocation(), this);
        EnemyRobot target = this.getEscapeModeShootingTarget();
        this.setGunnerToAttackEnemyMaxPower(target);
        this.setRadarToNarrowTrackEnemy(target);
    }

    private void operateEscapeMode() {
        EnemyRobot target;
        if (!this.underCloseAttack()) {
            if (this.attackConstantly) {
                this.initializeAttackMode();
            } else {
                this.initializeDefendMode();
            }
            return;
        }
        if ((this.getGunHeat() / this.getGunCoolingRate() > 3.0 || this.gunnerCommand.isDone()) && (target = this.getEscapeModeShootingTarget()) != this.gunnerCommand.getEnemyTarget()) {
            this.setGunnerToAttackEnemyMaxPower(target);
            this.setRadarToNarrowTrackEnemy(target);
        }
        if (this.navigatorCommand.isDone() || (this.getTime() - this.timeModeStarted) % 5L == 0L) {
            this.navigatorCommand = new NavigateToLocation(this.getEscapeLocation(), this);
        }
    }

    private void setColoursForEscapeMode() {
        if (colourScheme == ColourScheme.ROBOT_STATE) {
            this.setDebugColour(Color.magenta);
        }
    }

    private Location getEscapeLocation() {
        double totalWeight = 0.0;
        BearingSelector bearingSelector = new BearingSelector(10);
        boolean isNearEdge = this.getLocation().getHowCloseToEdgeOfBattlefield() <= 150.0;
        for (EnemyRobot enemy : enemies.getAllLiveEnemiesCloserThan(this.getLocation(), 200.0)) {
            RadarObservation observation = enemy.getLatestRadarObservation();
            double weighting = Geometry.getDistanceBetweenLocations(observation.getLocation(), this.getLocation()) / 100.0;
            double bearing = Geometry.getBearingBetweenLocations(this.getLocation(), observation.getLocation());
            bearingSelector.add(bearing, weighting);
            totalWeight += weighting;
            if (isNearEdge || enemy.getTimeOfNextShot() > this.getTime() + 2L) continue;
            double diffA = Math.abs(Geometry.getRelativeBearing(this.getHeading() + 180.0, bearing));
            double diffB = Geometry.getRelativeBearing(this.getHeading(), observation.getHeading());
            if (!(diffA < 5.0) && !(diffA > 175.0) || !(diffB < 5.0) && !(diffB > 175.0)) continue;
            this.escapeLockTimer = 5;
        }
        if (this.getLocation().getX() < 150.0) {
            bearingSelector.add(270.0, totalWeight);
            this.escapeLockTimer = 0;
        }
        if (this.getLocation().getY() < 150.0) {
            bearingSelector.add(180.0, totalWeight);
            this.escapeLockTimer = 0;
        }
        if (this.getLocation().getX() > this.getBattleFieldWidth() - 150.0) {
            bearingSelector.add(90.0, totalWeight);
            this.escapeLockTimer = 0;
        }
        if (this.getLocation().getY() > this.getBattleFieldHeight() - 150.0) {
            bearingSelector.add(0.0, totalWeight);
            this.escapeLockTimer = 0;
        }
        double bearing = bearingSelector.getLowScoreBearing();
        if (this.escapeLockTimer > 0) {
            --this.escapeLockTimer;
            bearing += 90.0;
        }
        return Geometry.getLocationAtBearing(this.getLocation(), bearing, 50.0);
    }

    private Location getEscapeLocationV8() {
        double totalWeight = 0.0;
        BearingSelector bearingSelector = new BearingSelector(10);
        for (EnemyRobot enemy : enemies.getAllLiveEnemiesCloserThan(this.getLocation(), 150.0)) {
            RadarObservation observation = enemy.getLatestRadarObservation();
            double weighting = Math.abs(observation.getVelocity()) / 8.0 * 2.0 + 1.0;
            double bearing = Geometry.getBearingBetweenLocations(this.getLocation(), observation.getLocation());
            bearingSelector.add(bearing, weighting);
            totalWeight += weighting;
        }
        if (this.getLocation().getX() < 100.0) {
            bearingSelector.add(270.0, totalWeight);
        }
        if (this.getLocation().getY() < 100.0) {
            bearingSelector.add(180.0, totalWeight);
        }
        if (this.getLocation().getX() > this.getBattleFieldWidth() - 100.0) {
            bearingSelector.add(90.0, totalWeight);
        }
        if (this.getLocation().getY() > this.getBattleFieldHeight() - 100.0) {
            bearingSelector.add(0.0, totalWeight);
        }
        return Geometry.getLocationAtBearing(this.getLocation(), bearingSelector.getLowScoreBearing(), 50.0);
    }

    private EnemyRobot getEscapeModeShootingTarget() {
        return enemies.getClosestLiveEnemy(this.getLocation());
    }

    private EnemyRobot getEscapeModeShootingTargetV8() {
        return enemies.getClosestLiveEnemy(this.getLocation());
    }

    private boolean underCloseAttack() {
        EnemySet closeEnemies = enemies.getAllLiveEnemiesCloserThan(this.getLocation(), 150.0);
        return closeEnemies.getNumberOfEnemies() >= 1 && !this.isSafeToRam();
    }

    private void initializeSearchMode() {
        Location[] searchPattern = new Location[]{this.battleCentre, this.searchBottomLeft, this.searchTopLeft, this.searchTopRight, this.searchBottomRight, this.battleCentre};
        this.battleMode = BattleModeType.SEARCH;
        this.setColoursForSearchMode();
        this.timeModeStarted = this.getTime();
        this.navigatorCommand = new NavigateToLocations(searchPattern, this);
        this.gunnerCommand = new GunnerDoNothing();
        this.radarCommand = new RadarFullScan(this);
    }

    private void operateSearchMode() {
        if (this.radarCommand.isDone()) {
            this.radarCommand = new RadarFullScan(this);
            if (enemies.getNumberOfLiveEnemiesSeenSince(this.getTime() - 10L) > 0) {
                this.initializeDefendMode();
            }
        }
    }

    private void setColoursForSearchMode() {
        if (colourScheme == ColourScheme.ROBOT_STATE) {
            this.setDebugColour(Color.green);
        }
    }

    private void setGunnerToAttackEnemy(EnemyRobot enemy) {
        if (enemy != null) {
            double fullPowerSuccess = Math.max(10, 20 - this.getLiveEnemiesSeenRecently().getNumberOfEnemies() * 4);
            this.gunnerCommand = new GunnerBlastEnemy(this, enemy, 5, fullPowerSuccess, 0.9);
        } else {
            this.gunnerCommand = new GunnerDoNothing();
        }
    }

    private void setGunnerToAttackEnemyMaxPower(EnemyRobot enemy) {
        this.gunnerCommand = enemy != null ? new GunnerBlastEnemy(this, enemy, 5, 0.0, 1.0) : new GunnerDoNothing();
    }

    private void setRadarToNarrowTrackEnemy(EnemyRobot enemy) {
        this.radarCommand = enemy != null ? new RadarNarrowLock(enemy, this) : new RadarFullScan(this);
    }

    private void setNavigatorToChaseEnemy(EnemyRobot enemy) {
        if (enemy != null) {
            double safeDistanceFromEnemy = Math.min((this.getBattleFieldHeight() + this.getBattleFieldWidth()) / 6.0, 200.0);
            EnemyTargetDefault targetAlgorithm = new EnemyTargetDefault(enemy, this, safeDistanceFromEnemy);
            this.navigatorCommand = new NavigateToEnemy(enemy, this, targetAlgorithm);
        }
    }

    private EnemySet getLiveEnemiesSeenRecently() {
        return enemies.getLiveEnemiesSeenSince(this.getTime() - 50L);
    }

    private double getDamageFromBulletsAtFutureLocation(Location location, double safeDistance) {
        long myTravelTime = (long)(Geometry.getDistanceBetweenLocations(this.getLocation(), location) / 8.0);
        long futureTime = this.getTime() + myTravelTime;
        double totalDamage = 0.0;
        for (DangerousBullet bullet : this.getDangerousBullets()) {
            double distance = Geometry.getDistanceBetweenLocations(location, bullet.getLocationAtTime(futureTime));
            totalDamage += this.getDamageCausedByDangerousBullet(bullet, distance);
        }
        return totalDamage;
    }

    private double getDamageCausedByDangerousBulletBEST(DangerousBullet bullet, double distanceFromUs) {
        double safeBulletDistance = Geometry.getDistanceBetweenLocations(this.getLocation(), bullet.getFiredFromLocation()) / 3.0;
        if (distanceFromUs <= safeBulletDistance) {
            double predictedDamage = bullet.getDamage() * (1.0 - (distanceFromUs - 50.0) / safeBulletDistance) * bullet.getLikelyToBeAimingForUs() / 100.0 * bullet.getShootingStrategy().getWeightedChanceOfHit() / 50.0;
            return predictedDamage;
        }
        return 0.0;
    }

    private double getDamageCausedByDangerousBullet(DangerousBullet bullet, double distanceFromUs) {
        double safeBulletDistance = Geometry.getDistanceBetweenLocations(this.getLocation(), bullet.getFiredFromLocation()) / 3.0;
        if (distanceFromUs <= safeBulletDistance) {
            double predictedDamage = bullet.getDamage() * (1.0 - (distanceFromUs - 50.0) / safeBulletDistance) * bullet.getLikelyToBeAimingForUs() / 100.0 * bullet.getShootingStrategy().getWeightedChanceOfHit() / 50.0;
            if (distanceFromUs <= Math.max(this.getWidth(), this.getHeight()) && bullet.getShootingStrategy().getWeightedChanceOfHit() >= 80.0) {
                predictedDamage *= 2.0;
            }
            return predictedDamage;
        }
        return 0.0;
    }

    private void setDebugColour(Color colour) {
        this.setGunColor(colour);
        this.setBulletColor(colour);
        this.setScanColor(colour);
    }

    private void initializeBestOneVersusOneMode() {
        this.initializeAttackMode();
    }

    private void initializeChickenMode() {
        this.battleMode = BattleModeType.CHICKEN;
        this.setColoursForChickenMode();
        this.timeModeStarted = this.getTime();
        EnemyRobot target = enemies.getClosestLiveEnemy(this.getLocation());
        this.setupChickenModeNavigator(target);
        this.setGunnerToAttackEnemyMaxPower(target);
        this.setRadarToNarrowTrackEnemy(target);
        double distance = Geometry.getDistanceBetweenLocations(target.getLatestRadarObservation().getLocation(), this.getLocation());
        this.chickenLength = distance > 500.0 ? Math.round(Geometry.getDistanceBetweenLocations(target.getLatestRadarObservation().getLocation(), this.getLocation()) / Rules.getBulletSpeed((double)2.0)) : 20L;
        this.chickenLength = 200L;
    }

    private void setColoursForChickenMode() {
        if (colourScheme == ColourScheme.ROBOT_STATE) {
            this.setDebugColour(Color.white);
        }
    }

    private void operateChickenMode() {
        if (this.underCloseAttack()) {
            this.initializeEscapeMode();
        }
        if (this.isSafeToPlayDead()) {
            this.initializePlayDeadMode();
        }
        if (enemies.getClosestLiveEnemy(this.getLocation()) != this.gunnerCommand.getEnemyTarget() || this.getLocation().getHowCloseToEdgeOfBattlefield() < 80.0 || this.getTime() - this.timeModeStarted > this.chickenLength) {
            this.initializeDefendMode();
        }
    }

    private void setupChickenModeNavigator(EnemyRobot target) {
        this.navigatorCommand = new NavigateRightAnglesToEnemy(target, this, 2.0);
    }

    private void initializePlayDeadMode() {
        this.battleMode = BattleModeType.PLAY_DEAD;
        this.setColoursForPlayDeadMode();
        this.timeModeStarted = this.getTime();
        this.timeWhenLastHitWhenPlayingDead = this.getTime();
        EnemyRobot target = enemies.getClosestLiveEnemy(this.getLocation());
        this.setupPlayDeadModeNavigator(target);
        this.gunnerCommand = new GunnerDoNothing();
        this.setRadarToNarrowTrackEnemy(target);
    }

    private void setColoursForPlayDeadMode() {
        if (colourScheme == ColourScheme.ROBOT_STATE) {
            this.setDebugColour(Color.black);
        }
    }

    private void operatePlayDeadMode() {
        if (!this.isSafeToPlayDead()) {
            this.initializeDefendMode();
        }
        if (this.timeWhenLastHitWhenPlayingDead == this.getTime() - 150L) {
            this.navigatorCommand = new NavigateToRamEnemy(this.currentEnemyTarget, this);
        }
    }

    private void setupPlayDeadModeNavigator(EnemyRobot target) {
        this.navigatorCommand = new NavigateRightAnglesToEnemy(target, this, 0.0);
    }

    void debugCheckDistanceOfAllEnemies() {
        EnemySet close200 = this.getLiveEnemiesSeenRecently().getAllLiveEnemiesCloserThan(this.getLocation(), 200.0);
        EnemySet close300 = this.getLiveEnemiesSeenRecently().getAllLiveEnemiesCloserThan(this.getLocation(), 300.0);
        System.out.println("Enemies closer than 200 pixels : " + close200.getNumberOfEnemies());
        System.out.println("Enemies closer than 300 pixels : " + close300.getNumberOfEnemies());
    }

    private boolean isSafeForChicken() {
        return false;
    }

    private boolean isSafeForChickenORIG() {
        return this.getTime() - this.timeModeStarted >= 20L && enemies.getNumberOfLiveEnemiesSeenSince(this.getTime() - 30L) == 1 && this.getVelocity() >= 4.0 && this.getEnergy() >= 20.0 && this.getLocation().getHowCloseToEdgeOfBattlefield() > 80.0 && this.isNoDangerousBulletCloserThan(250.0) && enemies.getAllLiveEnemiesCloserThan(this.getLocation(), 350.0).getNumberOfEnemies() == 0;
    }

    private boolean isNoDangerousBulletCloserThan(double limit) {
        for (DangerousBullet bullet : this.getDangerousBullets()) {
            if (!(Geometry.getDistanceBetweenLocations(bullet.getLocationAtTime(this.getTime()), this.getLocation()) < limit) || !(bullet.getShootingStrategy().getWeightedChanceOfHit() >= 30.0)) continue;
            return true;
        }
        return false;
    }

    private boolean isSafeToPlayDeadOFF() {
        return false;
    }

    private boolean isSafeToPlayDead() {
        return this.currentEnemyTarget != null && this.getOthers() == 1 && this.getEnergy() >= 50.0 && this.getEnemies().getNumberOfEnemies() >= 8 && this.currentEnemyTarget.getLatestRadarObservation().getTimeSeen() >= this.getTime() - 20L && this.currentEnemyTarget.getDamageRatio() >= 10.0 && this.currentEnemyTarget.getLatestRadarObservation().getEnergy() - this.getEnergy() < this.currentEnemyTarget.getDamageRatio() / 4.0;
    }

    private void initializeRammingMode() {
        this.battleMode = BattleModeType.RAMMING;
        this.setColoursForRammingMode();
        this.timeModeStarted = this.getTime();
        EnemyRobot target = enemies.getClosestLiveEnemy(this.getLocation());
        this.navigatorCommand = new NavigateToRamEnemy(target, this);
        this.gunnerCommand = new GunnerDoNothing();
        this.setRadarToNarrowTrackEnemy(target);
    }

    private void setColoursForRammingMode() {
        if (colourScheme == ColourScheme.ROBOT_STATE) {
            this.setDebugColour(Color.CYAN);
        }
    }

    private void operateRammingMode() {
        if (this.getHitByBullet() && !this.isSafeToRam() || this.getTime() - this.timeModeStarted > 300L) {
            this.initializeEscapeMode();
            return;
        }
        if (this.navigatorCommand.isDone()) {
            EnemyRobot target = enemies.getClosestLiveEnemy(this.getLocation());
            if (target == null) {
                this.initializeSearchMode();
                return;
            }
            this.navigatorCommand = new NavigateToRamEnemy(target, this);
            this.setRadarToNarrowTrackEnemy(target);
        }
    }

    private boolean isSafeToRam() {
        if (this.getDangerousBullets().isEmpty() && this.getLiveEnemiesSeenRecently().getNumberOfEnemies() > 0) {
            double maxDamagePerBullet = Rules.getBulletDamage((double)3.0);
            return this.getEnemies().getEnemiesWithAtLeastEnergy(2.0).getNumberOfEnemies() == 0 && this.getEnergy() > maxDamagePerBullet || this.getEnemies().getEnemiesWithAtLeastEnergy(0.1).getNumberOfEnemies() == 0 && this.getEnergy() > (double)(this.getOthers() * 2) + 0.5;
        }
        return false;
    }

    private static enum BattleModeType {
        START,
        DEFEND,
        ATTACK,
        SEARCH,
        ESCAPE,
        CHICKEN,
        RAMMING,
        PLAY_DEAD;

    }

    private static enum ColourScheme {
        BLACK_DEATH,
        ROBOT_STATE,
        AIMING_STRATEGY,
        PANIC;

    }
}

