/*
 * Decompiled with CFR 0.152.
 */
package wiki.mini;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.DeathEvent;
import robocode.RobocodeFileOutputStream;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class Griffon
extends AdvancedRobot {
    private static final double MAX_VELOCITY = 8.0;
    private static final int DISTANCE_SEGMENTS = 5;
    private static final int ACCEL_SEGMENTS = 3;
    private static final int AIM_FACTORS = 19;
    private static final double STAND_OFF_DISTANCE = 600.0;
    private static final double WALL_AVOIDANCE_FACTOR = 50.0;
    private static final double MOVEMENT_DISTANCE = 40.0;
    private static Point2D robotLocation = new Point2D.Double();
    private static Point2D oldRobotLocation = new Point2D.Double();
    private static Point2D oldEnemyLocation = new Point2D.Double();
    private static Point2D enemyLocation = new Point2D.Double();
    private static String enemyName = "";
    private static double enemyEnergy;
    private static double enemyDistance;
    private static double enemyAbsoluteBearing;
    private static double maxEnemyBearing;
    private static double oldDeltaBearing;
    private static double deltaBearing;
    private static int[][][] aimFactors;
    private static int direction;
    private static Rectangle2D.Double field;
    private static long time;
    private int[] currentAimFactors;
    private long nextTime;

    public void run() {
        this.setColors(Color.red, Color.blue, Color.yellow);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        field = new Rectangle2D.Double(18.0, 18.0, this.getBattleFieldWidth() - 36.0, this.getBattleFieldHeight() - 36.0);
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        time = this.getTime();
        double d = enemyEnergy - scannedRobotEvent.getEnergy();
        enemyEnergy = scannedRobotEvent.getEnergy();
        if (enemyName == "") {
            enemyName = scannedRobotEvent.getName();
            this.restoreFactors();
        }
        oldRobotLocation.setLocation(robotLocation);
        double d2 = this.getX();
        double d3 = this.getY();
        robotLocation.setLocation(d2, d3);
        enemyAbsoluteBearing = this.getHeadingRadians() + scannedRobotEvent.getBearingRadians();
        enemyDistance = scannedRobotEvent.getDistance();
        oldEnemyLocation.setLocation(enemyLocation);
        enemyLocation.setLocation(d2 + Math.sin(enemyAbsoluteBearing) * enemyDistance, d3 + Math.cos(enemyAbsoluteBearing) * enemyDistance);
        oldDeltaBearing = deltaBearing;
        deltaBearing = Utils.normalRelativeAngle((double)(this.absoluteBearing(oldRobotLocation, enemyLocation) - this.absoluteBearing(oldRobotLocation, oldEnemyLocation)));
        double d4 = Math.min(this.getEnergy() / 5.0, Math.min(enemyEnergy / 4.0, 2.2));
        maxEnemyBearing = Math.abs(Math.asin(8.0 / (20.0 - 3.0 * d4)));
        this.currentAimFactors = aimFactors[this.aimAccelSegment()][Math.min((int)(enemyDistance / (this.getBattleFieldWidth() / 5.0)), 4)];
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing + maxEnemyBearing * (double)this.sign(deltaBearing) * this.mostVisitedFactor() - this.getGunHeadingRadians())));
        if (enemyEnergy > 0.0 && (this.getEnergy() > 1.5 || enemyDistance < 200.0) && this.setFireBullet(d4) != null) {
            this.addCustomEvent(new Wave(20.0 - 3.0 * d4));
        }
        if (d >= 0.1 && d <= 3.0 && time > this.nextTime) {
            this.setMaxVelocity(1.0 + Math.random() * 15.0);
            double d5 = Math.random();
            double d6 = enemyDistance <= 100.0 ? 0.1 : (enemyDistance <= 200.0 ? 0.25 : (enemyDistance <= 300.0 ? 0.349 : (enemyDistance <= 400.0 ? 0.437 : (enemyDistance <= 500.0 ? 0.51 : 0.59))));
            if (d5 > d6) {
                this.reverseDirection();
            }
            this.resetTurnFactor(d);
        }
        if (this.out(d2, d3, this.getHeadingRadians(), 40.0 * (double)direction)) {
            this.reverseDirection();
            this.resetTurnFactor(d);
            this.setMaxVelocity(1.0 + Math.random() * 15.0);
        }
        this.setAhead(40.0 * (double)direction);
        this.setTurnRightRadians(scannedRobotEvent.getBearingRadians() + (enemyEnergy > 0.0 ? 1.5707963267948966 + 0.2618 * (double)direction * (double)(enemyDistance > 600.0 || this.isCornered() || this.nearWall(d2, d3, 50.0) ? -1 : 1) : 0.5));
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.getRadarHeadingRadians())) * 2.0);
    }

    public void onWin(WinEvent winEvent) {
        this.saveFactors();
    }

    public void onDeath(DeathEvent deathEvent) {
        this.saveFactors();
    }

    void reverseDirection() {
        direction *= -1;
    }

    void resetTurnFactor(double d) {
        this.nextTime = time + (long)(enemyDistance / (20.0 - 3.0 * d) * 0.6);
    }

    double mostVisitedFactor() {
        int n = 9;
        int n2 = 0;
        while (n2 < 19) {
            if (this.currentAimFactors[n2] > this.currentAimFactors[n]) {
                n = n2;
            }
            ++n2;
        }
        return ((double)n - 9.0) / 9.0;
    }

    private final int aimAccelSegment() {
        int n = (int)Math.round(400.0 * (Math.abs(deltaBearing) - Math.abs(oldDeltaBearing)));
        if (n < 0) {
            return 0;
        }
        if (n > 0) {
            return 2;
        }
        return 1;
    }

    private final int sign(double d) {
        return d > 0.0 ? 1 : -1;
    }

    private final double absoluteBearing(Point2D point2D, Point2D point2D2) {
        return Math.atan2(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
    }

    void restoreFactors() {
        try {
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(this.getDataFile(enemyName + ".zip")));
            zipInputStream.getNextEntry();
            ObjectInputStream objectInputStream = new ObjectInputStream(zipInputStream);
            aimFactors = (int[][][])objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            aimFactors = new int[3][5][19];
        }
    }

    void saveFactors() {
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile(enemyName + ".zip")));
            zipOutputStream.putNextEntry(new ZipEntry("aimFactors"));
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(zipOutputStream);
            objectOutputStream.writeObject(aimFactors);
            objectOutputStream.flush();
            zipOutputStream.closeEntry();
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    boolean isCornered() {
        return robotLocation.distance(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0) > 0.85 * Point2D.distance(0.0, 0.0, this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0);
    }

    public boolean nearWall(double d, double d2, double d3) {
        return d3 > Math.min(Math.min(d - 18.0, this.getBattleFieldWidth() - 36.0 - d), Math.min(d2 - 18.0, this.getBattleFieldHeight() - 36.0 - d2));
    }

    public boolean out(double d, double d2, double d3, double d4) {
        return !field.contains(Math.sin(d3) * d4 + d, Math.cos(d3) * d4 + d2);
    }

    static /* synthetic */ int access$7() {
        return AIM_FACTORS;
    }

    static {
        aimFactors = new int[3][5][19];
        direction = 1;
    }

    class Wave
    extends Condition {
        private long wTime;
        private double bulletVelocity;
        private double bearingDelta;
        private Point2D oldRLocation = new Point2D.Double();
        private Point2D oldELocation = new Point2D.Double();
        private double maxBearing;
        int[] wAimFactors;

        public boolean test() {
            if (this.bulletVelocity * (double)(time - this.wTime) > this.oldRLocation.distance(enemyLocation) - 10.0) {
                double d = Utils.normalRelativeAngle((double)(Griffon.this.absoluteBearing(this.oldRLocation, enemyLocation) - Griffon.this.absoluteBearing(this.oldRLocation, this.oldELocation)));
                int n = (int)Math.round(Math.max(0.0, Math.min(18.0, (double)Griffon.this.sign(this.bearingDelta) * d / this.maxBearing * 18.0 / 2.0 + 9.0)));
                this.wAimFactors[n] = this.wAimFactors[n] + 1;
                Griffon.this.removeCustomEvent(this);
            }
            return false;
        }

        public Wave(double d) {
            this.wTime = time;
            this.bulletVelocity = d;
            this.bearingDelta = deltaBearing;
            this.oldRLocation.setLocation(robotLocation);
            this.oldELocation.setLocation(enemyLocation);
            this.maxBearing = maxEnemyBearing;
            this.wAimFactors = Griffon.this.currentAimFactors;
        }
    }
}

