/*
 * Decompiled with CFR 0.152.
 */
package kid.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;
import kid.cluster.Dimension;
import kid.cluster.Vector;
import kid.data.Data;
import kid.segmentation.Segmentable;
import kid.utils.Utils;

public class Cluster<E extends Data> {
    private Collection<E> cluster = new LinkedList();
    private int size;

    public Cluster(int s) {
        this.size = s;
    }

    public <F extends Segmentable, G extends Segmentable> Cluster(ArrayList<Dimension<E, F, G>> dimensions, F view, G reference, int s) {
        this(s);
        this.buildCluster(dimensions, view, reference);
    }

    public Collection<E> getCluster() {
        return this.cluster;
    }

    public <F extends Segmentable, G extends Segmentable> void buildCluster(ArrayList<Dimension<E, F, G>> dimensions, F view, G reference) {
        this.cluster = Cluster.createCluster(dimensions, view, reference, this.size);
    }

    public static <E extends Data, F extends Segmentable, G extends Segmentable> Collection<E> createCluster(ArrayList<Dimension<E, F, G>> dimensions, F view, G reference, int size) {
        Vector vector;
        Vector<Object, F, G> match = new Vector<Object, F, G>(null, view, reference);
        LinkedList<Vector> nearestMatches = new LinkedList<Vector>();
        for (Dimension<E, F, G> d : dimensions) {
            for (Vector vector2 : d.getList(view, reference, size)) {
                nearestMatches.add(vector2);
            }
        }
        LinkedList bestMatches = new LinkedList();
        while ((vector = (Vector)nearestMatches.pollFirst()) != null) {
            double d = 0.0;
            for (Dimension<Object, F, G> dimension : dimensions) {
                d += Utils.sqr(dimension.dist(match, vector));
            }
            ListIterator listIterator = bestMatches.listIterator();
            boolean added = false;
            while (listIterator.hasNext() && !added) {
                Entry v = (Entry)listIterator.next();
                if (vector.getData() == v.data) {
                    added = true;
                    continue;
                }
                if (!(d < v.value)) continue;
                listIterator.previous();
                listIterator.add(new Entry(vector.getData(), d));
                added = true;
            }
            if (listIterator.nextIndex() < size && !added) {
                listIterator.add(new Entry(vector.getData(), d));
            }
            if (bestMatches.size() <= size) continue;
            bestMatches.removeLast();
        }
        LinkedList linkedList = new LinkedList();
        for (Entry v : bestMatches) {
            linkedList.add(v.data);
        }
        return linkedList;
    }

    private static class Entry<E extends Data> {
        protected E data;
        protected double value;

        public Entry(E d, double v) {
            this.data = d;
            this.value = v;
        }
    }
}

